/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.providers.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.CompositeLayoutProvider;

public abstract class CompoundLayoutProvider
extends CompositeLayoutProvider {
    @Override
    protected NodeList build_nodes(List selectedObjects, Map editPartToNodeDict, Subgraph rootGraph) {
        ListIterator li = selectedObjects.listIterator();
        NodeList nodes = new NodeList();
        while (li.hasNext()) {
            IGraphicalEditPart gep = (IGraphicalEditPart)li.next();
            boolean hasChildren = this.hasChildren(gep);
            if (gep instanceof IBorderItemEditPart || !(gep instanceof ShapeEditPart) && !(gep instanceof ShapeCompartmentEditPart)) continue;
            GraphicalEditPart ep = (GraphicalEditPart)gep;
            Point position = ep.getFigure().getBounds().getLocation();
            if (this.minX == -1) {
                this.minX = position.x;
                this.minY = position.y;
            } else {
                this.minX = Math.min(this.minX, position.x);
                this.minY = Math.min(this.minY, position.y);
            }
            Object n = null;
            n = hasChildren ? (rootGraph != null ? new Subgraph((Object)ep, rootGraph) : new Subgraph((Object)ep)) : (rootGraph != null ? new Node((Object)ep, rootGraph) : new Node((Object)ep));
            this.adjustNodePadding((Node)n, editPartToNodeDict);
            Dimension size = ep.getFigure().getBounds().getSize();
            this.setNodeMetrics((Node)n, new Rectangle(position.x, position.y, size.width, size.height));
            editPartToNodeDict.put(ep, n);
            nodes.add(n);
            if (!hasChildren) continue;
            nodes.addAll((Collection)this.build_nodes(gep.getChildren(), editPartToNodeDict, (Subgraph)n));
        }
        return nodes;
    }

    @Override
    protected DirectedGraphLayout createGraphLayout() {
        return new CompoundDirectedGraphLayout();
    }

    @Override
    protected Command createNodeChangeBoundCommands(DirectedGraph g, Point diff) {
        CompoundCommand cc = new CompoundCommand("");
        ListIterator vi = ((CompoundDirectedGraph)g).subgraphs.listIterator();
        this.createSubCommands(diff, vi, cc);
        vi = g.nodes.listIterator();
        this.createSubCommands(diff, vi, cc);
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    @Override
    protected void postProcessGraph(DirectedGraph g, Hashtable editPartToNodeDict) {
        EdgeList edges = g.edges;
        NodeList nodes = g.nodes;
        virtualNodesToNodes virtualNodesNodes = new virtualNodesToNodes();
        for (Edge element : edges) {
            Node source = element.source;
            Node target = element.target;
            boolean sourceHandled = true;
            boolean targetHandled = true;
            Subgraph sg = virtualNodesNodes.getVirtualContainer(source);
            Subgraph sg1 = virtualNodesNodes.getVirtualContainer(target);
            if (sg == null) {
                sourceHandled = false;
                sg = sg1;
            }
            if (sg1 == null) {
                targetHandled = false;
            }
            if (!sourceHandled && !targetHandled) {
                sg = new Subgraph(null, source.getParent());
                sg.setPadding(new Insets(0));
                nodes.add((Object)sg);
            }
            if (!sourceHandled) {
                this.addNode(sg, source);
                virtualNodesNodes.addNode(sg, source);
            }
            if (targetHandled) continue;
            this.addNode(sg, target);
            virtualNodesNodes.addNode(sg, target);
        }
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Edge element;
            element = (Node)iter.next();
            if (element.getParent() == null || !(element instanceof Subgraph) || element.data != null || element.getParent().members.size() != 1) continue;
            Subgraph sg = (Subgraph)element;
            sg.getParent().members.remove(0);
            sg.getParent().members.addAll((Collection)sg.members);
            for (Node node : sg.getParent().members) {
                node.setParent(sg.getParent());
            }
            iter.remove();
        }
    }

    private void addNode(Subgraph parent, Node node) {
        if (node.getParent() != null) {
            node.getParent().members.remove((Object)node);
        }
        node.setParent(parent);
        parent.addMember(node);
    }

    private class virtualNodesToNodes
    extends HashMap {
        private static final long serialVersionUID = 8408938537765815482L;
        Set virtualNodes = new HashSet();

        private virtualNodesToNodes() {
        }

        public void addNode(Subgraph sg, Node node) {
            this.virtualNodes.add(sg);
            this.put(node, sg);
        }

        public Subgraph getVirtualContainer(Node node) {
            return (Subgraph)this.get(node);
        }
    }
}

