/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.api.errors.AbortedByHookException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.hooks.PrePushHook;
import org.eclipse.jgit.lfs.Lfs;
import org.eclipse.jgit.lfs.LfsPointer;
import org.eclipse.jgit.lfs.Protocol;
import org.eclipse.jgit.lfs.errors.CorruptMediaFile;
import org.eclipse.jgit.lfs.internal.LfsConnectionFactory;
import org.eclipse.jgit.lfs.internal.LfsText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.http.HttpConnection;

public class LfsPrePushHook
extends PrePushHook {
    private static final String EMPTY = "";
    private Collection<RemoteRefUpdate> refs;

    public LfsPrePushHook(Repository repo, PrintStream outputStream) {
        super(repo, outputStream);
    }

    public LfsPrePushHook(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        super(repo, outputStream, errorStream);
    }

    public void setRefs(Collection<RemoteRefUpdate> toRefs) {
        this.refs = toRefs;
    }

    public String call() throws IOException, AbortedByHookException {
        Set<LfsPointer> toPush = this.findObjectsToPush();
        if (toPush.isEmpty()) {
            return EMPTY;
        }
        HttpConnection api = LfsConnectionFactory.getLfsConnection(this.getRepository(), "POST", "upload");
        if (!this.isDryRun()) {
            Map<String, LfsPointer> oid2ptr = this.requestBatchUpload(api, toPush);
            this.uploadContents(api, oid2ptr);
        }
        return EMPTY;
    }

    private Set<LfsPointer> findObjectsToPush() throws IOException, MissingObjectException, IncorrectObjectTypeException {
        TreeSet<LfsPointer> toPush = new TreeSet<LfsPointer>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectWalk walk = new ObjectWalk(this.getRepository());){
            for (RemoteRefUpdate up : this.refs) {
                if (up.isDelete()) continue;
                walk.setRewriteParents(false);
                this.excludeRemoteRefs(walk);
                walk.markStart(walk.parseCommit((AnyObjectId)up.getNewObjectId()));
                while (walk.next() != null) {
                }
                LfsPrePushHook.findLfsPointers(toPush, walk);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return toPush;
    }

    private static void findLfsPointers(Set<LfsPointer> toPush, ObjectWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject obj;
        ObjectReader r = walk.getObjectReader();
        while ((obj = walk.nextObject()) != null) {
            LfsPointer ptr;
            if (obj.getType() != 3 || LfsPrePushHook.getObjectSize(r, obj) >= 200L || (ptr = LfsPrePushHook.loadLfsPointer(r, (AnyObjectId)obj)) == null) continue;
            toPush.add(ptr);
        }
    }

    private static long getObjectSize(ObjectReader r, RevObject obj) throws IOException {
        return r.getObjectSize((AnyObjectId)obj.getId(), 3);
    }

    private static LfsPointer loadLfsPointer(ObjectReader r, AnyObjectId obj) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectStream is = r.open(obj, 3).openStream();){
            return LfsPointer.parseLfsPointer((InputStream)is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void excludeRemoteRefs(ObjectWalk walk) throws IOException {
        RefDatabase refDatabase = this.getRepository().getRefDatabase();
        List remoteRefs = refDatabase.getRefsByPrefix(this.remote());
        for (Ref r : remoteRefs) {
            RevObject o;
            ObjectId oid = r.getPeeledObjectId();
            if (oid == null) {
                oid = r.getObjectId();
            }
            if (oid == null || (o = walk.parseAny((AnyObjectId)oid)).getType() != 1 && o.getType() != 4) continue;
            walk.markUninteresting(o);
        }
    }

    private String remote() {
        String remoteName = this.getRemoteName() == null ? "origin" : this.getRemoteName();
        return "refs/remotes/" + remoteName;
    }

    private Map<String, LfsPointer> requestBatchUpload(HttpConnection api, Set<LfsPointer> toPush) throws IOException {
        LfsPointer[] res = toPush.toArray(new LfsPointer[0]);
        HashMap<String, LfsPointer> oidStr2ptr = new HashMap<String, LfsPointer>();
        LfsPointer[] lfsPointerArray = res;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            LfsPointer p = lfsPointerArray[n2];
            oidStr2ptr.put(p.getOid().name(), p);
            ++n2;
        }
        Gson gson = Protocol.gson();
        api.getOutputStream().write(gson.toJson((Object)LfsConnectionFactory.toRequest("upload", res)).getBytes(StandardCharsets.UTF_8));
        int responseCode = api.getResponseCode();
        if (responseCode != 200) {
            throw new IOException(MessageFormat.format(LfsText.get().serverFailure, api.getURL(), responseCode));
        }
        return oidStr2ptr;
    }

    private void uploadContents(HttpConnection api, Map<String, LfsPointer> oid2ptr) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(api.getInputStream(), StandardCharsets.UTF_8));){
            for (Protocol.ObjectInfo o : this.parseObjects(reader)) {
                Protocol.Action uploadAction;
                LfsPointer ptr;
                if (o.actions == null || (ptr = oid2ptr.get(o.oid)) == null || (uploadAction = o.actions.get("upload")) == null || uploadAction.href == null) continue;
                Lfs lfs = new Lfs(this.getRepository());
                Path path = lfs.getMediaFile(ptr.getOid());
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new IOException(MessageFormat.format(LfsText.get().missingLocalObject, path));
                }
                this.uploadFile(o, uploadAction, path);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<Protocol.ObjectInfo> parseObjects(JsonReader reader) {
        Gson gson = new Gson();
        Protocol.Response resp = (Protocol.Response)gson.fromJson(reader, Protocol.Response.class);
        return resp.objects;
    }

    private void uploadFile(Protocol.ObjectInfo o, Protocol.Action uploadAction, Path path) throws IOException, CorruptMediaFile {
        HttpConnection contentServer = LfsConnectionFactory.getLfsContentConnection(this.getRepository(), uploadAction, "PUT");
        contentServer.setDoOutput(true);
        contentServer.setChunkedStreamingMode(262144);
        Throwable throwable = null;
        Object var6_8 = null;
        try (OutputStream out = contentServer.getOutputStream();){
            long size = Files.copy(path, out);
            if (size != o.size) {
                throw new CorruptMediaFile(path, o.size, size);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int responseCode = contentServer.getResponseCode();
        if (responseCode != 200 && responseCode != 201) {
            throw new IOException(MessageFormat.format(LfsText.get().serverFailure, contentServer.getURL(), responseCode));
        }
    }
}

