/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.DefaultingUtils;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.ProjectTopologyContext;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ui.common.ComboWithHistory;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ProjectSelectionWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private boolean needEAR_;
    private TypeRuntimeServer trsIds_;
    private Listener statusListener_;
    private Text messageText_;
    private boolean isClient_ = false;
    private byte CREATE_PROJECT = 1;
    private byte CREATE_EAR = (byte)2;
    private byte ADD_EAR_ASSOCIATION = (byte)4;
    private Composite parent_;
    private Combo moduleProject_;
    private Label earProjectLabel_;
    private Combo earProject_;
    private Combo projectType_;
    private String[] templates_;
    private ModifyListener projectTypeListener_;
    private ModifyListener moduleProjectListener_;
    private ModifyListener earProjectListener_;
    private String INFOPOP_PWRS_COMBO_PROJECT = "PWRS0016";
    private String INFOPOP_PWRS_COMBO_CLIENT_PROJECT_TYPE = "PWRS0018";
    private String INFOPOP_PWRS_COMBO_SERVICE_PROJECT_TYPE = "PWRS0020";

    public ProjectSelectionWidget() {
    }

    public ProjectSelectionWidget(boolean isClient) {
        this.isClient_ = isClient;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.parent_ = parent;
        UIUtils uiUtils = new UIUtils(this.pluginId_);
        this.statusListener_ = statusListener;
        boolean isOSGISelected = this.isOSGISelected();
        if (this.isClient_) {
            this.moduleProject_ = uiUtils.createCombo(parent, ConsumptionUIMessages.LABEL_CLIENT_PROJECT, ConsumptionUIMessages.LABEL_CLIENT_PROJECT, this.INFOPOP_PWRS_COMBO_PROJECT, 2052);
            this.projectType_ = uiUtils.createCombo(parent, ConsumptionUIMessages.LABEL_CLIENT_TYPE, ConsumptionUIMessages.TOOLTIP_PWCR_COMBO_CLIENT_TYPE, this.INFOPOP_PWRS_COMBO_CLIENT_PROJECT_TYPE, 2060);
            String earProjectLabel = isOSGISelected ? ConsumptionUIMessages.LABEL_CLIENT_OSGI_PROJECT : ConsumptionUIMessages.LABEL_CLIENT_EAR_PROJECT;
            Widget[] earProjectResult = this.createCombo(parent, earProjectLabel, earProjectLabel, this.INFOPOP_PWRS_COMBO_PROJECT, 2052, null);
            this.earProject_ = (Combo)earProjectResult[0];
            this.earProjectLabel_ = (Label)earProjectResult[1];
        } else {
            this.moduleProject_ = uiUtils.createCombo(parent, ConsumptionUIMessages.LABEL_SERVICE_PROJECT, ConsumptionUIMessages.LABEL_SERVICE_PROJECT, this.INFOPOP_PWRS_COMBO_PROJECT, 2052);
            this.projectType_ = uiUtils.createCombo(parent, ConsumptionUIMessages.LABEL_SERVICE_TYPE, ConsumptionUIMessages.TOOLTIP_PWCR_COMBO_SERVICE_TYPE, this.INFOPOP_PWRS_COMBO_SERVICE_PROJECT_TYPE, 2060);
            String earProjectLabel = isOSGISelected ? ConsumptionUIMessages.LABEL_SERVICE_OSGI_PROJECT : ConsumptionUIMessages.LABEL_SERVICE_EAR_PROJECT;
            Widget[] earProjectResult = this.createCombo(parent, earProjectLabel, earProjectLabel, this.INFOPOP_PWRS_COMBO_PROJECT, 2052, null);
            this.earProject_ = (Combo)earProjectResult[0];
            this.earProjectLabel_ = (Label)earProjectResult[1];
        }
        this.projectTypeListener_ = new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ProjectSelectionWidget.this.handleProjectTypeChanged();
                ProjectSelectionWidget.this.statusListener_.handleEvent(null);
            }
        };
        this.moduleProjectListener_ = new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ProjectSelectionWidget.this.handleProjectChanged();
                ProjectSelectionWidget.this.updateEARState();
                ProjectSelectionWidget.this.statusListener_.handleEvent(null);
            }
        };
        this.earProjectListener_ = new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ProjectSelectionWidget.this.statusListener_.handleEvent(null);
            }
        };
        this.messageText_ = uiUtils.createText(parent, ConsumptionUIMessages.LABEL_NO_LABEL, ConsumptionUIMessages.LABEL_NO_LABEL, null, 74);
        this.messageText_.setBackground(parent.getBackground());
        this.setEarProjectItems();
        this.updateTextForOSGI();
        return this;
    }

    private void listenersOn() {
        this.projectType_.addModifyListener(this.projectTypeListener_);
        this.moduleProject_.addModifyListener(this.moduleProjectListener_);
        this.earProject_.addModifyListener(this.earProjectListener_);
    }

    private void listenersOff() {
        this.projectType_.removeModifyListener(this.projectTypeListener_);
        this.moduleProject_.removeModifyListener(this.moduleProjectListener_);
        this.earProject_.removeModifyListener(this.earProjectListener_);
    }

    public String getProjectName() {
        return this.moduleProject_.getText();
    }

    public void setProjectName(String name) {
        this.listenersOff();
        this.moduleProject_.setText(name);
        this.handleProjectChanged();
        this.updateEARState();
        this.listenersOn();
    }

    public String getEarProjectName() {
        return this.earProject_.getText();
    }

    public void setEarProjectName(String name) {
        this.listenersOff();
        this.earProject_.setText(name);
        this.listenersOn();
    }

    public void setComponentType(String type) {
        this.listenersOff();
        if (type != null && type.length() > 0) {
            String label = FacetUtils.getTemplateLabelById((String)type);
            this.projectType_.setText(label);
        } else {
            this.projectType_.setText("");
        }
        this.handleProjectTypeChanged();
        this.listenersOn();
    }

    public String getComponentType() {
        int idx = this.projectType_.getSelectionIndex();
        if (this.templates_ != null && idx > -1) {
            return this.templates_[idx];
        }
        String templateLabel = this.projectType_.getText();
        String templateId = FacetUtils.getTemplateIdByLabel((String)templateLabel);
        return templateId;
    }

    public boolean getNeedEAR() {
        return this.needEAR_;
    }

    public void setNeedEAR(boolean b) {
        this.listenersOff();
        this.needEAR_ = b;
        if (this.needEAR_) {
            this.earProject_.setEnabled(true);
            this.populateEARCombos();
        } else {
            this.earProject_.setEnabled(false);
            this.earProject_.setText("");
        }
        this.listenersOn();
    }

    public void setTypeRuntimeServer(TypeRuntimeServer trs) {
        this.trsIds_ = trs;
        if (this.earProject_ != null) {
            this.listenersOff();
            this.updateEARState();
            this.listenersOn();
        }
    }

    public void refreshProjectItems() {
        this.listenersOff();
        String selectedModuleProject = this.moduleProject_.getText();
        String runtimeId = this.trsIds_.getRuntimeId();
        String serverId = this.trsIds_.getServerId();
        String typeId = this.trsIds_.getTypeId();
        String[] projectNames = null;
        projectNames = this.isClient_ ? WebServiceRuntimeExtensionUtils2.getProjectsForClientTypeAndRuntime(typeId, runtimeId, serverId) : WebServiceRuntimeExtensionUtils2.getProjectsForServiceTypeAndRuntime(typeId, runtimeId);
        this.moduleProject_.setItems(projectNames);
        this.moduleProject_.setText(selectedModuleProject);
        this.handleProjectChanged();
        this.updateEARState();
        this.listenersOn();
    }

    public void setEarProjectItems() {
        IVirtualComponent[] ears = J2EEUtils.getAllEARComponents();
        String[] earProjectNames = new String[ears.length];
        int i = 0;
        while (i < earProjectNames.length) {
            earProjectNames[i] = ears[i].getProject().getName();
            ++i;
        }
        this.earProject_.setItems(earProjectNames);
        if (earProjectNames.length > 0) {
            this.earProject_.select(0);
        }
    }

    private void handleProjectTypeChanged() {
        this.updateEARState();
    }

    private void handleProjectChanged() {
        this.updateTemplates();
    }

    private void updateTemplates() {
        String projectName = this.moduleProject_.getText();
        if (projectName != null && projectName.length() > 0) {
            IProject project = ProjectUtilities.getProject((String)projectName);
            if (project.exists()) {
                this.projectType_.setEnabled(false);
                this.projectType_.deselectAll();
            } else {
                this.populateProjectTypeCombo();
                this.projectType_.setEnabled(true);
            }
        }
    }

    private void populateProjectTypeCombo() {
        String oldTemplateId = this.getComponentType();
        String[] templates = null;
        if (this.trsIds_ != null) {
            templates = this.isClient_ ? WebServiceRuntimeExtensionUtils2.getClientProjectTemplates(this.trsIds_.getTypeId(), this.trsIds_.getRuntimeId(), this.trsIds_.getServerId()) : WebServiceRuntimeExtensionUtils2.getServiceProjectTemplates(this.trsIds_.getTypeId(), this.trsIds_.getRuntimeId(), this.trsIds_.getServerId());
            String[] templateLabels = FacetUtils.getTemplateLabels((String[])templates);
            this.projectType_.setItems(templateLabels);
            this.templates_ = templates;
            if (templates.length > 0) {
                int idx = this.getIndexOfTemplateId(templates, oldTemplateId);
                if (idx > -1) {
                    this.projectType_.select(idx);
                } else {
                    ProjectTopologyContext ptc = WebServiceConsumptionUIPlugin.getInstance().getProjectTopologyContext();
                    String[] preferredTemplateIds = null;
                    preferredTemplateIds = this.isClient_ ? ptc.getClientTypes() : ptc.getServiceTypes();
                    boolean selected = false;
                    int j = 0;
                    block0: while (j < preferredTemplateIds.length) {
                        int i = 0;
                        while (i < templates.length) {
                            String templateId = templates[i];
                            if (templateId.equals(preferredTemplateIds[j])) {
                                this.projectType_.select(i);
                                selected = true;
                                break block0;
                            }
                            ++i;
                        }
                        ++j;
                    }
                    if (!selected) {
                        this.projectType_.select(0);
                    }
                }
            }
        }
    }

    private int getIndexOfTemplateId(String[] templateIds, String templateId) {
        int i = 0;
        while (i < templateIds.length) {
            if (templateIds[i].equals(templateId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isOSGISelected() {
        block4: {
            String id;
            String item;
            int index;
            if (this.projectType_ == null || this.projectType_.isDisposed() || (index = this.projectType_.getSelectionIndex()) < 0 || (item = this.projectType_.getItem(index)) == null || !DefaultingUtils.isOSGITemplate(id = FacetUtils.getTemplateIdByLabel((String)item))) break block4;
            return true;
        }
        try {
            String text;
            if (this.moduleProject_ != null && !this.moduleProject_.isDisposed() && (text = this.moduleProject_.getText()) != null && text.trim().length() > 0 && DefaultingUtils.isOSGIProject(text)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void updateTextForOSGI() {
        try {
            if (this.moduleProject_ != null) {
                boolean isOSGISelected = this.isOSGISelected();
                if (isOSGISelected) {
                    if (this.isClient_) {
                        this.earProjectLabel_.setText(ConsumptionUIMessages.LABEL_CLIENT_OSGI_PROJECT);
                        this.earProjectLabel_.setToolTipText(ConsumptionUIMessages.LABEL_CLIENT_OSGI_PROJECT);
                        this.earProject_.setToolTipText(ConsumptionUIMessages.LABEL_CLIENT_OSGI_PROJECT);
                    } else {
                        this.earProjectLabel_.setText(ConsumptionUIMessages.LABEL_SERVICE_OSGI_PROJECT);
                        this.earProjectLabel_.setToolTipText(ConsumptionUIMessages.LABEL_SERVICE_OSGI_PROJECT);
                        this.earProject_.setToolTipText(ConsumptionUIMessages.LABEL_SERVICE_OSGI_PROJECT);
                    }
                } else if (this.isClient_) {
                    this.earProjectLabel_.setText(ConsumptionUIMessages.LABEL_CLIENT_EAR_PROJECT);
                    this.earProjectLabel_.setToolTipText(ConsumptionUIMessages.LABEL_CLIENT_EAR_PROJECT);
                    this.earProject_.setToolTipText(ConsumptionUIMessages.LABEL_CLIENT_EAR_PROJECT);
                } else {
                    this.earProjectLabel_.setText(ConsumptionUIMessages.LABEL_SERVICE_EAR_PROJECT);
                    this.earProjectLabel_.setToolTipText(ConsumptionUIMessages.LABEL_SERVICE_EAR_PROJECT);
                    this.earProject_.setToolTipText(ConsumptionUIMessages.LABEL_SERVICE_EAR_PROJECT);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateEARState() {
        this.updateTextForOSGI();
        if (!this.projectNeedsEAR(this.moduleProject_.getText())) {
            this.earProject_.setEnabled(false);
            this.earProject_.setText("");
            this.needEAR_ = false;
        } else {
            this.needEAR_ = true;
            this.earProject_.setEnabled(true);
            this.populateEARCombos();
        }
    }

    private void populateEARCombos() {
        this.earProject_.removeAll();
        this.setEarProjectItems();
        String earName = "";
        earName = this.isOSGISelected() ? DefaultingUtils.getDefaultOSGIAppProjectName(this.moduleProject_.getText()) : DefaultingUtils.getDefaultEARProjectName(this.moduleProject_.getText());
        this.earProject_.setText(earName);
    }

    private boolean projectNeedsEAR(String projectName) {
        String targetId;
        IProject project;
        if (projectName != null && projectName.length() > 0 && (project = ProjectUtilities.getProject((String)projectName)).exists() && FacetUtils.isJavaProject((IProject)project)) {
            return false;
        }
        String templateId = this.getComponentType();
        if (templateId != null && templateId.length() > 0 && FacetUtils.isUtilityTemplate((String)templateId)) {
            return false;
        }
        return this.trsIds_ == null || this.trsIds_.getServerId() == null || (targetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)this.trsIds_.getServerId())) == null || targetId.length() <= 0 || ServerUtils.isTargetValidForEAR((String)targetId, (String)"13");
    }

    private IStatus handleSetMessageText() {
        IStatus status = Status.OK_STATUS;
        try {
            byte result = 0;
            if (this.moduleProject_.getText().length() != 0 && this.earProject_.getText().length() != 0) {
                String projectText = this.moduleProject_.getText();
                String earText = this.earProject_.getText();
                IProject project = ResourceUtils.getWorkspaceRoot().getProject(projectText);
                IProject ear = ResourceUtils.getWorkspaceRoot().getProject(earText);
                if (project != null) {
                    if (!project.exists()) {
                        result = (byte)(result | this.CREATE_PROJECT);
                    }
                    if (!ear.exists()) {
                        result = (byte)(result | this.CREATE_EAR);
                    }
                    if (project.exists() && J2EEUtils.exists((IProject)project) && ear.exists() && J2EEUtils.exists((IProject)ear) && !J2EEUtils.isComponentAssociated((IProject)ear, (IProject)project)) {
                        result = (byte)(result | this.ADD_EAR_ASSOCIATION);
                    }
                }
            }
            if (this.isClient_) {
                this.messageText_.setText(this.getValidationMessage(result, ConsumptionUIMessages.MSG_CLIENT_SUB));
            } else {
                this.messageText_.setText(this.getValidationMessage(result, ConsumptionUIMessages.MSG_SERVICE_SUB));
            }
            this.parent_.layout();
        }
        catch (Exception e) {
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.PAGE_MSG_VALIDATION_INTERNAL_ERROR, (Throwable)e);
        }
        return status;
    }

    private String getValidationMessage(byte result, String serviceOrClient) {
        String msg = null;
        boolean isOSGI = this.isOSGISelected();
        switch (result) {
            case 0: {
                return "";
            }
            case 1: 
            case 5: {
                msg = ConsumptionUIMessages.MSG_PROJECT_WILL_BE_CREATED;
                break;
            }
            case 2: 
            case 6: {
                if (isOSGI) {
                    msg = ConsumptionUIMessages.MSG_OSGIAPP_WILL_BE_CREATED;
                    break;
                }
                msg = ConsumptionUIMessages.MSG_EAR_WILL_BE_CREATED;
                break;
            }
            case 3: 
            case 7: {
                if (isOSGI) {
                    msg = ConsumptionUIMessages.MSG_PROJECT_AND_OSGIAPP_CREATED;
                    break;
                }
                msg = ConsumptionUIMessages.MSG_PROJECT_AND_EAR_CREATED;
                break;
            }
            case 4: {
                msg = isOSGI ? ConsumptionUIMessages.MSG_OSGIAPP_WILL_BE_ASSOCIATED : ConsumptionUIMessages.MSG_EAR_WILL_BE_ASSOCIATED;
            }
        }
        return msg != null ? NLS.bind((String)msg, (Object[])new Object[]{serviceOrClient}) : "";
    }

    public IStatus getStatus() {
        IStatus finalStatus = Status.OK_STATUS;
        this.handleSetMessageText();
        String projectText = this.moduleProject_.getText();
        String earText = this.earProject_.getText();
        boolean isOSGI = this.isOSGISelected();
        if (projectText == null || projectText.length() == 0) {
            if (this.isClient_) {
                return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_PROJECT_EMPTY, (Object[])new String[]{""}));
            }
            return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_PROJECT_EMPTY, (Object[])new String[]{""}));
        }
        if (this.needEAR_ && (earText == null || earText.length() == 0)) {
            if (this.isClient_) {
                if (isOSGI) {
                    return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_OSGIAPP_EMPTY, (Object[])new String[]{""}));
                }
                return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_EAR_EMPTY, (Object[])new String[]{""}));
            }
            if (isOSGI) {
                return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_OSGIAPP_EMPTY, (Object[])new String[]{""}));
            }
            return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_EAR_EMPTY, (Object[])new String[]{""}));
        }
        if (this.needEAR_) {
            boolean associateStatus;
            IProject p = ProjectUtilities.getProject((String)projectText.trim());
            IProject ep = ProjectUtilities.getProject((String)earText.trim());
            if (p.exists() && ep.exists() && !J2EEUtils.isComponentAssociated((IProject)ep, (IProject)p) && !(associateStatus = J2EEUtils.canAssociateProjectToEARWithoutWarning((IProject)p, (IProject)ep))) {
                if (this.isClient_) {
                    return StatusUtils.warningStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_CANNOT_ASSOCIATE, (Object[])new String[]{p.getName(), ep.getName()}));
                }
                return StatusUtils.warningStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_CANNOT_ASSOCIATE, (Object[])new String[]{p.getName(), ep.getName()}));
            }
        }
        return finalStatus;
    }

    private Widget[] createCombo(Composite parent, String labelName, String tooltip, String infopop, int style, IDialogSettings settings) {
        Widget[] result = new Widget[2];
        String string = tooltip = tooltip == null ? labelName : tooltip;
        if (labelName != null) {
            Label label = new Label(parent, 64);
            label.setText(labelName);
            label.setToolTipText(tooltip);
            result[1] = label;
        }
        Object combo = settings == null ? new Combo(parent, style) : new ComboWithHistory(parent, style, settings);
        GridData griddata = new GridData(768);
        combo.setLayoutData((Object)griddata);
        combo.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)combo, String.valueOf(this.pluginId_) + "." + infopop);
        }
        result[0] = combo;
        return result;
    }
}

