/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.kdm.source.discoverer;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.kdm.source.discoverer.internal.KDMSourceDiscoverer;

public class DiscoverSourceModelFromResource
extends AbstractModelDiscoverer<IResource> {
    public boolean isApplicableTo(IResource resource) {
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            return project.isAccessible();
        }
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            return container.isAccessible();
        }
        return false;
    }

    public void discoverElement(File directory, IProgressMonitor monitor) throws DiscoveryException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("not a directory");
        }
        this.setDefaultTargetURI(URI.createFileURI((String)directory.getPath().concat("/" + directory.getName() + "_kdm.xmi")));
        this.checkParameterValues();
        KDMSourceDiscoverer disco = new KDMSourceDiscoverer();
        Resource model = disco.getKDMModelFromDirectory(directory);
        this.getResourceSet().getResources().add((Object)model);
        this.setTargetModel(model);
        if (this.isTargetSerializationChosen()) {
            try {
                this.saveTargetModel();
            }
            catch (Exception e) {
                throw new DiscoveryException("Error saving discovery result model", (Throwable)e);
            }
        }
    }

    protected void basicDiscoverElement(IResource resource, IProgressMonitor monitor) throws DiscoveryException {
        Resource model;
        KDMSourceDiscoverer disco = new KDMSourceDiscoverer();
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            this.setDefaultTargetURI(URI.createPlatformResourceURI((String)project.getFullPath().append(project.getName()).toString().concat("_kdm.xmi"), (boolean)true));
            model = disco.getKDMModelFromProject(project);
        } else if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            this.setDefaultTargetURI(URI.createPlatformResourceURI((String)container.getFullPath().append(container.getName()).toString().concat("_kdm.xmi"), (boolean)true));
            model = disco.getKDMModelFromContainer(container);
        } else {
            throw new IllegalArgumentException(String.valueOf(resource.getClass().getName()) + " not handled");
        }
        this.getResourceSet().getResources().add((Object)model);
        this.setTargetModel(model);
    }
}

