/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.Messages;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;

public class BugzillaTaskAttachmentHandler
extends AbstractTaskAttachmentHandler {
    private final BugzillaRepositoryConnector connector;

    public BugzillaTaskAttachmentHandler(BugzillaRepositoryConnector connector) {
        this.connector = connector;
    }

    public boolean canGetContent(TaskRepository repository, ITask task) {
        return true;
    }

    public boolean canPostContent(TaskRepository repository, ITask task) {
        return true;
    }

    public InputStream getContent(TaskRepository repository, ITask task, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(Messages.BugzillaTaskAttachmentHandler_Getting_attachment, -1);
            TaskAttachmentMapper attachment = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttribute);
            BugzillaClient client = this.connector.getClientManager().getClient(repository, monitor);
            InputStream inputStream = client.getAttachmentData(attachment.getAttachmentId(), monitor);
            return inputStream;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Unable to retrieve attachment", (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    public void postContent(TaskRepository repository, ITask task, AbstractTaskAttachmentSource source, String comment, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                monitor.beginTask(Messages.BugzillaTaskAttachmentHandler_Sending_attachment, -1);
                BugzillaClient client = this.connector.getClientManager().getClient(repository, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)-1));
                client.postAttachment(task.getTaskId(), comment, source, attachmentAttribute, monitor);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", Messages.BugzillaTaskAttachmentHandler_unable_to_submit_attachment, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }
}

