/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.ClassImpl;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorSingleIterationManager;
import org.eclipse.ocl.pivot.library.AbstractBinaryOperation;
import org.eclipse.ocl.pivot.library.LibraryBinaryOperation;
import org.eclipse.ocl.pivot.library.LibraryIteration;
import org.eclipse.ocl.pivot.library.collection.CollectionIncludesOperation;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclIsKindOfOperation;
import org.eclipse.ocl.pivot.library.oclany.OclComparableLessThanEqualOperation;
import org.eclipse.ocl.pivot.library.string.CGStringGetSeverityOperation;
import org.eclipse.ocl.pivot.library.string.CGStringLogDiagnosticOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibTables;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.SetValue;

public class DataTypeImpl
extends ClassImpl
implements DataType {
    public static final int DATA_TYPE_FEATURE_COUNT = 23;
    public static final int DATA_TYPE_OPERATION_COUNT = 11;
    protected Class behavioralClass;
    protected static final boolean IS_SERIALIZABLE_EDEFAULT = true;
    protected static final int IS_SERIALIZABLE_EFLAG = 2048;
    protected static final String VALUE_EDEFAULT = "";

    protected DataTypeImpl() {
        this.eFlags |= 0x800;
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.DATA_TYPE;
    }

    @Override
    public void setIsSerializable(boolean newIsSerializable) {
        boolean oldIsSerializable;
        boolean bl = oldIsSerializable = (this.eFlags & 0x800) != 0;
        this.eFlags = newIsSerializable ? (this.eFlags |= 0x800) : (this.eFlags &= 0xFFFFF7FF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, oldIsSerializable, newIsSerializable));
        }
    }

    @Override
    public Class getBehavioralClass() {
        if (this.behavioralClass != null && this.behavioralClass.eIsProxy()) {
            InternalEObject oldBehavioralClass = (InternalEObject)this.behavioralClass;
            this.behavioralClass = (Class)this.eResolveProxy(oldBehavioralClass);
            if (this.behavioralClass != oldBehavioralClass && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 20, (Object)oldBehavioralClass, (Object)this.behavioralClass));
            }
        }
        return this.behavioralClass;
    }

    public Class basicGetBehavioralClass() {
        return this.behavioralClass;
    }

    @Override
    public void setBehavioralClass(Class newBehavioralClass) {
        Class oldBehavioralClass = this.behavioralClass;
        this.behavioralClass = newBehavioralClass;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldBehavioralClass, (Object)this.behavioralClass));
        }
    }

    @Override
    public boolean isIsSerializable() {
        return (this.eFlags & 0x800) != 0;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAnnotatingComments();
            }
            case 1: {
                return this.getOwnedAnnotations();
            }
            case 2: {
                return this.getOwnedComments();
            }
            case 3: {
                return this.getOwnedExtensions();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.getOwnedConstraints();
            }
            case 6: {
                return this.getOwnedBindings();
            }
            case 7: {
                return this.getOwnedSignature();
            }
            case 8: {
                return this.getUnspecializedElement();
            }
            case 9: {
                return this.getExtenders();
            }
            case 10: {
                return this.getInstanceClassName();
            }
            case 11: {
                return this.isIsAbstract();
            }
            case 12: {
                return this.isIsActive();
            }
            case 13: {
                return this.isIsInterface();
            }
            case 14: {
                return this.getOwnedBehaviors();
            }
            case 15: {
                return this.getOwnedInvariants();
            }
            case 16: {
                return this.getOwnedOperations();
            }
            case 17: {
                return this.getOwnedProperties();
            }
            case 18: {
                return this.getOwningPackage();
            }
            case 19: {
                return this.getSuperClasses();
            }
            case 20: {
                if (resolve) {
                    return this.getBehavioralClass();
                }
                return this.basicGetBehavioralClass();
            }
            case 21: {
                return this.isIsSerializable();
            }
            case 22: {
                return this.getValue();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                this.getAnnotatingComments().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                this.getOwnedAnnotations().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                this.getOwnedComments().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                this.getOwnedExtensions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 5: {
                this.getOwnedConstraints().clear();
                this.getOwnedConstraints().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getOwnedBindings().clear();
                this.getOwnedBindings().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setOwnedSignature((TemplateSignature)newValue);
                return;
            }
            case 8: {
                this.setUnspecializedElement((TemplateableElement)newValue);
                return;
            }
            case 9: {
                this.getExtenders().clear();
                this.getExtenders().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setInstanceClassName((String)newValue);
                return;
            }
            case 11: {
                this.setIsAbstract((Boolean)newValue);
                return;
            }
            case 12: {
                this.setIsActive((Boolean)newValue);
                return;
            }
            case 13: {
                this.setIsInterface((Boolean)newValue);
                return;
            }
            case 14: {
                this.getOwnedBehaviors().clear();
                this.getOwnedBehaviors().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getOwnedInvariants().clear();
                this.getOwnedInvariants().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.getOwnedOperations().clear();
                this.getOwnedOperations().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getOwnedProperties().clear();
                this.getOwnedProperties().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.setOwningPackage((Package)newValue);
                return;
            }
            case 19: {
                this.getSuperClasses().clear();
                this.getSuperClasses().addAll((Collection)newValue);
                return;
            }
            case 20: {
                this.setBehavioralClass((Class)newValue);
                return;
            }
            case 21: {
                this.setIsSerializable((Boolean)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 5: {
                this.getOwnedConstraints().clear();
                return;
            }
            case 6: {
                this.getOwnedBindings().clear();
                return;
            }
            case 7: {
                this.setOwnedSignature(null);
                return;
            }
            case 8: {
                this.setUnspecializedElement(null);
                return;
            }
            case 9: {
                this.getExtenders().clear();
                return;
            }
            case 10: {
                this.setInstanceClassName(INSTANCE_CLASS_NAME_EDEFAULT);
                return;
            }
            case 11: {
                this.setIsAbstract(false);
                return;
            }
            case 12: {
                this.setIsActive(false);
                return;
            }
            case 13: {
                this.setIsInterface(false);
                return;
            }
            case 14: {
                this.getOwnedBehaviors().clear();
                return;
            }
            case 15: {
                this.getOwnedInvariants().clear();
                return;
            }
            case 16: {
                this.getOwnedOperations().clear();
                return;
            }
            case 17: {
                this.getOwnedProperties().clear();
                return;
            }
            case 18: {
                this.setOwningPackage(null);
                return;
            }
            case 19: {
                this.getSuperClasses().clear();
                return;
            }
            case 20: {
                this.setBehavioralClass(null);
                return;
            }
            case 21: {
                this.setIsSerializable(true);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.annotatingComments != null && !this.annotatingComments.isEmpty();
            }
            case 1: {
                return this.ownedAnnotations != null && !this.ownedAnnotations.isEmpty();
            }
            case 2: {
                return this.ownedComments != null && !this.ownedComments.isEmpty();
            }
            case 3: {
                return this.ownedExtensions != null && !this.ownedExtensions.isEmpty();
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return this.ownedConstraints != null && !this.ownedConstraints.isEmpty();
            }
            case 6: {
                return this.ownedBindings != null && !this.ownedBindings.isEmpty();
            }
            case 7: {
                return this.ownedSignature != null;
            }
            case 8: {
                return this.unspecializedElement != null;
            }
            case 9: {
                return this.extenders != null && !this.extenders.isEmpty();
            }
            case 10: {
                return INSTANCE_CLASS_NAME_EDEFAULT == null ? this.instanceClassName != null : !INSTANCE_CLASS_NAME_EDEFAULT.equals(this.instanceClassName);
            }
            case 11: {
                return (this.eFlags & 0x100) != 0;
            }
            case 12: {
                return (this.eFlags & 0x200) != 0;
            }
            case 13: {
                return (this.eFlags & 0x400) != 0;
            }
            case 14: {
                return this.ownedBehaviors != null && !this.ownedBehaviors.isEmpty();
            }
            case 15: {
                return this.ownedInvariants != null && !this.ownedInvariants.isEmpty();
            }
            case 16: {
                return this.ownedOperations != null && !this.ownedOperations.isEmpty();
            }
            case 17: {
                return this.ownedProperties != null && !this.ownedProperties.isEmpty();
            }
            case 18: {
                return this.getOwningPackage() != null;
            }
            case 19: {
                return this.superClasses != null && !this.superClasses.isEmpty();
            }
            case 20: {
                return this.behavioralClass != null;
            }
            case 21: {
                return (this.eFlags & 0x800) == 0;
            }
            case 22: {
                return VALUE_EDEFAULT == null ? this.getValue() != null : !VALUE_EDEFAULT.equals(this.getValue());
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.flattenedType();
            }
            case 3: {
                return this.isClass();
            }
            case 4: {
                return this.isTemplateParameter();
            }
            case 5: {
                return this.specializeIn((CallExp)arguments.get(0), (Type)arguments.get(1));
            }
            case 6: {
                return this.validateNameIsNotNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 7: {
                return this.validateUniqueInvariantName((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 8: {
                return this.validateBehavioralClassHasDistinctName((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 9: {
                return this.validateBehavioralClassIsPrimitiveType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 10: {
                return this.validateBehavioralClassIsSuperClass((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitDataType(this);
    }

    @Override
    public @NonNull TypeId computeId() {
        if (this.eContainer() instanceof Library) {
            String name2 = this.name;
            if (name2 == null) {
                name2 = VALUE_EDEFAULT;
            }
            return IdManager.getNsURIPackageId("http://www.eclipse.org/ocl/2015/Pivot", "pivot", PivotPackage.eINSTANCE).getDataTypeId(name2, this.getTypeParameters().parametersSize());
        }
        Class behavioralType = this.getBehavioralClass();
        if (behavioralType != null) {
            // empty if block
        }
        return IdManager.getDataTypeId(this);
    }

    @Override
    public @NonNull CompleteInheritance getInheritance(@NonNull StandardLibrary standardLibrary) {
        Class behavioralType = this.getBehavioralClass();
        return standardLibrary.getInheritance(behavioralType != null ? behavioralType : this);
    }

    @Override
    public String getValue() {
        return VALUE_EDEFAULT;
    }

    @Override
    public boolean validateBehavioralClassHasDistinctName(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "DataType::BehavioralClassHasDistinctName";
        try {
            boolean IF_le;
            @NonNull Executor executor = PivotUtil.getExecutor(this);
            final @NonNull IdResolver idResolver = executor.getIdResolver();
            @NonNull StandardLibrary standardLibrary = idResolver.getStandardLibrary();
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.DATA_TYPE___VALIDATE_BEHAVIORAL_CLASS_HAS_DISTINCT_NAME__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                IF_le = true;
            } else {
                boolean logDiagnostic;
                Serializable CAUGHT_result;
                try {
                    Boolean result;
                    boolean ne;
                    @Nullable Class behavioralClass = this.getBehavioralClass();
                    boolean bl = ne = behavioralClass != null;
                    if (!ne) {
                        result = ValueUtil.TRUE_VALUE;
                    } else {
                        Serializable CAUGHT_forAll;
                        try {
                            Boolean forAll;
                            @NonNull List<Class> superClasses = this.getSuperClasses();
                            @NonNull SetValue BOXED_superClasses = idResolver.createSetOfAll(PivotTables.SET_CLSSid_Class, superClasses);
                            @NonNull Class TYPE_closure_0 = executor.getStaticTypeOfValue(null, BOXED_superClasses);
                             @NonNull LibraryIteration.LibraryIterationExtension IMPL_closure_0 = (LibraryIteration.LibraryIterationExtension)TYPE_closure_0.lookupImplementation(standardLibrary, OCLstdlibTables.Operations._Set__closure);
                            @NonNull Object ACC_closure_0 = IMPL_closure_0.createAccumulatorValue(executor, (TypeId)PivotTables.SET_CLSSid_Class, (TypeId)PivotTables.SET_CLSSid_Class);
                            @NonNull AbstractBinaryOperation BODY_closure_0 = new AbstractBinaryOperation(){

                                @Override
                                public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId typeId, @Nullable Object BOXED_superClasses, @Nullable Object _1) {
                                    @Nullable Class CAST_null = (Class)_1;
                                    if (CAST_null == null) {
                                        throw new InvalidValueException("Null source for 'Class::superClasses'", new Object[0]);
                                    }
                                    @NonNull List<Class> superClasses_0 = CAST_null.getSuperClasses();
                                    @NonNull SetValue BOXED_superClasses_0 = idResolver.createSetOfAll(PivotTables.SET_CLSSid_Class, superClasses_0);
                                    return BOXED_superClasses_0;
                                }
                            };
                            @NonNull ExecutorSingleIterationManager MGR_closure_0 = new ExecutorSingleIterationManager(executor, (TypeId)PivotTables.SET_CLSSid_Class, (LibraryBinaryOperation)BODY_closure_0, (CollectionValue)BOXED_superClasses, ACC_closure_0);
                            @NonNull SetValue closure = (SetValue)IMPL_closure_0.evaluateIteration(MGR_closure_0);
                            @Nullable Comparable<Boolean> accumulator = ValueUtil.TRUE_VALUE;
                            @NonNull Iterator<Object> ITERATOR_b = closure.iterator();
                            while (true) {
                                boolean ne_0;
                                if (!ITERATOR_b.hasNext()) {
                                    if (accumulator == ValueUtil.TRUE_VALUE) {
                                        forAll = ValueUtil.TRUE_VALUE;
                                        break;
                                    }
                                    throw (InvalidValueException)accumulator;
                                }
                                @NonNull Class b = (Class)ITERATOR_b.next();
                                @Nullable String name = b.getName();
                                @Nullable String name_0 = this.getName();
                                boolean bl2 = name != null ? !name.equals(name_0) : (ne_0 = name_0 != null);
                                if (!ne_0) {
                                    forAll = ValueUtil.FALSE_VALUE;
                                    break;
                                }
                                if (ne_0) continue;
                                accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "forAll");
                            }
                            CAUGHT_forAll = forAll;
                        }
                        catch (Exception e) {
                            CAUGHT_forAll = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_forAll == ValueUtil.TRUE_VALUE) {
                            result = ValueUtil.TRUE_VALUE;
                        } else {
                            if (CAUGHT_forAll instanceof InvalidValueException) {
                                throw CAUGHT_forAll;
                            }
                            result = CAUGHT_forAll == null ? null : ValueUtil.FALSE_VALUE;
                        }
                    }
                    CAUGHT_result = result;
                }
                catch (Exception e) {
                    CAUGHT_result = ValueUtil.createInvalidValue(e);
                }
                IF_le = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "DataType::BehavioralClassHasDistinctName", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
            }
            return IF_le;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("DataType::BehavioralClassHasDistinctName", this, diagnostics, context, e);
        }
    }

    @Override
    public boolean validateBehavioralClassIsPrimitiveType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "DataType::BehavioralClassIsPrimitiveType";
        try {
            boolean IF_le;
            @NonNull Executor executor = PivotUtil.getExecutor(this);
            @NonNull IdResolver idResolver = executor.getIdResolver();
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.DATA_TYPE___VALIDATE_BEHAVIORAL_CLASS_IS_PRIMITIVE_TYPE__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                IF_le = true;
            } else {
                boolean logDiagnostic;
                Serializable CAUGHT_result;
                try {
                    Boolean result;
                    boolean ne;
                    @Nullable Class behavioralClass = this.getBehavioralClass();
                    boolean bl = ne = behavioralClass != null;
                    if (!ne) {
                        result = ValueUtil.TRUE_VALUE;
                    } else {
                        Serializable CAUGHT_oclIsKindOf;
                        try {
                            @NonNull Class TYP_PrimitiveType = idResolver.getClass(PivotTables.CLSSid_PrimitiveType, null);
                            boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)behavioralClass, (Object)TYP_PrimitiveType);
                            CAUGHT_oclIsKindOf = Boolean.valueOf(oclIsKindOf);
                        }
                        catch (Exception e) {
                            CAUGHT_oclIsKindOf = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_oclIsKindOf == ValueUtil.TRUE_VALUE) {
                            result = ValueUtil.TRUE_VALUE;
                        } else {
                            if (CAUGHT_oclIsKindOf instanceof InvalidValueException) {
                                throw CAUGHT_oclIsKindOf;
                            }
                            result = ValueUtil.FALSE_VALUE;
                        }
                    }
                    CAUGHT_result = result;
                }
                catch (Exception e) {
                    CAUGHT_result = ValueUtil.createInvalidValue(e);
                }
                IF_le = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "DataType::BehavioralClassIsPrimitiveType", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
            }
            return IF_le;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("DataType::BehavioralClassIsPrimitiveType", this, diagnostics, context, e);
        }
    }

    @Override
    public boolean validateBehavioralClassIsSuperClass(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "DataType::BehavioralClassIsSuperClass";
        try {
            boolean IF_le;
            @NonNull Executor executor = PivotUtil.getExecutor(this);
            @NonNull IdResolver idResolver = executor.getIdResolver();
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.DATA_TYPE___VALIDATE_BEHAVIORAL_CLASS_IS_SUPER_CLASS__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                IF_le = true;
            } else {
                boolean logDiagnostic;
                Serializable CAUGHT_result;
                try {
                    Boolean result;
                    boolean ne;
                    @Nullable Class behavioralClass = this.getBehavioralClass();
                    boolean bl = ne = behavioralClass != null;
                    if (!ne) {
                        result = ValueUtil.TRUE_VALUE;
                    } else {
                        Serializable CAUGHT_includes;
                        try {
                            @NonNull List<Class> superClasses = this.getSuperClasses();
                            @NonNull SetValue BOXED_superClasses = idResolver.createSetOfAll(PivotTables.SET_CLSSid_Class, superClasses);
                            boolean includes = CollectionIncludesOperation.INSTANCE.evaluate(BOXED_superClasses, behavioralClass);
                            CAUGHT_includes = Boolean.valueOf(includes);
                        }
                        catch (Exception e) {
                            CAUGHT_includes = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_includes == ValueUtil.TRUE_VALUE) {
                            result = ValueUtil.TRUE_VALUE;
                        } else {
                            if (CAUGHT_includes instanceof InvalidValueException) {
                                throw CAUGHT_includes;
                            }
                            result = ValueUtil.FALSE_VALUE;
                        }
                    }
                    CAUGHT_result = result;
                }
                catch (Exception e) {
                    CAUGHT_result = ValueUtil.createInvalidValue(e);
                }
                IF_le = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "DataType::BehavioralClassIsSuperClass", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
            }
            return IF_le;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("DataType::BehavioralClassIsSuperClass", this, diagnostics, context, e);
        }
    }

    @Override
    public boolean conformsTo(@NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        Class behavioralClass;
        if (type instanceof DataType && (behavioralClass = ((DataType)type).getBehavioralClass()) != null) {
            type = behavioralClass;
        }
        return super.conformsTo(standardLibrary, type);
    }
}

