/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.FileEditorInputFactory;

public class FileEditorInput
extends PlatformObject
implements IFileEditorInput,
IPathEditorInput,
IURIEditorInput,
IPersistableElement {
    private final IFile file;

    public static boolean isLocalFile(IFile file) {
        URI locationURI;
        block5: {
            IPath location = file.getLocation();
            if (location != null) {
                return true;
            }
            try {
                locationURI = file.getLocationURI();
                if (locationURI != null) break block5;
                return false;
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Failed to obtain file store for resource", e);
                return false;
            }
        }
        IFileStore store = EFS.getStore((URI)locationURI);
        File localFile = store.toLocalFile(0, null);
        if (localFile == null) {
            localFile = store.toLocalFile(4096, null);
        }
        return localFile != null;
    }

    public FileEditorInput(IFile file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void other;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IFileEditorInput)) {
            return false;
        }
        IFileEditorInput iFileEditorInput = (IFileEditorInput)obj;
        return this.file.equals((Object)other.getFile());
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getFactoryId() {
        return FileEditorInputFactory.getFactoryId();
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    public ImageDescriptor getImageDescriptor() {
        IContentType contentType = IDE.getContentType(this.file);
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.file.getName(), contentType);
    }

    public String getName() {
        return this.file.getName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    @Override
    public IStorage getStorage() {
        return this.file;
    }

    public String getToolTipText() {
        return this.file.getFullPath().makeRelative().toString();
    }

    public void saveState(IMemento memento) {
        FileEditorInputFactory.saveState(memento, this);
    }

    @Override
    public URI getURI() {
        return this.file.getLocationURI();
    }

    public IPath getPath() {
        IPath location = this.file.getLocation();
        if (location != null) {
            return location;
        }
        try {
            URI locationURI = this.file.getLocationURI();
            if (locationURI == null) {
                throw new IllegalArgumentException();
            }
            IFileStore store = EFS.getStore((URI)locationURI);
            File localFile = store.toLocalFile(0, null);
            if (localFile == null) {
                localFile = store.toLocalFile(4096, null);
            }
            if (localFile == null) {
                throw new IllegalArgumentException();
            }
            return IPath.fromOSString((String)localFile.getAbsolutePath());
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log("Failed to obtain file store for resource", e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + String.valueOf(this.getFile().getFullPath()) + ")";
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (IWorkbenchAdapter.class.equals(adapterType)) {
            return adapterType.cast(new IWorkbenchAdapter(){

                public Object[] getChildren(Object o) {
                    return new Object[0];
                }

                public ImageDescriptor getImageDescriptor(Object object) {
                    return FileEditorInput.this.getImageDescriptor();
                }

                public String getLabel(Object o) {
                    return FileEditorInput.this.getName();
                }

                public Object getParent(Object o) {
                    return FileEditorInput.this.getFile().getParent();
                }
            });
        }
        return (T)super.getAdapter(adapterType);
    }
}

