'use strict';

function isPSD (buffer) {
  return ('8BPS' === buffer.toString('ascii', 0, 4));
}

function calculate (buffer) {
  return {
    'width': buffer.readUInt32BE(18),
    'height': buffer.readUInt32BE(14)
  };
}

module.exports = {
  'detect': isPSD,
  'calculate': calculate
};
