/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.cleanup;

import org.eclipse.wst.html.core.internal.cleanup.AbstractNodeCleanupHandler;
import org.eclipse.wst.html.core.internal.cleanup.CSSTextNodeCleanupHandler;
import org.eclipse.wst.html.core.internal.cleanup.ElementNodeCleanupHandler;
import org.eclipse.wst.html.core.internal.cleanup.JSPElementNodeCleanupHandler;
import org.eclipse.wst.html.core.internal.cleanup.NodeCleanupHandler;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupHandler;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

class HTMLCleanupHandlerFactory {
    private static HTMLCleanupHandlerFactory fInstance = null;

    static synchronized HTMLCleanupHandlerFactory getInstance() {
        if (fInstance == null) {
            fInstance = new HTMLCleanupHandlerFactory();
        }
        return fInstance;
    }

    private HTMLCleanupHandlerFactory() {
    }

    IStructuredCleanupHandler createHandler(Node node, IStructuredCleanupPreferences cleanupPreferences) {
        short nodeType = node.getNodeType();
        AbstractNodeCleanupHandler handler = null;
        switch (nodeType) {
            case 1: {
                if (this.isXMLTag(node)) {
                    handler = new ElementNodeCleanupHandler();
                    break;
                }
                handler = new JSPElementNodeCleanupHandler();
                break;
            }
            case 3: {
                if (this.isParentStyleTag(node)) {
                    handler = new CSSTextNodeCleanupHandler();
                    break;
                }
                handler = new NodeCleanupHandler();
                break;
            }
            default: {
                handler = new NodeCleanupHandler();
            }
        }
        handler.setCleanupPreferences(cleanupPreferences);
        return handler;
    }

    private boolean isXMLTag(Node node) {
        if (node instanceof IDOMNode) {
            IStructuredDocumentRegion region = ((IDOMNode)node).getFirstStructuredDocumentRegion();
            return "XML_TAG_NAME" == region.getType();
        }
        return false;
    }

    private boolean isParentStyleTag(Node node) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != 3) {
            return false;
        }
        if (!(node instanceof IDOMNode)) {
            return false;
        }
        IStructuredDocumentRegion flatNode = ((IDOMNode)node).getFirstStructuredDocumentRegion();
        if (flatNode == null) {
            return false;
        }
        if (flatNode.getType() != "BLOCK_TEXT") {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        if (parent.getNodeType() != 1) {
            return false;
        }
        String name = parent.getNodeName();
        if (name == null) {
            return false;
        }
        return name.equalsIgnoreCase("STYLE");
    }
}

