/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.inject;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.osgi.test.common.exceptions.Exceptions;

public class FieldInjector {
    private static final String annotationTypeMustNotBeNull = "annotationType must not be null";
    private static final String classMustNotBeNull = "class must not be null";
    private static final Comparator<Field> fieldComparator = (a, b) -> Integer.compare(a.getName().hashCode(), b.getName().hashCode());
    private static final Predicate<Class<? extends Annotation>> isJavaLangAnnotation = a -> a != null && a.getName().startsWith("java.lang.annotation");
    private static final Predicate<Class<?>> isSearchable = c -> c != null && c != Object.class;
    private static final String predicateMustNotBeNull = "predicate must not be null";

    public static List<Field> findAnnotatedNonStaticFields(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return FieldInjector.findAnnotatedFields(clazz, annotationType, m -> !Modifier.isStatic(m.getModifiers()));
    }

    public static List<Field> findAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return FieldInjector.findAnnotatedFields(clazz, annotationType, x -> true);
    }

    public static List<Field> findAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotationType, Predicate<Field> predicate) {
        Objects.requireNonNull(annotationType, annotationTypeMustNotBeNull);
        Objects.requireNonNull(predicate, predicateMustNotBeNull);
        Predicate<Field> annotated = field -> FieldInjector.findAnnotation(field, annotationType).isPresent();
        return FieldInjector.findAllFieldsInHierarchy(Objects.requireNonNull(clazz, classMustNotBeNull)).stream().filter(annotated.and(predicate)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public static void setField(Field field, Object instance, Object value) {
        Exceptions.unchecked(() -> {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(instance, value);
        });
    }

    static List<Field> findAllFieldsInHierarchy(Class<?> clazz) {
        Objects.requireNonNull(clazz, classMustNotBeNull);
        List localFields = FieldInjector.toSortedMutableList(clazz.getDeclaredFields()).stream().filter(field -> !field.isSynthetic()).collect(Collectors.toList());
        List superclassFields = FieldInjector.getSuperclassFields(clazz).stream().filter(field -> !FieldInjector.isFieldShadowedByLocalFields(field, localFields)).collect(Collectors.toList());
        List interfaceFields = FieldInjector.getInterfaceFields(clazz).stream().filter(field -> !FieldInjector.isFieldShadowedByLocalFields(field, localFields)).collect(Collectors.toList());
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(superclassFields);
        fields.addAll(interfaceFields);
        fields.addAll(localFields);
        return fields;
    }

    static <A extends Annotation> Optional<A> findAnnotation(AnnotatedElement element, Class<A> annotationType) {
        Objects.requireNonNull(annotationType, annotationTypeMustNotBeNull);
        boolean inherited = annotationType.isAnnotationPresent(Inherited.class);
        return FieldInjector.findAnnotation(element, annotationType, inherited, new HashSet<Annotation>());
    }

    static <A extends Annotation> Optional<A> findAnnotation(AnnotatedElement element, Class<A> annotationType, boolean inherited, Set<Annotation> visited) {
        if (element == null) {
            return Optional.empty();
        }
        A annotation = element.getDeclaredAnnotation(Objects.requireNonNull(annotationType, annotationTypeMustNotBeNull));
        if (annotation != null) {
            return Optional.of(annotation);
        }
        Optional<A> directMetaAnnotation = FieldInjector.findMetaAnnotation(annotationType, element.getDeclaredAnnotations(), inherited, visited);
        if (directMetaAnnotation.isPresent()) {
            return directMetaAnnotation;
        }
        if (element instanceof Class) {
            Optional<A> annotationOnSuperclass;
            Class superclass;
            Class clazz = (Class)element;
            for (Class<?> ifc : clazz.getInterfaces()) {
                Optional<A> annotationOnInterface;
                if (ifc == Annotation.class || !(annotationOnInterface = FieldInjector.findAnnotation(ifc, annotationType, inherited, visited)).isPresent()) continue;
                return annotationOnInterface;
            }
            if (inherited && (superclass = clazz.getSuperclass()) != null && superclass != Object.class && (annotationOnSuperclass = FieldInjector.findAnnotation(superclass, annotationType, inherited, visited)).isPresent()) {
                return annotationOnSuperclass;
            }
        }
        return FieldInjector.findMetaAnnotation(annotationType, element.getAnnotations(), inherited, visited);
    }

    static <A extends Annotation> Optional<A> findMetaAnnotation(Class<A> annotationType, Annotation[] candidates, boolean inherited, Set<Annotation> visited) {
        for (Annotation candidateAnnotation : candidates) {
            Optional<A> metaAnnotation;
            Class<? extends Annotation> candidateAnnotationType = candidateAnnotation.annotationType();
            if (isJavaLangAnnotation.test(candidateAnnotationType) || !visited.add(candidateAnnotation) || !(metaAnnotation = FieldInjector.findAnnotation(candidateAnnotationType, annotationType, inherited, visited)).isPresent()) continue;
            return metaAnnotation;
        }
        return Optional.empty();
    }

    static List<Field> getInterfaceFields(Class<?> clazz) {
        ArrayList<Field> allInterfaceFields = new ArrayList<Field>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            List<Field> localInterfaceFields = FieldInjector.toSortedMutableList(ifc.getFields());
            List superinterfaceFields = FieldInjector.getInterfaceFields(ifc).stream().filter(field -> !FieldInjector.isFieldShadowedByLocalFields(field, localInterfaceFields)).collect(Collectors.toList());
            allInterfaceFields.addAll(superinterfaceFields);
            allInterfaceFields.addAll(localInterfaceFields);
        }
        return allInterfaceFields;
    }

    static List<Field> getSuperclassFields(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (!isSearchable.test(superclass)) {
            return Collections.emptyList();
        }
        return FieldInjector.findAllFieldsInHierarchy(superclass);
    }

    static boolean isFieldShadowedByLocalFields(Field field, List<Field> localFields) {
        return localFields.stream().anyMatch(local -> local.getName().equals(field.getName()));
    }

    static List<Field> toSortedMutableList(Field[] fields) {
        return Arrays.stream(fields).sorted(fieldComparator).collect(Collectors.toCollection(ArrayList::new));
    }

    public static void assertParameterIsOfType(Class<?> actual, Class<?> expected, Class<? extends Annotation> annotationType, Function<String, ? extends RuntimeException> exception) {
        if (actual != expected) {
            throw exception.apply("Can only resolve @" + annotationType.getSimpleName() + " parameter of type " + expected.getName() + " but was: " + actual.getName());
        }
    }

    public static void assertFieldIsOfType(Field field, Class<?> expected, Class<? extends Annotation> annotationType, Function<String, ? extends RuntimeException> exception) {
        if (field.getType() != expected) {
            throw exception.apply("[" + field.getName() + "] Can only resolve @" + annotationType.getSimpleName() + " field of type " + expected.getName() + " but was: " + field.getType().getName());
        }
        if (Modifier.isFinal(field.getModifiers()) || Modifier.isPrivate(field.getModifiers())) {
            throw exception.apply("@" + annotationType.getSimpleName() + " field [" + field.getName() + "] must not be private or final");
        }
    }
}

