/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementData;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.TransientProperty;
import org.eclipse.sapphire.modeling.util.MiscUtil;

public final class Transient<T>
extends Property {
    private T content;

    public Transient(Element element, TransientProperty property) {
        super(element, property);
    }

    public static <TX> Class<Transient<TX>> of(Class<TX> type) {
        return Transient.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshEnablement(false);
            this.refreshValidation(false);
        }
    }

    @Override
    public TransientProperty definition() {
        return (TransientProperty)super.definition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T content() {
        this.init();
        Transient transient_ = this;
        synchronized (transient_) {
            return this.content;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean empty() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            return this.content == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(T content) {
        this.init();
        PropertyContentEvent event = null;
        Transient transient_ = this;
        synchronized (transient_) {
            if (!MiscUtil.equal(this.content, content)) {
                this.content = content;
                event = new PropertyContentEvent(this);
            }
        }
        if (event != null) {
            this.broadcast(event);
            this.refreshEnablement(false);
            this.refreshValidation(false);
        }
    }

    @Override
    public void clear() {
        this.write(null);
    }

    @Override
    public void copy(Element source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        Property p = source.property((PropertyDef)this.definition());
        if (p instanceof Transient) {
            this.write(((Transient)p).content());
        }
    }

    @Override
    public void copy(ElementData source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        Object content = source.read(this.name());
        if (this.definition().getTypeClass().isInstance(content)) {
            this.write(content);
        } else {
            this.clear();
        }
    }

    @Override
    public boolean holds(Element element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        return false;
    }

    @Override
    public boolean holds(Property property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        return this == property;
    }

    public String toString() {
        T content = this.content();
        return content == null ? "<null>" : content.toString();
    }
}

