/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.PatternConstructor;

public class FileNamePatternSearchScope
extends TextSearchScope {
    private static final boolean IS_CASE_SENSITIVE_FILESYSTEM = !new File("Temp").equals(new File("temp"));
    private final String fDescription;
    private final IResource[] fRootElements;
    private final Set<String> fFileNamePatterns;
    private Matcher fFileNameMatcher;
    private boolean fVisitDerived;

    public static FileNamePatternSearchScope newSearchScope(String description, IResource[] resources, boolean includeDerived) {
        return new FileNamePatternSearchScope(description, FileNamePatternSearchScope.removeRedundantEntries(resources, includeDerived), includeDerived);
    }

    private FileNamePatternSearchScope(String description, IResource[] resources, boolean visitDerived) {
        Assert.isNotNull((Object)description);
        this.fDescription = description;
        this.fRootElements = resources;
        this.fFileNamePatterns = new HashSet<String>(3);
        this.fFileNameMatcher = null;
        this.fVisitDerived = visitDerived;
    }

    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public IResource[] getRoots() {
        return this.fRootElements;
    }

    @Override
    public boolean contains(IResourceProxy proxy) {
        if (!this.fVisitDerived && proxy.isDerived()) {
            return false;
        }
        if (proxy.getType() == 1) {
            return this.matchesFileName(proxy.getName());
        }
        return true;
    }

    public void addFileNamePattern(String pattern) {
        if (this.fFileNamePatterns.add(pattern)) {
            this.fFileNameMatcher = null;
        }
    }

    public void setFileNamePattern(Pattern pattern) {
        this.fFileNameMatcher = pattern.matcher("");
    }

    public Pattern getFileNamePattern() {
        return this.getFileNameMatcher().pattern();
    }

    public boolean isIncludeDerived() {
        return this.fVisitDerived;
    }

    private Matcher getFileNameMatcher() {
        if (this.fFileNameMatcher == null) {
            Pattern pattern;
            if (this.fFileNamePatterns.isEmpty()) {
                pattern = Pattern.compile(".*");
            } else {
                String[] patternStrings = this.fFileNamePatterns.toArray(new String[this.fFileNamePatterns.size()]);
                pattern = PatternConstructor.createPattern(patternStrings, IS_CASE_SENSITIVE_FILESYSTEM);
            }
            this.fFileNameMatcher = pattern.matcher("");
        }
        return this.fFileNameMatcher;
    }

    private boolean matchesFileName(String fileName) {
        return this.getFileNameMatcher().reset(fileName).matches();
    }

    public String getFileNamePatternDescription() {
        Object[] ext = this.fFileNamePatterns.toArray(new String[this.fFileNamePatterns.size()]);
        Arrays.sort(ext);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < ext.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append((String)ext[i]);
            ++i;
        }
        return buf.toString();
    }

    private static IResource[] removeRedundantEntries(IResource[] elements, boolean includeDerived) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        int i = 0;
        while (i < elements.length) {
            IResource curr = elements[i];
            FileNamePatternSearchScope.addToList(res, curr, includeDerived);
            ++i;
        }
        return res.toArray(new IResource[res.size()]);
    }

    private static void addToList(ArrayList<IResource> res, IResource curr, boolean includeDerived) {
        if (!includeDerived && curr.isDerived(512)) {
            return;
        }
        IPath currPath = curr.getFullPath();
        int k = res.size() - 1;
        while (k >= 0) {
            IResource other = res.get(k);
            IPath otherPath = other.getFullPath();
            if (otherPath.isPrefixOf(currPath)) {
                return;
            }
            if (currPath.isPrefixOf(otherPath)) {
                res.remove(k);
            }
            --k;
        }
        res.add(curr);
    }
}

