/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.OperandEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.OperandResizeValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.AirResizableEditPolicy;
import org.eclipse.sirius.ext.base.Option;

public class OperandResizableEditPolicy
extends AirResizableEditPolicy {
    public OperandResizableEditPolicy() {
        this.setResizeDirections(5);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        this.cancelHorizontalDelta(request);
        OperandEditPart oep = (OperandEditPart)this.getHost();
        OperandResizeValidator operandResizeValidator = new OperandResizeValidator((Operand)oep.getISequenceEvent(), new RequestQuery((Request)request));
        operandResizeValidator.validate();
        Object result = operandResizeValidator.isValid() ? this.getResizeCustomCommand(oep, request) : UnexecutableCommand.INSTANCE;
        return result;
    }

    private static Point getPositionFromView(IGraphicalEditPart part) {
        Point position = new Point();
        if (part.getNotationView() instanceof Node && ((Node)part.getNotationView()).getLayoutConstraint() instanceof Location) {
            Location location = (Location)((Node)part.getNotationView()).getLayoutConstraint();
            position.x = location.getX();
            position.y = location.getY();
        }
        return position;
    }

    private static Dimension getDimensionFromView(IGraphicalEditPart part) {
        Dimension dimension = new Dimension();
        if (part.getNotationView() instanceof Node && ((Node)part.getNotationView()).getLayoutConstraint() instanceof Size) {
            Size size = (Size)((Node)part.getNotationView()).getLayoutConstraint();
            dimension.width = size.getWidth();
            dimension.height = size.getHeight();
        }
        return dimension;
    }

    public static AbstractTransactionalCommand getResizeBorderItemTCommand(IGraphicalEditPart part, ChangeBoundsRequest request) {
        EObject semantic = part.resolveSemanticElement();
        if (semantic instanceof DNodeContainer) {
            double zoom = ((ZoomManager)part.getViewer().getProperty(ZoomManager.class.toString())).getZoom();
            Dimension dimension = OperandResizableEditPolicy.getDimensionFromView(part);
            Point position = OperandResizableEditPolicy.getPositionFromView(part);
            dimension.height = (int)((double)dimension.height + (double)request.getSizeDelta().height / zoom);
            switch (request.getResizeDirection()) {
                case 1: 
                case 9: 
                case 17: {
                    position.y = (int)((double)position.y - (double)request.getSizeDelta().height / zoom);
                    break;
                }
            }
            return new SetBoundsCommand(part.getEditingDomain(), Messages.OperandResizableEditPolicy_resizeSubCommand, (IAdaptable)new EObjectAdapter((EObject)part.getNotationView()), new Rectangle(position, dimension));
        }
        return null;
    }

    private Command getResizeCustomCommand(OperandEditPart self, ChangeBoundsRequest request) {
        CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(self.getEditingDomain(), Messages.OperandResizableEditPolicy_resizeCompositeCommand);
        ctc.add((IUndoableOperation)OperandResizableEditPolicy.getResizeBorderItemTCommand((IGraphicalEditPart)self, request));
        Option operandOption = ISequenceElementAccessor.getOperand((View)self.getNotationView());
        if (operandOption.some()) {
            Operand operand = (Operand)operandOption.get();
            int operandIndex = operand.getIndex();
            if (request.getResizeDirection() == 1) {
                OperandEditPart previousOperandEditPart = this.getPreviousOperandEditPart(operandIndex);
                if (previousOperandEditPart == null && self.getSelected() != 0) {
                    ctc.add((IUndoableOperation)new CommandProxy((Command)UnexecutableCommand.INSTANCE));
                } else if (previousOperandEditPart != null) {
                    Option previousOperandOption = ISequenceElementAccessor.getOperand((View)previousOperandEditPart.getNotationView());
                    Operand previousOperand = (Operand)previousOperandOption.get();
                    Range previousOperandVerticalRange = previousOperand.getVerticalRange();
                    Range combinedFragmentVerticalRange = previousOperand.getCombinedFragment().getVerticalRange();
                    int delta = previousOperandVerticalRange.getLowerBound() - combinedFragmentVerticalRange.getLowerBound();
                    Point newLocation = new Point(0, delta);
                    Dimension newDimension = new Dimension(previousOperand.getBounds().width, previousOperandVerticalRange.width() - request.getSizeDelta().height);
                    ctc.add((IUndoableOperation)this.createOperandSetBoundsCommand((IGraphicalEditPart)previousOperandEditPart, newLocation, newDimension));
                    this.postProcessDefaultCommand(ctc, self);
                }
            } else if (request.getResizeDirection() == 4) {
                OperandEditPart followingOperandEditPart = this.getFollowingOperandEditPart(operandIndex);
                if (followingOperandEditPart == null && self.getSelected() != 0) {
                    ctc.add((IUndoableOperation)new CommandProxy((Command)UnexecutableCommand.INSTANCE));
                } else if (followingOperandEditPart != null) {
                    Option followingOperandOption = ISequenceElementAccessor.getOperand((View)followingOperandEditPart.getNotationView());
                    Operand followingOperand = (Operand)followingOperandOption.get();
                    Range followingOperandVerticalRange = followingOperand.getVerticalRange();
                    Range combinedFragmentVerticalRange = followingOperand.getCombinedFragment().getVerticalRange();
                    int delta = followingOperandVerticalRange.getLowerBound() - combinedFragmentVerticalRange.getLowerBound();
                    Point newLocation = new Point(0, delta + request.getSizeDelta().height);
                    Dimension newDimension = new Dimension(followingOperand.getBounds().width, followingOperandVerticalRange.width() - request.getSizeDelta().height);
                    ctc.add((IUndoableOperation)this.createOperandSetBoundsCommand((IGraphicalEditPart)followingOperandEditPart, newLocation, newDimension));
                    this.postProcessDefaultCommand(ctc, self);
                }
            }
        }
        return new ICommandProxy((ICommand)ctc);
    }

    private void postProcessDefaultCommand(CompositeTransactionalCommand ctc, OperandEditPart self) {
        SequenceEditPartsOperations.addRefreshGraphicalOrderingCommand(ctc, (IGraphicalEditPart)self);
        SequenceEditPartsOperations.addRefreshSemanticOrderingCommand(ctc, (IGraphicalEditPart)self);
        SequenceEditPartsOperations.addSynchronizeSemanticOrderingCommand(ctc, self.getISequenceEvent());
    }

    private AbstractTransactionalCommand createOperandSetBoundsCommand(IGraphicalEditPart part, Point location, Dimension dimension) {
        return new SetBoundsCommand(part.getEditingDomain(), Messages.OperandResizableEditPolicy_resizeSubCommand, (IAdaptable)new EObjectAdapter((EObject)part.getNotationView()), new Rectangle(location, dimension));
    }

    private OperandEditPart getPreviousOperandEditPart(int currentOperandIndex) {
        for (OperandEditPart operandEditPart : Iterables.filter((Iterable)this.getHost().getParent().getChildren(), OperandEditPart.class)) {
            Operand operand;
            int operandIndex;
            Option operandOption = ISequenceElementAccessor.getOperand((View)operandEditPart.getNotationView());
            if (!operandOption.some() || (operandIndex = (operand = (Operand)operandOption.get()).getIndex()) != currentOperandIndex - 1) continue;
            return operandEditPart;
        }
        return null;
    }

    private OperandEditPart getFollowingOperandEditPart(int currentOperandIndex) {
        for (OperandEditPart operandEditPart : Iterables.filter((Iterable)this.getHost().getParent().getChildren(), OperandEditPart.class)) {
            Operand operand;
            int operandIndex;
            Option operandOption = ISequenceElementAccessor.getOperand((View)operandEditPart.getNotationView());
            if (!operandOption.some() || (operandIndex = (operand = (Operand)operandOption.get()).getIndex()) != currentOperandIndex + 1) continue;
            return operandEditPart;
        }
        return null;
    }

    private void cancelHorizontalDelta(ChangeBoundsRequest request) {
        Dimension sizeDelta;
        if (request == null) {
            return;
        }
        Point moveDelta = request.getMoveDelta();
        if (moveDelta != null) {
            request.setMoveDelta(new Point(0, moveDelta.y));
        }
        if ((sizeDelta = request.getSizeDelta()) != null) {
            request.setSizeDelta(new Dimension(0, sizeDelta.height));
        }
    }

    private void cancelVerticalDelta(ChangeBoundsRequest request) {
        Dimension sizeDelta;
        if (request == null) {
            return;
        }
        Point moveDelta = request.getMoveDelta();
        if (moveDelta != null) {
            request.setMoveDelta(new Point(moveDelta.x, 0));
        }
        if ((sizeDelta = request.getSizeDelta()) != null) {
            request.setSizeDelta(new Dimension(sizeDelta.width, 0));
        }
    }

    protected Command getAutoSizeCommand(Request request) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getAlignCommand(AlignmentRequest request) {
        return UnexecutableCommand.INSTANCE;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.cancelHorizontalDelta(request);
        RequestQuery query = new RequestQuery((Request)request);
        if (query.isMove()) {
            this.cancelVerticalDelta(request);
        }
        super.showChangeBoundsFeedback(request);
    }

    protected void createResizeHandle(List handles, int direction) {
        if ((5 & direction) == direction) {
            super.createResizeHandle(handles, direction);
        }
    }
}

