/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.helper.decoration.DecorationHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;

public final class ChangeLayerActivationCommand
extends RecordingCommand {
    private DDiagram dDiagram;
    private Layer layer;
    private IProgressMonitor monitor;

    public ChangeLayerActivationCommand(TransactionalEditingDomain domain, DDiagram dDiagram, Layer layer, IProgressMonitor monitor) {
        super(domain, dDiagram.getActivatedLayers().contains((Object)layer) ? Messages.ChangeLayerActivationCommand_hideLabel : MessageFormat.format(Messages.ChangeLayerActivationCommand_showLabel, new IdentifiedElementQuery((IdentifiedElement)layer).getLabel()));
        this.dDiagram = dDiagram;
        this.layer = layer;
        this.monitor = monitor;
    }

    protected void doExecute() {
        try {
            this.monitor.beginTask(Messages.ChangeLayerActivationCommand_executeMsg, 3);
            boolean transientLayer = LayerHelper.isTransientLayer(this.layer);
            if (transientLayer) {
                NotificationUtil.sendNotification((EObject)this.dDiagram, (int)0, (int)2);
            }
            this.monitor.worked(1);
            if (!transientLayer) {
                if (this.dDiagram.getActivatedLayers().contains((Object)this.layer)) {
                    this.dDiagram.getActivatedLayers().remove((Object)this.layer);
                } else {
                    this.dDiagram.getActivatedLayers().add((Object)this.layer);
                }
            } else if (this.dDiagram.getActivatedTransientLayers().contains((Object)this.layer)) {
                if (((AdditionalLayer)this.layer).isOptional()) {
                    this.dDiagram.getActivatedTransientLayers().remove((Object)this.layer);
                }
            } else {
                this.dDiagram.getActivatedTransientLayers().add((Object)((AdditionalLayer)this.layer));
            }
            this.monitor.worked(1);
            if (!transientLayer) {
                new RefreshRepresentationsCommand(TransactionUtil.getEditingDomain((EObject)this.dDiagram), (IProgressMonitor)new SubProgressMonitor(this.monitor, 1), new DRepresentation[]{this.dDiagram}).execute();
            } else {
                DecorationHelper decoHelper = new DecorationHelper(this.dDiagram);
                decoHelper.updateDecorations(Lists.newArrayList((Object[])new Layer[]{this.layer}));
                NotificationUtil.sendNotification((EObject)this.dDiagram, (int)1, (int)2);
            }
            this.monitor.worked(1);
        }
        finally {
            this.monitor.done();
        }
    }

    public void dispose() {
        super.dispose();
        this.dDiagram = null;
        this.layer = null;
    }
}

