/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.Deflater;
import org.eclipse.team.svn.revision.graph.cache.BytesUtility;
import org.eclipse.team.svn.revision.graph.cache.CacheRevision;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryCacheWriteHelper {
    protected final RepositoryCache repositoryCache;

    public RepositoryCacheWriteHelper(RepositoryCache repositoryCache) {
        this.repositoryCache = repositoryCache;
    }

    public void save() throws IOException {
        File cacheFile = this.repositoryCache.cacheFile;
        DataOutputStream bytesWriter = new DataOutputStream(new FileOutputStream(cacheFile));
        Deflater encoder = new Deflater();
        try {
            bytesWriter.writeInt(this.repositoryCache.cacheVersion);
            this.saveRevisions(bytesWriter, encoder);
            this.savePaths(bytesWriter, encoder);
            this.saveAuthors(bytesWriter, encoder);
            this.saveMessages(bytesWriter, encoder);
            this.saveMergeInfo(bytesWriter, encoder);
        }
        catch (Throwable throwable) {
            try {
                bytesWriter.close();
            }
            catch (IOException iOException) {}
            encoder.end();
            throw throwable;
        }
        try {
            bytesWriter.close();
        }
        catch (IOException iOException) {}
        encoder.end();
    }

    protected void saveRevisions(DataOutput out, Deflater encoder) throws IOException {
        List<CacheRevision> revisionsWithoutNulls = this.repositoryCache.getRevisionsWithoutNulls();
        int revisionsCountWithNulls = this.repositoryCache.revisions.length;
        int blocksCount = revisionsWithoutNulls.size() / 1000;
        if (revisionsWithoutNulls.size() % 1000 != 0) {
            ++blocksCount;
        }
        out.writeInt(revisionsCountWithNulls);
        out.writeInt(revisionsWithoutNulls.size());
        out.writeInt(1000);
        out.writeInt(blocksCount);
        this.convertRevisionsToBytes(out, encoder, revisionsWithoutNulls, blocksCount, 1000);
    }

    protected void convertRevisionsToBytes(DataOutput out, Deflater encoder, List<CacheRevision> revisions, int blocksCount, int revisionsInBlock) throws IOException {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        DataOutputStream revisionsBytes = new DataOutputStream(byteArray);
        int revisionsCounter = 0;
        int revisionsInLastBlock = RepositoryCacheWriteHelper.getRevisionsCountInLastBlock(revisions.size(), revisionsInBlock);
        int i = 0;
        while (i < blocksCount) {
            int revisionsCount = revisionsInBlock;
            if (i == blocksCount - 1) {
                revisionsCount = revisionsInLastBlock;
            }
            int j = 0;
            while (j < revisionsCount) {
                CacheRevision revision = revisions.get(revisionsCounter++);
                byte[] revisionBytes = revision.toBytes();
                BytesUtility.writeBytesWithLength(revisionsBytes, revisionBytes);
                ++j;
            }
            BytesUtility.compressAndWrite(byteArray.toByteArray(), out, encoder);
            byteArray.reset();
            ++i;
        }
    }

    public static int getRevisionsCountInLastBlock(int revisionsCount, int revisionsInBlock) {
        int tmp = revisionsCount % revisionsInBlock;
        int revisionsInLastBlock = tmp == 0 ? revisionsInBlock : tmp;
        return revisionsInLastBlock;
    }

    protected void savePaths(DataOutput out, Deflater encoder) throws IOException {
        this.repositoryCache.pathStorage.save(out, encoder);
    }

    protected void saveAuthors(DataOutput out, Deflater encoder) throws IOException {
        BytesUtility.compressAndWrite(this.repositoryCache.authors.toBytes(), out, encoder);
    }

    protected void saveMessages(DataOutput out, Deflater encoder) throws IOException {
        BytesUtility.compressAndWrite(this.repositoryCache.messages.toBytes(), out, encoder);
    }

    protected void saveMergeInfo(DataOutput out, Deflater encoder) throws IOException {
        BytesUtility.compressAndWrite(this.repositoryCache.mergeInfo.toBytes(), out, encoder);
    }
}

