/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.compare;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.svn.ui.SVNUIMessages;

public class ConflictingFileEditorInput
extends CompareEditorInput {
    protected IFile target;
    protected IFile left;
    protected IFile right;
    protected IFile ancestor;
    protected MergeElement targetElement;

    public ConflictingFileEditorInput(CompareConfiguration configuration, IFile target, IFile left, IFile right, IFile ancestor) {
        super(configuration);
        this.target = target;
        this.left = left;
        this.right = right;
        this.ancestor = ancestor;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        CompareConfiguration cc = this.getCompareConfiguration();
        Image img = CompareUI.getImage((IAdaptable)this.target);
        cc.setLeftImage(img);
        cc.setRightImage(img);
        cc.setAncestorImage(img);
        cc.setLeftLabel(String.valueOf(this.target.getName()) + " " + SVNUIMessages.ConflictingFileEditorInput_Working);
        cc.setRightLabel(String.valueOf(this.target.getName()) + " " + SVNUIMessages.ConflictingFileEditorInput_Repository);
        cc.setAncestorLabel(String.valueOf(this.target.getName()) + " " + SVNUIMessages.ConflictingFileEditorInput_Base);
        this.setTitle(String.valueOf(this.target.getName()) + " " + SVNUIMessages.ConflictingFileEditorInput_EditConflicts);
        InputStream stream = null;
        try {
            try {
                stream = this.left.getContents();
                byte[] buf = new byte[2048];
                int len = 0;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                while ((len = stream.read(buf)) > 0) {
                    output.write(buf, 0, len);
                }
                this.targetElement = new MergeElement((IResource)this.target, output.toByteArray(), true);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
        try {
            MergeElement rightRef = new MergeElement((IResource)this.right);
            rightRef.setCharsetReference(this.targetElement);
            MergeElement ancestorRef = new MergeElement((IResource)this.ancestor);
            ancestorRef.setCharsetReference(this.targetElement);
            Object object = new Differencer().findDifferences(true, monitor, null, (Object)ancestorRef, (Object)this.targetElement, (Object)rightRef);
            return object;
        }
        finally {
            monitor.done();
        }
    }

    public Object getAdapter(Class adapter) {
        if (IFile.class.equals((Object)adapter)) {
            return this.target;
        }
        return super.getAdapter(adapter);
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        this.targetElement.commit(pm);
        this.setDirty(false);
    }

    protected class MergeElement
    extends BufferedResourceNode {
        protected boolean editable;
        protected BufferedResourceNode charsetReference;

        public BufferedResourceNode getCharsetReference() {
            return this.charsetReference;
        }

        public void setCharsetReference(BufferedResourceNode charsetReference) {
            this.charsetReference = charsetReference;
        }

        public MergeElement(IResource resource) {
            this(resource, null, false);
        }

        public MergeElement(IResource resource, byte[] initialContent, boolean editable) {
            super(resource);
            this.editable = editable;
            if (initialContent != null) {
                this.setContent(initialContent);
            }
        }

        public String getCharset() {
            return this.charsetReference != null ? this.charsetReference.getCharset() : super.getCharset();
        }

        public String getType() {
            String extension = ConflictingFileEditorInput.this.target.getFileExtension();
            return extension == null ? "???" : extension;
        }

        public boolean isEditable() {
            return this.editable;
        }
    }
}

