/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ctf.core.trace.iterator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ctf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.ctf.core.trace.iterator.CtfIterator;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocationInfo;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfTmfContext;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public class CtfIteratorManager {
    private static final int MAX_SIZE = 100;
    private final Map<CtfTmfContext, CtfIterator> fMap;
    private final List<CtfTmfContext> fRandomAccess;
    private final Lock fAccessLock = new ReentrantLock();
    private final CtfTmfTrace fTrace;
    private final Random fRnd;

    public CtfIteratorManager(CtfTmfTrace trace) {
        this.fMap = new HashMap<CtfTmfContext, CtfIterator>();
        this.fRandomAccess = new ArrayList<CtfTmfContext>();
        this.fRnd = new Random(System.nanoTime());
        this.fTrace = trace;
    }

    public CtfIterator getIterator(CtfTmfContext context) {
        CtfIterator iter = this.fMap.get(context);
        if (iter == null) {
            this.fAccessLock.lock();
            try {
                if (this.fRandomAccess.size() < 100) {
                    iter = (CtfIterator)this.fTrace.createIterator();
                    this.addElement(context, iter);
                } else {
                    iter = this.replaceRandomElement(context);
                }
                if (context.getLocation() != null) {
                    CtfLocationInfo location = (CtfLocationInfo)context.getLocation().getLocationInfo();
                    iter.seek(location);
                }
            }
            finally {
                this.fAccessLock.unlock();
            }
        }
        return iter;
    }

    public void removeIterator(CtfTmfContext context) {
        this.fAccessLock.lock();
        try {
            Throwable throwable = null;
            Object var3_3 = null;
            try {
                CtfIterator removed = this.fMap.remove(context);
                if (removed != null) {
                    removed.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.fRandomAccess.remove(context);
        }
        finally {
            this.fAccessLock.unlock();
        }
    }

    private void addElement(CtfTmfContext context, CtfIterator elem) {
        this.fAccessLock.lock();
        try {
            this.fMap.put(context, elem);
            this.fRandomAccess.add(context);
        }
        finally {
            this.fAccessLock.unlock();
        }
    }

    private CtfIterator replaceRandomElement(CtfTmfContext context) {
        this.fAccessLock.lock();
        try {
            int size = this.fRandomAccess.size();
            int pos = this.fRnd.nextInt(size);
            CtfTmfContext victim = this.fRandomAccess.get(pos);
            this.fRandomAccess.set(pos, context);
            CtfIterator elem = (CtfIterator)NonNullUtils.checkNotNull((Object)this.fMap.remove(victim));
            if (elem.isClosed()) {
                Activator.getDefault().logError("Found closed iterator in iterator manager for trace " + (Object)((Object)victim.getTrace()));
                elem.dispose();
                elem = (CtfIterator)this.fTrace.createIterator();
            }
            this.fMap.put(context, elem);
            victim.dispose();
            CtfIterator ctfIterator = elem;
            return ctfIterator;
        }
        finally {
            this.fAccessLock.unlock();
        }
    }

    public void dispose() {
        this.fAccessLock.lock();
        try {
            for (CtfIterator iterator : this.fMap.values()) {
                iterator.dispose();
            }
            this.fMap.clear();
            this.fRandomAccess.clear();
        }
        finally {
            this.fAccessLock.unlock();
        }
    }
}

