/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.TmfUiTracer;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.preferences.SDViewPref;

public abstract class GraphNode {
    private static final String UI_DELIMITER = "*****************************\n";
    private int fStartEventOccurrence = 0;
    private int fEndEventOccurrence = 0;
    private String fPrefId = "PREF_SYNC_MESS";
    private boolean fSelected = false;
    private boolean fFocused = false;
    private boolean fHasChilden = false;
    private String fName = "";
    private Map<String, List<GraphNode>> fNodes;
    private Map<String, List<GraphNode>> fForwardNodes;
    private Map<String, List<GraphNode>> fBackwardNodes;
    private Map<String, Integer> fIndexes;
    private Map<String, Boolean> fForwardSort;
    private Map<String, Boolean> fBackwardSort;

    public void resetIndex() {
        if (!this.fHasChilden) {
            return;
        }
        for (Map.Entry<String, Integer> entry : this.fIndexes.entrySet()) {
            entry.setValue(0);
        }
    }

    public void addNode(GraphNode nodeToAdd) {
        if (!this.fHasChilden) {
            this.fNodes = new HashMap<String, List<GraphNode>>(2);
            this.fForwardNodes = new HashMap<String, List<GraphNode>>(2);
            this.fBackwardNodes = new HashMap<String, List<GraphNode>>(2);
            this.fIndexes = new HashMap<String, Integer>(2);
            this.fBackwardSort = new HashMap<String, Boolean>(2);
            this.fForwardSort = new HashMap<String, Boolean>(2);
            this.fHasChilden = true;
        }
        if (nodeToAdd == null) {
            return;
        }
        if (this.fNodes.get(nodeToAdd.getArrayId()) == null) {
            this.fNodes.put(nodeToAdd.getArrayId(), new ArrayList(1));
            this.fIndexes.put(nodeToAdd.getArrayId(), 0);
            this.fForwardNodes.put(nodeToAdd.getArrayId(), new ArrayList(1));
            this.fForwardSort.put(nodeToAdd.getArrayId(), Boolean.FALSE);
            if (nodeToAdd.getBackComparator() != null) {
                this.fBackwardNodes.put(nodeToAdd.getArrayId(), new ArrayList(1));
                this.fBackwardSort.put(nodeToAdd.getArrayId(), Boolean.FALSE);
            }
        }
        List<GraphNode> fNodeList = this.fForwardNodes.get(nodeToAdd.getArrayId());
        List<GraphNode> bNodeList = null;
        if (this.fBackwardNodes != null) {
            bNodeList = this.fBackwardNodes.get(nodeToAdd.getArrayId());
        }
        if (fNodeList != null && fNodeList.size() > 0) {
            GraphNode node = fNodeList.get(fNodeList.size() - 1);
            Comparator<GraphNode> fcomp = nodeToAdd.getComparator();
            Comparator<GraphNode> bcomp = nodeToAdd.getBackComparator();
            if (fcomp != null && fcomp.compare(node, nodeToAdd) > 0) {
                this.fForwardSort.put(nodeToAdd.getArrayId(), Boolean.TRUE);
            }
            if (bcomp != null && bcomp.compare(node, nodeToAdd) > 0) {
                this.fBackwardSort.put(nodeToAdd.getArrayId(), Boolean.TRUE);
            }
        }
        if (fNodeList == null) {
            fNodeList = new ArrayList<GraphNode>();
        }
        fNodeList.add(nodeToAdd);
        this.fNodes.put(nodeToAdd.getArrayId(), fNodeList);
        this.fForwardNodes.put(nodeToAdd.getArrayId(), fNodeList);
        if (bNodeList != null && nodeToAdd.getBackComparator() != null) {
            bNodeList.add(nodeToAdd);
            this.fBackwardNodes.put(nodeToAdd.getArrayId(), bNodeList);
        }
    }

    public void setName(String nodeName) {
        this.fName = nodeName;
    }

    public String getName() {
        return this.fName;
    }

    public void setSelected(boolean selection) {
        this.fSelected = selection;
    }

    public void setFocused(boolean focus) {
        this.fFocused = focus;
    }

    public boolean isSelected() {
        return this.fSelected;
    }

    public boolean hasFocus() {
        return this.fFocused;
    }

    public abstract boolean contains(int var1, int var2);

    public abstract int getX();

    public abstract int getY();

    public abstract int getHeight();

    public abstract int getWidth();

    protected abstract void draw(IGC var1);

    public boolean isVisible(int x, int y, int width, int height) {
        return true;
    }

    public Comparator<GraphNode> getComparator() {
        return null;
    }

    public Comparator<GraphNode> getBackComparator() {
        return null;
    }

    public boolean isSameAs(GraphNode node) {
        return false;
    }

    public abstract String getArrayId();

    public boolean positiveDistanceToPoint(int x, int y) {
        return false;
    }

    public GraphNode getNodeAt(int x, int y) {
        GraphNode toReturn = null;
        if (!this.fHasChilden) {
            return null;
        }
        GraphNode node = null;
        for (Map.Entry<String, List<GraphNode>> entry : this.fNodes.entrySet()) {
            List<GraphNode> list = entry.getValue();
            int index = (Integer)NonNullUtils.checkNotNull((Object)this.fIndexes.get(entry.getKey()));
            node = this.getNodeFromListAt(x, y, list, index);
            if (toReturn == null) {
                toReturn = node;
            }
            if (node == null) continue;
            GraphNode internalNode = node.getNodeAt(x, y);
            if (internalNode != null) {
                return internalNode;
            }
            if (Math.abs(node.getWidth()) >= Math.abs(toReturn.getWidth()) && Math.abs(node.getHeight()) >= Math.abs(toReturn.getHeight())) continue;
            toReturn = node;
        }
        return toReturn;
    }

    public List<GraphNode> getNodeList(GraphNode from, GraphNode to) {
        ArrayList<GraphNode> result = new ArrayList<GraphNode>();
        if (from != null) {
            result.add(from);
        } else if (to != null) {
            result.add(to);
        }
        if (from == null || to == null) {
            return result;
        }
        if (from == to) {
            return result;
        }
        int startX = Math.min(from.getX(), Math.min(to.getX(), Math.min(from.getX() + from.getWidth(), to.getX() + to.getWidth())));
        int endX = Math.max(from.getX(), Math.max(to.getX(), Math.max(from.getX() + from.getWidth(), to.getX() + to.getWidth())));
        int startY = Math.min(from.getY(), Math.min(to.getY(), Math.min(from.getY() + from.getHeight(), to.getY() + to.getHeight())));
        int endY = Math.max(from.getY(), Math.max(to.getY(), Math.max(from.getY() + from.getHeight(), to.getY() + to.getHeight())));
        if (!this.fHasChilden) {
            return result;
        }
        for (Map.Entry<String, List<GraphNode>> entry : this.fNodes.entrySet()) {
            List<GraphNode> nodesList = entry.getValue();
            if (nodesList == null || nodesList.isEmpty()) {
                return null;
            }
            int i = 0;
            while (i < nodesList.size()) {
                int ny;
                GraphNode node = nodesList.get(i);
                int nw = node.getWidth();
                int nh = node.getHeight();
                int nx = node.getX();
                if (GraphNode.contains(startX, startY, endX - startX, endY - startY, nx + 1, (ny = node.getY()) + 1) && GraphNode.contains(startX, startY, endX - startX, endY - startY, nx + nw - 2, ny + nh - 2)) {
                    result.add(node);
                }
                result.addAll(node.getNodeList(from, to));
                ++i;
            }
        }
        if (!result.contains(to)) {
            result.add(to);
        }
        return result;
    }

    protected GraphNode getNodeFromListAt(int x, int y, List<GraphNode> list, int fromIndex) {
        if (list == null) {
            return null;
        }
        int i = fromIndex;
        while (i < list.size()) {
            GraphNode node = list.get(i);
            if (node.contains(x, y)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public int getStartOccurrence() {
        return this.fStartEventOccurrence;
    }

    public int getEndOccurrence() {
        return this.fEndEventOccurrence;
    }

    public void updateIndex(int x, int y, int width, int height) {
        if (!this.fHasChilden) {
            return;
        }
        if (TmfUiTracer.isIndexTraced()) {
            TmfUiTracer.traceIndex(UI_DELIMITER);
            TmfUiTracer.traceIndex("Visible area position in virtual screen (x,y)= " + x + " " + y + "\n\n");
        }
        for (Map.Entry<String, List<GraphNode>> entry : this.fNodes.entrySet()) {
            String nodeType = entry.getKey();
            int direction = 1;
            int drawIndex = (Integer)NonNullUtils.checkNotNull((Object)this.fIndexes.get(nodeType));
            if (entry.getValue() != null && entry.getValue().size() > 1) {
                if (entry.getValue().get(drawIndex).positiveDistanceToPoint(x, y)) {
                    direction = -1;
                }
                if (drawIndex == 0) {
                    direction = 1;
                }
                List<GraphNode> nodes = this.fBackwardNodes.get(nodeType);
                if (direction == -1 && nodes != null) {
                    GraphNode currentNode = entry.getValue().get(drawIndex);
                    drawIndex = Arrays.binarySearch(nodes.toArray(new GraphNode[nodes.size()]), entry.getValue().get(drawIndex), currentNode.getBackComparator());
                    entry.setValue(nodes);
                    if (drawIndex < 0) {
                        drawIndex = 0;
                        direction = 1;
                    } else {
                        entry.setValue(this.fBackwardNodes.get(nodeType));
                    }
                }
                GraphNode prev = null;
                int i = drawIndex;
                while (i < entry.getValue().size() && i >= 0) {
                    drawIndex = i;
                    this.fIndexes.put(nodeType, i);
                    GraphNode currentNode = entry.getValue().get(i);
                    if (prev == null) {
                        prev = currentNode;
                    }
                    Comparator<GraphNode> comp = currentNode.getComparator();
                    Map<String, Boolean> sort = this.fForwardSort;
                    if (direction == -1 && currentNode.getBackComparator() != null) {
                        comp = currentNode.getBackComparator();
                        sort = this.fBackwardSort;
                    }
                    if (i < entry.getValue().size() - 1) {
                        GraphNode next = entry.getValue().get(i + 1);
                        if (comp != null && comp.compare(currentNode, next) > 0) {
                            sort.put(nodeType, Boolean.TRUE);
                        }
                    }
                    if (direction == 1) {
                        if (entry.getValue().get(i).positiveDistanceToPoint(x, y)) {
                            break;
                        }
                    } else if (currentNode.getBackComparator() == null) {
                        if (!currentNode.positiveDistanceToPoint(x, y)) {
                            break;
                        }
                    } else if (currentNode.isVisible(x, y, width, height) && !currentNode.positiveDistanceToPoint(x, y)) {
                        if (comp != null && comp.compare(currentNode, prev) <= 0) {
                            break;
                        }
                    } else if (comp != null && comp.compare(currentNode, prev) <= 0) {
                        prev = currentNode;
                    }
                    i += direction;
                }
                entry.setValue(this.fForwardNodes.get(nodeType));
                if (this.fBackwardNodes.get(nodeType) != null && direction == -1) {
                    int index = (Integer)NonNullUtils.checkNotNull((Object)this.fIndexes.get(nodeType));
                    List<GraphNode> list = entry.getValue();
                    List backList = (List)NonNullUtils.checkNotNull(this.fBackwardNodes.get(nodeType));
                    GraphNode currentNode = (GraphNode)backList.get(index);
                    if (index > 0) {
                        index = Arrays.binarySearch(list.toArray(new GraphNode[list.size()]), (GraphNode)backList.get(index), currentNode.getComparator());
                        if (index < 0) {
                            index = 0;
                        }
                        this.fIndexes.put(nodeType, index);
                    }
                }
                i = drawIndex;
                while (i < entry.getValue().size() && i >= 0) {
                    GraphNode toDraw = entry.getValue().get(i);
                    toDraw.updateIndex(x, y, width, height);
                    if (!toDraw.isVisible(x, y, width, height)) break;
                    ++i;
                }
            }
            if (!TmfUiTracer.isIndexTraced()) continue;
            TmfUiTracer.traceIndex("First drawn " + nodeType + " index = " + drawIndex + "\n");
            TmfUiTracer.traceIndex(String.valueOf(nodeType) + " found in " + 0 + " iterations\n");
        }
        if (TmfUiTracer.isIndexTraced()) {
            TmfUiTracer.traceIndex(UI_DELIMITER);
        }
    }

    protected void drawChildenNodes(IGC context) {
        boolean sort;
        if (!this.fHasChilden) {
            return;
        }
        for (Map.Entry<String, Boolean> entry : this.fForwardSort.entrySet()) {
            sort = entry.getValue();
            if (!sort) continue;
            this.sortNodes(this.fForwardNodes, entry, true);
        }
        for (Map.Entry<String, Boolean> entry : this.fBackwardSort.entrySet()) {
            sort = entry.getValue();
            if (!sort) continue;
            this.sortNodes(this.fBackwardNodes, entry, false);
        }
        if (TmfUiTracer.isDisplayTraced()) {
            TmfUiTracer.traceDisplay(UI_DELIMITER);
        }
        int arrayStep = 1;
        if ((float)(Metrics.getMessageFontHeigth() + 20) * context.getZoom() < 1.0f) {
            arrayStep = Math.round(1.0f / ((float)(Metrics.getMessageFontHeigth() + 20) * context.getZoom()));
        }
        int count = 0;
        for (Map.Entry<String, Boolean> entry : this.fForwardSort.entrySet()) {
            count = 0;
            String nodeType = entry.getKey();
            GraphNode node = (GraphNode)((List)NonNullUtils.checkNotNull(this.fNodes.get(nodeType))).get(0);
            context.setFont(SDViewPref.getInstance().getFont(node.fPrefId));
            int index = (Integer)NonNullUtils.checkNotNull((Object)this.fIndexes.get(nodeType));
            count = this.drawNodes(context, this.fNodes.get(nodeType), index, arrayStep);
            if (!TmfUiTracer.isDisplayTraced()) continue;
            TmfUiTracer.traceDisplay(String.valueOf(count) + " " + nodeType + " drawn, starting from index " + index + "\r\n");
        }
        if (TmfUiTracer.isDisplayTraced()) {
            TmfUiTracer.traceDisplay(UI_DELIMITER);
        }
    }

    private void sortNodes(Map<String, List<GraphNode>> nodesToSort, Map.Entry<String, Boolean> sortMapEntry, boolean forward) {
        String nodeType = sortMapEntry.getKey();
        GraphNode[] temp = (GraphNode[])((List)NonNullUtils.checkNotNull(nodesToSort.get(nodeType))).stream().toArray(GraphNode[]::new);
        GraphNode node = (GraphNode)((List)NonNullUtils.checkNotNull(this.fNodes.get(nodeType))).get(0);
        if (forward) {
            Arrays.sort(temp, node.getComparator());
            this.fNodes.put(nodeType, Arrays.asList(temp));
        } else {
            Arrays.sort(temp, node.getBackComparator());
        }
        nodesToSort.put(nodeType, Arrays.asList(temp));
        sortMapEntry.setValue(Boolean.FALSE);
        if (TmfUiTracer.isSortingTraced()) {
            TmfUiTracer.traceSorting(String.valueOf(nodeType) + " array sorted\n");
        }
    }

    protected int drawNodes(IGC context, List<GraphNode> list, int startIndex, int step) {
        if (!this.fHasChilden) {
            return 0;
        }
        GraphNode last = null;
        int nodesCount = 0;
        if (list.isEmpty()) {
            return 0;
        }
        GraphNode node = list.get(0);
        context.setFont(SDViewPref.getInstance().getFont(node.fPrefId));
        Comparator<GraphNode> comparator = node.getComparator();
        int i = startIndex;
        while (i < list.size()) {
            int ch;
            int cw;
            int cy;
            int cx;
            GraphNode toDraw = list.get(i);
            if (i < list.size() - 1) {
                GraphNode next = list.get(i + 1);
                if (comparator != null && comparator.compare(toDraw, next) > 0) {
                    this.fForwardSort.put(next.getArrayId(), Boolean.TRUE);
                }
            }
            if (!toDraw.isVisible(cx = context.getContentsX(), cy = context.getContentsY(), cw = context.getVisibleWidth(), ch = context.getVisibleHeight()) && toDraw.positiveDistanceToPoint(cx + cw, cy + ch)) break;
            if ((!toDraw.isSameAs(last) || toDraw.isSelected()) && toDraw.isVisible(context.getContentsX(), context.getContentsY(), context.getVisibleWidth(), context.getVisibleHeight())) {
                ++nodesCount;
                toDraw.draw(context);
                if (this.hasFocus()) {
                    toDraw.drawFocus(context);
                }
            }
            last = toDraw;
            i += step;
        }
        return nodesCount;
    }

    public void drawFocus(IGC context) {
        context.drawFocus(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public static boolean contains(int x, int y, int width, int height, int px, int py) {
        int locX = x;
        int locY = y;
        int locWidth = width;
        int locHeight = height;
        if (width < 0) {
            locX += width;
            locWidth = -locWidth;
        }
        if (height < 0) {
            locY += height;
            locHeight = -locHeight;
        }
        return px >= locX && py >= locY && px - locX <= locWidth && py - locY <= locHeight;
    }

    protected void setStartOccurrence(int occurence) {
        this.fStartEventOccurrence = occurence;
    }

    protected void setEndOccurrence(int occurence) {
        this.fEndEventOccurrence = occurence;
    }

    protected void setColorPrefId(String id) {
        this.fPrefId = id;
    }

    protected String getColorPrefId() {
        return this.fPrefId;
    }

    protected boolean hasChildren() {
        return this.fHasChilden;
    }

    protected void hasChildren(boolean hasChildren) {
        this.fHasChilden = hasChildren;
    }

    protected Map<String, List<GraphNode>> getNodeMap() {
        return this.fNodes;
    }

    protected Map<String, List<GraphNode>> getForwardNodes() {
        return this.fForwardNodes;
    }

    protected Map<String, List<GraphNode>> getBackwardNodes() {
        return this.fBackwardNodes;
    }

    protected Map<String, Integer> getIndexes() {
        return this.fIndexes;
    }

    protected Map<String, Boolean> getForwardSortMap() {
        return this.fForwardSort;
    }

    protected Map<String, Boolean> getBackwardSortMap() {
        return this.fBackwardSort;
    }
}

