/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.rewriters;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IValueProvider;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;

class VariableMappingExpressionEvaluatorWrapper
implements IExpressionEvaluator {
    private final IExpressionEvaluator wrapped;
    private final Map<String, String> variableMapping;

    public VariableMappingExpressionEvaluatorWrapper(IExpressionEvaluator wrapped, Map<PVariable, PVariable> variableMapping) {
        boolean rewrap = wrapped instanceof VariableMappingExpressionEvaluatorWrapper;
        this.wrapped = rewrap ? ((VariableMappingExpressionEvaluatorWrapper)wrapped).wrapped : wrapped;
        this.variableMapping = Maps.newLinkedHashMap();
        HashMap names = Maps.newHashMap();
        for (PVariable originalVar : variableMapping.keySet()) {
            names.put(originalVar.getName(), originalVar);
        }
        Map<String, String> previousMapping = null;
        if (rewrap) {
            previousMapping = ((VariableMappingExpressionEvaluatorWrapper)wrapped).variableMapping;
        }
        for (String inputParameterName : this.wrapped.getInputParameterNames()) {
            String parameterName = rewrap ? previousMapping.get(inputParameterName) : inputParameterName;
            Preconditions.checkArgument((parameterName != null ? 1 : 0) != 0);
            PVariable original = (PVariable)names.get(parameterName);
            Preconditions.checkArgument((original != null ? 1 : 0) != 0);
            PVariable mapped = variableMapping.get(original);
            if (mapped == null) continue;
            this.variableMapping.put(inputParameterName, mapped.getName());
        }
    }

    @Override
    public String getShortDescription() {
        return this.wrapped.getShortDescription();
    }

    @Override
    public Iterable<String> getInputParameterNames() {
        return this.variableMapping.values();
    }

    @Override
    public Object evaluateExpression(final IValueProvider provider) throws Exception {
        return this.wrapped.evaluateExpression(new IValueProvider(){

            @Override
            public Object getValue(String variableName) throws IllegalArgumentException {
                String mappedVariableName = (String)VariableMappingExpressionEvaluatorWrapper.this.variableMapping.get(variableName);
                Preconditions.checkArgument((mappedVariableName != null ? 1 : 0) != 0, (String)"Could not find variable %s", (Object[])new Object[]{variableName});
                return provider.getValue(mappedVariableName);
            }
        });
    }
}

