/**
 * Copyright (c) 2010-2012, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Zoltan Ujhelyi - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.core.generator;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.runtime.IExtensions;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.viatra.query.runtime.extensibility.SingletonExtensionFactory;
import org.eclipse.viatra.query.tooling.core.generator.ExtensionData;
import org.eclipse.viatra.query.tooling.core.generator.ExtensionGenerator;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.w3c.dom.Element;

@SuppressWarnings("all")
public class GenerateQuerySpecificationExtension {
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private ExtensionGenerator exGen;
  
  public List<ExtensionData> extensionContribution(final PatternModel model) {
    List<ExtensionData> _xifexpression = null;
    EList<Pattern> _patterns = model.getPatterns();
    boolean _isEmpty = _patterns.isEmpty();
    if (_isEmpty) {
      _xifexpression = CollectionLiterals.<ExtensionData>newImmutableList();
    } else {
      ExtensionData _xblockexpression = null;
      {
        final JvmType groupClass = this._eMFPatternLanguageJvmModelInferrerUtil.findInferredClass(model, BaseGeneratedPatternGroup.class);
        String _qualifiedName = groupClass.getQualifiedName();
        final Procedure1<Element> _function = new Procedure1<Element>() {
          @Override
          public void apply(final Element it) {
            final Procedure1<Element> _function = new Procedure1<Element>() {
              @Override
              public void apply(final Element it) {
                String _qualifiedName = groupClass.getQualifiedName();
                GenerateQuerySpecificationExtension.this.exGen.contribAttribute(it, "id", _qualifiedName);
                String _canonicalName = SingletonExtensionFactory.class.getCanonicalName();
                String _plus = (_canonicalName + ":");
                String _qualifiedName_1 = groupClass.getQualifiedName();
                String _plus_1 = (_plus + _qualifiedName_1);
                GenerateQuerySpecificationExtension.this.exGen.contribAttribute(it, "group", _plus_1);
                EList<Pattern> _patterns = model.getPatterns();
                final Function1<Pattern, Boolean> _function = new Function1<Pattern, Boolean>() {
                  @Override
                  public Boolean apply(final Pattern it) {
                    return Boolean.valueOf(GenerateQuerySpecificationExtension.this._eMFPatternLanguageJvmModelInferrerUtil.isPublic(it));
                  }
                };
                Iterable<Pattern> _filter = IterableExtensions.<Pattern>filter(_patterns, _function);
                Iterable<Pattern> _filterNull = IterableExtensions.<Pattern>filterNull(_filter);
                final Function1<Pattern, String> _function_1 = new Function1<Pattern, String>() {
                  @Override
                  public String apply(final Pattern it) {
                    return CorePatternLanguageHelper.getFullyQualifiedName(it);
                  }
                };
                Iterable<String> _map = IterableExtensions.<Pattern, String>map(_filterNull, _function_1);
                final Procedure1<String> _function_2 = new Procedure1<String>() {
                  @Override
                  public void apply(final String fqn) {
                    final Procedure1<Element> _function = new Procedure1<Element>() {
                      @Override
                      public void apply(final Element it) {
                        GenerateQuerySpecificationExtension.this.exGen.contribAttribute(it, "fqn", fqn);
                      }
                    };
                    GenerateQuerySpecificationExtension.this.exGen.contribElement(it, "query-specification", _function);
                  }
                };
                IterableExtensions.<String>forEach(_map, _function_2);
              }
            };
            GenerateQuerySpecificationExtension.this.exGen.contribElement(it, "group", _function);
          }
        };
        _xblockexpression = this.exGen.contribExtension(_qualifiedName, IExtensions.QUERY_SPECIFICATION_EXTENSION_POINT_ID, _function);
      }
      _xifexpression = CollectionLiterals.<ExtensionData>newImmutableList(_xblockexpression);
    }
    return _xifexpression;
  }
  
  public static List<Pair<String, String>> getRemovableExtensionIdentifiers() {
    return CollectionLiterals.<Pair<String, String>>newImmutableList(
      Pair.<String, String>of("", IExtensions.QUERY_SPECIFICATION_EXTENSION_POINT_ID));
  }
}
