/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.viatra.addon.databinding.runtime.adapter.MatcherProperties;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail.DetailElement;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatchContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.DisplayUtil;

public class DetailObserver
extends AbstractObservableList {
    private PatternMatchContent patternMatch;
    private List<DetailElement> details;
    private ValueChangeListener listener;
    private Map<IObservableValue, DetailElement> valueMap;

    public DetailObserver(PatternMatchContent pm) {
        this.patternMatch = pm;
        this.details = new ArrayList<DetailElement>();
        this.valueMap = new HashMap<IObservableValue, DetailElement>();
        this.listener = new ValueChangeListener();
        String[] stringArray = MatcherProperties.getPropertyNames((IQuerySpecification)this.patternMatch.getPatternMatch().specification());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            IObservableValue oval = MatcherProperties.getObservableValue((IQuerySpecification)this.patternMatch.getPatternMatch().specification(), (IPatternMatch)this.patternMatch.getPatternMatch(), (String)param);
            if (oval != null) {
                oval.addValueChangeListener((IValueChangeListener)this.listener);
                DetailElement de = new DetailElement(param, this.createValueRepresentation(oval.getValue()));
                this.addDetail(oval, de, -1);
            } else {
                Object value = this.patternMatch.getPatternMatch().get(param);
                this.details.add(new DetailElement(param, this.createValueRepresentation(value)));
            }
            ++n2;
        }
    }

    private String createValueRepresentation(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof EObject) {
            EObject obj = (EObject)value;
            URI uri = obj.eClass().eResource().getURI();
            AdapterFactoryLabelProvider labelProvider = DisplayUtil.getAdapterFactoryLabelProvider(uri);
            if (labelProvider != null) {
                return labelProvider.getText((Object)obj);
            }
        } else if (value instanceof Collection) {
            return "Collection [" + ((Collection)value).size() + "]";
        }
        return value.toString();
    }

    private void addDetail(IObservableValue ov, DetailElement de, int index) {
        if (index == -1) {
            this.details.add(de);
            this.valueMap.put(ov, de);
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)this.details.size(), (boolean)true, (Object)de)));
        } else {
            this.details.add(index, de);
            this.valueMap.put(ov, de);
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, (Object)de)));
        }
    }

    private void removeDetail(IObservableValue ov, DetailElement de, int index) {
        this.details.remove(index);
        this.valueMap.remove(ov);
        this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, (Object)de)));
    }

    public Object getElementType() {
        return DetailElement.class;
    }

    protected int doGetSize() {
        return this.details.size();
    }

    public Object get(int index) {
        return this.details.get(index);
    }

    private int findElement(DetailElement de) {
        int i = 0;
        for (DetailElement e : this.details) {
            if (e.equals(de)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private class ValueChangeListener
    implements IValueChangeListener {
        private ValueChangeListener() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            IObservableValue ov = event.getObservableValue();
            Object value = ov.getValue();
            DetailElement de = (DetailElement)DetailObserver.this.valueMap.get(ov);
            int index = DetailObserver.this.findElement(de);
            DetailObserver.this.removeDetail(ov, de, index);
            DetailElement newDe = null;
            String data = "";
            data = value == null ? null : (value instanceof Collection ? "Collection [" + ((Collection)value).size() + "]" : value.toString());
            newDe = new DetailElement(de.getKey(), data);
            DetailObserver.this.addDetail(ov, newDe, index);
        }
    }
}

