/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.EventType;

public class ActivationLifeCycle {
    private Table<ActivationState, EventType, ActivationState> stateTransitionTable;
    private ActivationState inactiveState;

    protected ActivationLifeCycle(ActivationState inactiveState) {
        Preconditions.checkArgument((inactiveState != null ? 1 : 0) != 0, (Object)"Inactive state cannot be null");
        this.inactiveState = inactiveState;
    }

    public ActivationState nextActivationState(ActivationState currentState, EventType event) {
        Preconditions.checkNotNull((Object)currentState, (Object)"Cannot find next state for null current state");
        Preconditions.checkNotNull((Object)event, (Object)"Cannot find next state for null event");
        if (this.stateTransitionTable != null) {
            return (ActivationState)this.stateTransitionTable.get((Object)currentState, (Object)event);
        }
        return null;
    }

    public boolean addStateTransition(ActivationState from, EventType event, ActivationState to) {
        Preconditions.checkNotNull((Object)from, (Object)"From state cannot be null!");
        Preconditions.checkNotNull((Object)event, (Object)"Event cannot be null!");
        Preconditions.checkNotNull((Object)to, (Object)"To state cannot be null!");
        if (this.stateTransitionTable == null) {
            this.stateTransitionTable = HashBasedTable.create();
        }
        if (to.equals(this.stateTransitionTable.get((Object)from, (Object)event))) {
            return false;
        }
        this.stateTransitionTable.put((Object)from, (Object)event, (Object)to);
        return true;
    }

    public boolean containsFrom(ActivationState state) {
        return this.stateTransitionTable.containsRow((Object)state);
    }

    public boolean containsTo(ActivationState state) {
        return this.stateTransitionTable.containsValue((Object)state);
    }

    public static ActivationLifeCycle copyOf(ActivationLifeCycle lifeCycle) {
        Preconditions.checkNotNull((Object)lifeCycle, (Object)"Null life cycle cannot be copied!");
        ActivationLifeCycle lc = new ActivationLifeCycle(lifeCycle.inactiveState);
        lc.stateTransitionTable = HashBasedTable.create(lifeCycle.stateTransitionTable);
        return lc;
    }

    public static ActivationLifeCycle create(ActivationState inactiveState) {
        return new ActivationLifeCycle(inactiveState);
    }

    public Table<ActivationState, EventType, ActivationState> getStateTransitionTable() {
        return HashBasedTable.create(this.stateTransitionTable);
    }

    public ActivationState getInactiveState() {
        return this.inactiveState;
    }

    public String toString() {
        return String.format("%s{table=%s}", this.getClass().getName(), this.stateTransitionTable);
    }
}

