/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.reflect;

import org.eclipse.core.runtime.Platform;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleClassLoader
extends ClassLoader {
    private final Bundle m_bundle;

    public BundleClassLoader(Bundle bundle) {
        Assert.isNotNull(bundle);
        this.m_bundle = bundle;
    }

    public BundleClassLoader(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        Assert.isNotNull(bundle, "Unable to find Bundle %s", bundleId);
        this.m_bundle = bundle;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.m_bundle.loadClass(name);
    }

    public static ClassLoader create(Bundle bundle) {
        return new BundleClassLoader(bundle);
    }
}

