/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.gef.header.selection;

import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.text.MessageFormat;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.SideResizeHandle;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.gef.graphical.tools.ResizeTracker;
import org.eclipse.wb.internal.swing.FormLayout.gef.GefMessages;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.selection.DimensionSelectionEditPolicy;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormRowInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeConstantInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeInfo;

public final class RowSelectionEditPolicy
extends DimensionSelectionEditPolicy<FormRowInfo> {
    public RowSelectionEditPolicy(LayoutEditPolicy mainPolicy) {
        super(mainPolicy);
    }

    @Override
    protected Handle createResizeHandle() {
        SideResizeHandle handle = new SideResizeHandle(this.getHost(), 32, 7, false);
        handle.setDragTrackerTool((Tool)new ResizeTracker((EditPart)this.getHost(), 4, (Object)"resize"));
        return handle;
    }

    @Override
    protected Point getTextFeedbackLocation(Point mouseLocation) {
        return new Point(10, mouseLocation.y + 10);
    }

    @Override
    protected String getTextFeedbackText(ChangeBoundsRequest request, boolean inverse) {
        final FormLayoutInfo layout = this.getLayout();
        int pixels = this.getHostFigure().getSize().height;
        int pixelsDelta = request.getSizeDelta().height;
        try {
            FormSizeConstantInfo lowerSize;
            FormSizeInfo sizeCopy = ((FormRowInfo)this.getDimension()).copy().getSize();
            if (sizeCopy.getComponentSize() == null ^ inverse) {
                FormSizeConstantInfo constantSize;
                if (sizeCopy.getConstantSize() == null) {
                    constantSize = new FormSizeConstantInfo(pixels, ConstantSize.PIXEL);
                    ConstantSize.Unit newUnit = sizeCopy.getLowerSize() != null ? sizeCopy.getLowerSize().getUnit() : ConstantSize.DIALOG_UNITS_Y;
                    constantSize.setUnit(newUnit);
                    sizeCopy.setConstantSize(constantSize);
                }
                constantSize = sizeCopy.getConstantSize();
                constantSize.setAsPixels(pixels + pixelsDelta);
                this.m_resizeCommand = new EditCommand((ObjectInfo)layout){

                    protected void executeEdit() throws Exception {
                        ((FormRowInfo)RowSelectionEditPolicy.this.getDimension()).getSize().setConstantSize(constantSize);
                        layout.writeDimensions();
                    }
                };
                return MessageFormat.format(GefMessages.RowSelectionEditPolicy_heightPattern, constantSize.getSource(true, true));
            }
            if (sizeCopy.getLowerSize() == null) {
                lowerSize = new FormSizeConstantInfo(pixels, ConstantSize.PIXEL);
                ConstantSize.Unit newUnit = sizeCopy.getConstantSize() != null ? sizeCopy.getConstantSize().getUnit() : ConstantSize.DIALOG_UNITS_Y;
                lowerSize.setUnit(newUnit);
                sizeCopy.setLowerSize(lowerSize);
            }
            lowerSize = sizeCopy.getLowerSize();
            lowerSize.setAsPixels(pixels + pixelsDelta);
            this.m_resizeCommand = new EditCommand((ObjectInfo)layout){

                protected void executeEdit() throws Exception {
                    FormSizeInfo size = ((FormRowInfo)RowSelectionEditPolicy.this.getDimension()).getSize();
                    if (size.getComponentSize() == null) {
                        size.setComponentSize((Size)Sizes.DEFAULT);
                    }
                    size.setLowerSize(lowerSize);
                    layout.writeDimensions();
                }
            };
            return MessageFormat.format(GefMessages.RowSelectionEditPolicy_minimumHeightPattern, lowerSize.getSource(true, true));
        }
        catch (Throwable throwable) {
            return GefMessages.RowSelectionEditPolicy_exception;
        }
    }
}

