/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.eclipse.xtend.core.macro.ActiveAnnotationContext;
import org.eclipse.xtend.core.macro.RegisterGlobalsContextImpl;
import org.eclipse.xtend.core.macro.TransformationContextImpl;
import org.eclipse.xtend.core.macro.ValidationContextImpl;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.RegisterGlobalsParticipant;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.ValidationContext;
import org.eclipse.xtend.lib.macro.ValidationParticipant;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableNamedElement;
import org.eclipse.xtend.lib.macro.declaration.NamedElement;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class AnnotationProcessor {
    @Inject
    private Provider<TransformationContextImpl> modifyContextProvider;
    @Inject
    private Provider<RegisterGlobalsContextImpl> registerGlobalsContextProvider;
    @Inject
    private Provider<ValidationContextImpl> validationContextProvider;
    @Inject
    private CancellationObserver cancellationObserver;

    public Object indexingPhase(ActiveAnnotationContext ctx, IJvmDeclaredTypeAcceptor acceptor, CancelIndicator monitor) {
        Object _xblockexpression = null;
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"[macros] indexingPhase (AnnotationProcessor.indexingPhase)");
        task.start();
        Object _xtrycatchfinallyexpression = null;
        try {
            Object _processorInstance;
            Object _switchResult = null;
            Object processor = _processorInstance = ctx.getProcessorInstance();
            boolean _matched = false;
            if (processor instanceof RegisterGlobalsParticipant) {
                _matched = true;
                Object _xblockexpression_1 = null;
                RegisterGlobalsContextImpl registerGlobalsCtx = (RegisterGlobalsContextImpl)this.registerGlobalsContextProvider.get();
                registerGlobalsCtx.setAcceptor(acceptor);
                registerGlobalsCtx.setCompilationUnit(ctx.getCompilationUnit());
                Runnable _function = () -> {
                    Functions.Function1 _function_1 = it -> {
                        Object _switchResult_1 = null;
                        boolean _matched_1 = false;
                        if (it instanceof XtendMember) {
                            _matched_1 = true;
                            _switchResult_1 = ctx.getCompilationUnit().toXtendMemberDeclaration((XtendMember)it);
                        }
                        if (!_matched_1 && it instanceof XtendParameter) {
                            _matched_1 = true;
                            _switchResult_1 = ctx.getCompilationUnit().toXtendParameterDeclaration((XtendParameter)it);
                        }
                        MemberDeclaration xtendMember = _switchResult_1;
                        return xtendMember;
                    };
                    ((RegisterGlobalsParticipant)processor).doRegisterGlobals(ListExtensions.map(ctx.getAnnotatedSourceElements(), (Functions.Function1)_function_1), (RegisterGlobalsContext)registerGlobalsCtx);
                };
                _switchResult = _xblockexpression_1 = this.runWithCancelIndiciator(ctx, monitor, _function);
            }
            _xtrycatchfinallyexpression = _switchResult;
        }
        finally {
            task.stop();
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    public Object inferencePhase(ActiveAnnotationContext ctx, CancelIndicator monitor) {
        Object _xblockexpression = null;
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"[macros] inferencePhase (AnnotationProcessor.inferencePhase)");
        task.start();
        Object _xtrycatchfinallyexpression = null;
        try {
            Object _processorInstance;
            Object _switchResult = null;
            Object processor = _processorInstance = ctx.getProcessorInstance();
            boolean _matched = false;
            if (processor instanceof TransformationParticipant) {
                _matched = true;
                Object _xblockexpression_1 = null;
                TransformationContextImpl modifyCtx = (TransformationContextImpl)this.modifyContextProvider.get();
                modifyCtx.setUnit(ctx.getCompilationUnit());
                Runnable _function = () -> {
                    Functions.Function1 _function_1 = it -> {
                        Object _switchResult_1 = null;
                        boolean _matched_1 = false;
                        if (it instanceof XtendMember) {
                            _matched_1 = true;
                            _switchResult_1 = ctx.getCompilationUnit().toXtendMemberDeclaration((XtendMember)it);
                        }
                        if (!_matched_1 && it instanceof XtendParameter) {
                            _matched_1 = true;
                            _switchResult_1 = ctx.getCompilationUnit().toXtendParameterDeclaration((XtendParameter)it);
                        }
                        MemberDeclaration xtendMember = _switchResult_1;
                        Element _primaryGeneratedJavaElement = modifyCtx.getPrimaryGeneratedJavaElement((Element)xtendMember);
                        return (MutableNamedElement)_primaryGeneratedJavaElement;
                    };
                    List map = ListExtensions.map(ctx.getAnnotatedSourceElements(), (Functions.Function1)_function_1);
                    ((TransformationParticipant)processor).doTransform(map, (TransformationContext)modifyCtx);
                };
                _switchResult = _xblockexpression_1 = this.runWithCancelIndiciator(ctx, monitor, _function);
            }
            _xtrycatchfinallyexpression = _switchResult;
        }
        finally {
            task.stop();
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    public Object validationPhase(ActiveAnnotationContext ctx, CancelIndicator monitor) {
        Object _xblockexpression = null;
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"[macros] validationPhase (AnnotationProcessor.validationPhase)");
        task.start();
        Object _xtrycatchfinallyexpression = null;
        try {
            Object _processorInstance;
            Object _switchResult = null;
            Object processor = _processorInstance = ctx.getProcessorInstance();
            boolean _matched = false;
            if (processor instanceof ValidationParticipant) {
                _matched = true;
                Object _xblockexpression_1 = null;
                ValidationContextImpl validationContext = (ValidationContextImpl)this.validationContextProvider.get();
                validationContext.setUnit(ctx.getCompilationUnit());
                Runnable _function = () -> {
                    Functions.Function1 _function_1 = it -> {
                        Object _switchResult_1 = null;
                        boolean _matched_1 = false;
                        if (it instanceof XtendMember) {
                            _matched_1 = true;
                            _switchResult_1 = ctx.getCompilationUnit().toXtendMemberDeclaration((XtendMember)it);
                        }
                        if (!_matched_1 && it instanceof XtendParameter) {
                            _matched_1 = true;
                            _switchResult_1 = ctx.getCompilationUnit().toXtendParameterDeclaration((XtendParameter)it);
                        }
                        MemberDeclaration xtendMember = _switchResult_1;
                        Element _primaryGeneratedJavaElement = validationContext.getPrimaryGeneratedJavaElement((Element)xtendMember);
                        return (NamedElement)_primaryGeneratedJavaElement;
                    };
                    List map = ListExtensions.map(ctx.getAnnotatedSourceElements(), (Functions.Function1)_function_1);
                    ((ValidationParticipant)processor).doValidate(map, (ValidationContext)validationContext);
                };
                _switchResult = _xblockexpression_1 = this.runWithCancelIndiciator(ctx, monitor, _function);
            }
            _xtrycatchfinallyexpression = _switchResult;
        }
        finally {
            task.stop();
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    private Object runWithCancelIndiciator(ActiveAnnotationContext ctx, CancelIndicator cancelIndicator, Runnable runnable) {
        Object _xtrycatchfinallyexpression;
        Object _xblockexpression;
        block6: {
            _xblockexpression = null;
            AtomicBoolean isFinished = new AtomicBoolean(false);
            Functions.Function0 _function = () -> isFinished.get();
            this.cancellationObserver.monitorUntil(ctx, cancelIndicator, (Functions.Function0<? extends Boolean>)_function);
            _xtrycatchfinallyexpression = null;
            try {
                try {
                    runnable.run();
                }
                catch (Throwable _t) {
                    if (!(_t instanceof CancellationException)) {
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    CancellationException e = (CancellationException)_t;
                    _xtrycatchfinallyexpression = null;
                    isFinished.set(true);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                isFinished.set(true);
                throw throwable;
            }
            isFinished.set(true);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    @Singleton
    protected static class CancellationObserver {
        private static final Logger log = Logger.getLogger(CancellationObserver.class);
        @Accessors(value={AccessorType.PROTECTED_GETTER})
        private ExecutorService pool = this.initPool();

        protected CancellationObserver() {
        }

        protected ExecutorService initPool() {
            return Executors.newCachedThreadPool();
        }

        public Future<?> monitorUntil(ActiveAnnotationContext ctx, CancelIndicator cancelIndicator, Functions.Function0<? extends Boolean> isFinished) {
            Runnable _function;
            Future<?> _xblockexpression = null;
            Runnable r = _function = () -> {
                try {
                    while (!((Boolean)isFinished.apply()).booleanValue()) {
                        boolean _isCanceled = cancelIndicator.isCanceled();
                        if (_isCanceled) {
                            CompilationUnitImpl _compilationUnit = ctx.getCompilationUnit();
                            _compilationUnit.setCanceled(true);
                            return;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            Future<?> _xtrycatchfinallyexpression = null;
            try {
                _xtrycatchfinallyexpression = this.pool.submit(r);
            }
            catch (Throwable _t) {
                if (_t instanceof RejectedExecutionException) {
                    RejectedExecutionException e = (RejectedExecutionException)_t;
                    log.debug((Object)e.getMessage(), (Throwable)e);
                    new Thread(r).start();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }

        @Pure
        protected ExecutorService getPool() {
            return this.pool;
        }
    }
}

