/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.columnRename;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.sourceforge.nattable.grid.layer.ColumnHeaderLayer;
import net.sourceforge.nattable.persistence.IPersistable;
import net.sourceforge.nattable.util.PersistenceUtils;
import org.apache.commons.lang.StringUtils;

public class RenameColumnHelper
implements IPersistable {
    public static final String PERSISTENCE_KEY_RENAMED_COLUMN_HEADERS = ".renamedColumnHeaders";
    private final ColumnHeaderLayer columnHeaderLayer;
    private Map<Integer, String> renamedColumnsLabelsByIndex = new TreeMap<Integer, String>();

    public RenameColumnHelper(ColumnHeaderLayer columnHeaderLayer) {
        this.columnHeaderLayer = columnHeaderLayer;
    }

    public boolean renameColumnPosition(int columnPosition, String customColumnName) {
        int index = this.columnHeaderLayer.getColumnIndexByPosition(columnPosition);
        if (index >= 0) {
            if (customColumnName == null) {
                this.renamedColumnsLabelsByIndex.remove(index);
            } else {
                this.renamedColumnsLabelsByIndex.put(index, customColumnName);
            }
            return true;
        }
        return false;
    }

    public String getRenamedColumnLabel(int columnIndex) {
        return this.renamedColumnsLabelsByIndex.get(columnIndex);
    }

    public boolean isColumnRenamed(int columnIndex) {
        return this.renamedColumnsLabelsByIndex.get(columnIndex) != null;
    }

    public boolean isAnyColumnRenamed() {
        return this.renamedColumnsLabelsByIndex.size() > 0;
    }

    public void loadState(String prefix, Properties properties) {
        Object property = properties.get(String.valueOf(prefix) + PERSISTENCE_KEY_RENAMED_COLUMN_HEADERS);
        try {
            this.renamedColumnsLabelsByIndex = PersistenceUtils.parseString(property);
        }
        catch (Exception e) {
            System.err.println("Error while restoring renamed column headers: " + e.getMessage());
            System.err.println("Skipping restore.");
            this.renamedColumnsLabelsByIndex.clear();
        }
    }

    public void saveState(String prefix, Properties properties) {
        String string = PersistenceUtils.mapAsString(this.renamedColumnsLabelsByIndex);
        if (!StringUtils.isEmpty((String)string)) {
            properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_RENAMED_COLUMN_HEADERS, string);
        }
    }
}

