/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.flash;

import java.util.ArrayList;
import org.eclipse.actf.model.dom.dombycom.AnalyzedResult;
import org.eclipse.actf.model.dom.dombycom.IFlashMSAANode;
import org.eclipse.actf.model.dom.dombycom.IFlashNode;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.INodeExSound;
import org.eclipse.actf.model.dom.dombycom.INodeExVideo;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.ListNodeListImpl;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashMSAANodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashNodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashSoundImpl;
import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashTerms;
import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashVideoImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.ElementImpl;
import org.eclipse.actf.model.flash.FlashPlayerFactory;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashConst;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.util.vocab.AbstractTerms;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IUnknown;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FlashTopNodeImpl
extends ElementImpl
implements IFlashNode,
IFlashConst {
    private static final String CLSID = "CLSID:D27CDB6E-AE6D-11CF-96B8-444553540000";
    private static final String APP_TYPE = "application/x-shockwave-flash";
    private static final IFlashNode[] emptyResult = new IFlashNode[0];
    private FlashMSAANodeImpl cachedMSAA;
    private IFlashPlayer flashPlayer;
    private boolean hasMedia = false;
    private boolean updatedTarget = false;

    static FlashTopNodeImpl newFlashNode(NodeImpl nodeImpl, IDispatch iDispatch) {
        String string = (String)Helper.get((IDispatch)iDispatch, (String)"classid");
        if (CLSID.equalsIgnoreCase(string)) {
            return new FlashTopNodeImpl(nodeImpl, iDispatch);
        }
        String string2 = (String)Helper.get((IDispatch)((IDispatch)iDispatch.invoke1("getAttributeNode", (Object)"type")), (String)"value");
        if (APP_TYPE.equalsIgnoreCase(string2)) {
            return new FlashTopNodeImpl(nodeImpl, iDispatch);
        }
        return null;
    }

    private FlashTopNodeImpl(NodeImpl nodeImpl, IDispatch iDispatch) {
        super(nodeImpl, iDispatch);
        this.flashPlayer = FlashPlayerFactory.getPlayerFromIDsipatch((IDispatch)iDispatch);
    }

    private INodeExVideo[] searchVideo() {
        IASNode[] iASNodeArray = this.flashPlayer.searchVideo();
        int n = iASNodeArray.length;
        INodeExVideo[] iNodeExVideoArray = new INodeExVideo[n];
        int n2 = 0;
        while (n2 < n) {
            iNodeExVideoArray[n2] = new FlashVideoImpl(this, iASNodeArray[n2]);
            ++n2;
        }
        return iNodeExVideoArray;
    }

    private INodeExSound[] searchSound() {
        IASNode[] iASNodeArray = this.flashPlayer.searchSound();
        int n = iASNodeArray.length;
        INodeExSound[] iNodeExSoundArray = new INodeExSound[n];
        int n2 = 0;
        while (n2 < n) {
            iNodeExSoundArray[n2] = new FlashSoundImpl(iASNodeArray[n2]);
            ++n2;
        }
        return iNodeExSoundArray;
    }

    public String getTarget() {
        return "";
    }

    public IFlashNode getNodeFromPath(String string) {
        IASNode iASNode = this.flashPlayer.getNodeFromPath(string);
        if (iASNode == null) {
            return null;
        }
        return new FlashNodeImpl(this, iASNode);
    }

    public IFlashNode getNodeAtDepth(int n) {
        return null;
    }

    public IFlashNode[] getInnerNodes() {
        return emptyResult;
    }

    private IFlashNode[] createIFlashNodeArray(IASNode[] iASNodeArray) {
        IFlashNode[] iFlashNodeArray = new IFlashNode[iASNodeArray.length];
        int n = 0;
        while (n < iASNodeArray.length) {
            iFlashNodeArray[n] = new FlashNodeImpl(this, iASNodeArray[n]);
            ++n;
        }
        return iFlashNodeArray;
    }

    public IFlashNode[] translate() {
        return this.createIFlashNodeArray(this.flashPlayer.translateWithPath("_level0"));
    }

    public int getDepth() {
        return -16384;
    }

    public int getCurrentFrame() {
        return -1;
    }

    public INodeEx getBaseNode() {
        return this;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public NodeList getChildNodes() {
        ArrayList<IFlashNode> arrayList = new ArrayList<IFlashNode>(3);
        int n = 0;
        while (n < 3) {
            String string = "_level" + n;
            IFlashNode iFlashNode = this.getNodeFromPath(string);
            if (iFlashNode != null) {
                arrayList.add(iFlashNode);
            }
            ++n;
        }
        return new ListNodeListImpl(arrayList);
    }

    boolean hasMedia() {
        return this.hasMedia;
    }

    public AnalyzedResult analyze(AnalyzedResult analyzedResult) {
        INodeExVideo[] iNodeExVideoArray = this.searchVideo();
        if (iNodeExVideoArray.length > 0) {
            this.hasMedia = true;
            int n = 0;
            while (n < iNodeExVideoArray.length) {
                analyzedResult.addVideo(iNodeExVideoArray[n]);
                ++n;
            }
        }
        INodeExSound[] iNodeExSoundArray = this.searchSound();
        int n = 0;
        while (n < iNodeExSoundArray.length) {
            analyzedResult.addSound(iNodeExSoundArray[n]);
            ++n;
        }
        analyzedResult.addFlashTopNode((IFlashNode)this);
        return analyzedResult;
    }

    public void repairFlash() {
        this.flashPlayer.repairFlash();
    }

    public IFlashMSAANode getMSAA() {
        if (this.cachedMSAA == null) {
            this.cachedMSAA = FlashMSAANodeImpl.newMSAANode(this, this.inode);
        }
        if (this.cachedMSAA == null || this.cachedMSAA.getWindow() == 0L) {
            return null;
        }
        this.updateTarget();
        return this.cachedMSAA;
    }

    public long getHWND() {
        return FlashMSAANodeImpl.getHWNDFromObject((IUnknown)super.getINode());
    }

    public AbstractTerms getTerms() {
        return FlashTerms.getInstance();
    }

    public void updateTarget() {
        if (this.updatedTarget) {
            return;
        }
        this.updatedTarget = this.flashPlayer.updateTarget();
    }
}

