/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.DebugUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSS;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageImage;

public class PageImageDebugUtil {
    private PageImage pageImage;

    PageImageDebugUtil(PageImage pageImage) {
        this.pageImage = pageImage;
    }

    public void paintOnePageComponent(PageComponent pageComponent, int[][] nArray, int n) {
        int n2 = pageComponent.cc.left;
        int n3 = pageComponent.cc.top;
        int n4 = pageComponent.cc.shape.width;
        int n5 = pageComponent.cc.shape.height;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = 0;
            while (n7 < n4) {
                if (pageComponent.cc.shape.data[n6][n7] != 0) {
                    nArray[n6 + n3][n7 + n2] = n;
                }
                ++n7;
            }
            ++n6;
        }
    }

    public int[][] paintContainers(int[][] nArray, int n) {
        if (this.pageImage.numContainers == 0) {
            DebugUtil.errMsg(this, "There are no containers.");
            return null;
        }
        DebugUtil.debugMsg(null, "# of containers = " + this.pageImage.numContainers, "CONTAINER");
        int n2 = 0;
        while (n2 < this.pageImage.numContainers) {
            Container container = this.pageImage.containers[n2];
            this.paintOnePageComponent(container, nArray, n);
            ++n2;
        }
        return nArray;
    }

    public IInt2D showRepaintedContainerMap() {
        Int2D int2D = new Int2D(this.pageImage.pixel.getWidth(), this.pageImage.pixel.getHeight());
        int n = 0;
        while (n < this.pageImage.pixel.getHeight()) {
            int n2 = 0;
            while (n2 < this.pageImage.pixel.getWidth()) {
                int2D.getData()[n][n2] = ColorUtil.distinguishableColor(this.pageImage.containerMap[n][n2]);
                ++n2;
            }
            ++n;
        }
        return int2D;
    }

    public IInt2D showAllSSCharacters() {
        return this.showAllSSCharacters(0xFF0000);
    }

    public IInt2D showAllSSCharacters(int n) {
        Int2D int2D = new Int2D(this.pageImage.pixel.getWidth(), this.pageImage.pixel.getHeight());
        int n2 = 0;
        while (n2 < this.pageImage.containerVector.size()) {
            int2D = this.showSSCharactersInOneContainer(int2D, n2, n);
            ++n2;
        }
        return int2D;
    }

    public Int2D showSSCharactersInOneContainer(Int2D int2D, int n, int n2) {
        Container container = this.pageImage.containerVector.elementAt(n);
        int n3 = 0;
        while (n3 < container.ssCharacterVector.size()) {
            CharacterSS characterSS = container.ssCharacterVector.elementAt(n3);
            ConnectedComponent connectedComponent = characterSS.cc;
            int n4 = 0;
            while (n4 < connectedComponent.shape.height) {
                int n5 = 0;
                while (n5 < connectedComponent.shape.width) {
                    if (connectedComponent.shape.data[n4][n5] != 0) {
                        int2D.getData()[n4 + connectedComponent.top][n5 + connectedComponent.left] = n2;
                    }
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        return int2D;
    }

    public IInt2D showAllCharacters() {
        return this.showAllCharacters(0xFF0000, 65280, 255, 0xFFFF00);
    }

    public IInt2D showAllCharacters(int n, int n2, int n3, int n4) {
        Int2D int2D = new Int2D(this.pageImage.pixel.getWidth(), this.pageImage.pixel.getHeight());
        DebugUtil.debugMsg(this, "numContainers = " + this.pageImage.numContainers, "CONTAINER");
        int n5 = 0;
        while (n5 < this.pageImage.numContainers) {
            Container container = this.pageImage.containers[n5];
            int2D = this.showCharactersInOneContainer(int2D, container, n, n2, n3);
            ++n5;
        }
        n5 = 0;
        while (n5 < this.pageImage.numNonContainedCharacters) {
            int2D = this.pageImage.nonContainedCharacters[n5].cc.drawShape(int2D, n4);
            ++n5;
        }
        return int2D;
    }

    public Int2D showCharactersInOneContainer(Int2D int2D, Container container, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < container.numSSCharacters) {
            int2D = container.ssCharacters[n4].cc.drawShape(int2D, n);
            ++n4;
        }
        n4 = 0;
        while (n4 < container.numMSCharacters) {
            int2D = container.msCharacters[n4].cc.drawShape(int2D, n2);
            ++n4;
        }
        n4 = 0;
        while (n4 < container.numSMCharacters) {
            int2D = container.smCharacters[n4].cc.drawShape(int2D, n3);
            ++n4;
        }
        return int2D;
    }

    public IInt2D showAllThinedCharacters() throws ImageException {
        return this.showAllThinedCharacters(0xFF0000, 65280, 255, 0xFFFF00);
    }

    public IInt2D showAllThinedCharacters(int n, int n2, int n3, int n4) throws ImageException {
        Int2D int2D = new Int2D(this.pageImage.pixel.getWidth(), this.pageImage.pixel.getHeight());
        DebugUtil.debugMsg(this, "numContainers = " + this.pageImage.numContainers, "CONTAINER");
        int n5 = 0;
        while (n5 < this.pageImage.numContainers) {
            Container container = this.pageImage.containers[n5];
            int2D = this.showThinedCharactersInOneContainer(int2D, container, n, n2, n3);
            ++n5;
        }
        n5 = 0;
        while (n5 < this.pageImage.numNonContainedCharacters) {
            int2D = this.pageImage.nonContainedCharacters[n5].cc.thinning().drawShape(int2D, n4);
            ++n5;
        }
        return int2D;
    }

    public Int2D showThinedCharactersInOneContainer(Int2D int2D, Container container, int n, int n2, int n3) throws ImageException {
        int n4 = 0;
        while (n4 < container.numSSCharacters) {
            int2D = container.ssCharacters[n4].cc.thinning().drawShape(int2D, n);
            ++n4;
        }
        n4 = 0;
        while (n4 < container.numMSCharacters) {
            int2D = container.msCharacters[n4].cc.thinning().drawShape(int2D, n2);
            ++n4;
        }
        n4 = 0;
        while (n4 < container.numSMCharacters) {
            int2D = container.smCharacters[n4].cc.thinning().drawShape(int2D, n3);
            ++n4;
        }
        return int2D;
    }
}

