/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.util.html2view;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.util.JapaneseEncodingDetector;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Html2ViewMapMaker {
    Vector<Html2ViewMapData> html2viewV;
    int id;
    int line;
    int column;
    int startLine;
    int startColumn;
    boolean changeBase;
    boolean insertBaseNow;
    String baseUrl;
    boolean inXmlDef;
    boolean inDoctype;
    boolean inSingle;
    boolean inDouble;
    boolean inTag;
    boolean inEndTag;
    boolean inComment;
    boolean inScript;
    boolean inScriptComment;
    boolean inNoscript;
    boolean inTitle;
    boolean inHeader;
    StringBuffer resultSB;
    StringBuffer toFindHtmlSB;
    StringBuffer scriptSB;
    String currentTargetString;

    private Html2ViewMapMaker() {
    }

    public static Vector<Html2ViewMapData> makeMap(String string, String string2, String string3) {
        Html2ViewMapMaker html2ViewMapMaker = new Html2ViewMapMaker();
        html2ViewMapMaker.changeBase = false;
        return html2ViewMapMaker.makeMapLocal(string, string2, string3, true);
    }

    private void init() {
        this.inXmlDef = false;
        this.inDoctype = false;
        this.inSingle = false;
        this.inDouble = false;
        this.inTag = false;
        this.inEndTag = false;
        this.inComment = false;
        this.inScript = false;
        this.inScriptComment = false;
        this.insertBaseNow = false;
        this.id = 0;
        this.line = 0;
        this.column = 0;
        this.startLine = 0;
        this.startColumn = 0;
        this.html2viewV = new Vector();
        this.resultSB = new StringBuffer();
    }

    private Vector<Html2ViewMapData> makeMapLocal(String string, String string2, String string3, boolean bl) {
        Closeable closeable;
        JapaneseEncodingDetector japaneseEncodingDetector;
        String string4;
        BufferedReader bufferedReader;
        String string5;
        FileInputStream fileInputStream;
        PrintWriter printWriter;
        block35: {
            printWriter = null;
            fileInputStream = null;
            string5 = "";
            if (bl) {
                string5 = string3;
            }
            this.init();
            bufferedReader = null;
            string4 = "MS932";
            File file = new File(String.valueOf(string5) + string);
            if (file.isFile() && file.canRead()) {
                try {
                    try {
                        fileInputStream = new FileInputStream(file);
                        japaneseEncodingDetector = new JapaneseEncodingDetector((InputStream)fileInputStream);
                        string4 = japaneseEncodingDetector.detect();
                        break block35;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Vector<Html2ViewMapData> vector = this.html2viewV;
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        return vector;
                    }
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
            return this.html2viewV;
        }
        try {
            closeable = new FileOutputStream(new File(String.valueOf(string5) + string2));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)closeable, string4));
            printWriter = new PrintWriter(bufferedWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return new Vector<Html2ViewMapData>();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return new Vector<Html2ViewMapData>();
        }
        try {
            try {
                String string6;
                closeable = new InputStreamReader(japaneseEncodingDetector.getInputStream(), string4);
                bufferedReader = new BufferedReader((Reader)closeable);
                while ((string6 = bufferedReader.readLine()) != null) {
                    this.doSourceLine(string6);
                    ++this.line;
                    this.column = 0;
                }
            }
            catch (Exception exception) {
                try {
                    String string7;
                    fileInputStream.close();
                    this.init();
                    fileInputStream = new FileInputStream(String.valueOf(string5) + string);
                    closeable = new InputStreamReader(fileInputStream);
                    bufferedReader = new BufferedReader((Reader)closeable);
                    while ((string7 = bufferedReader.readLine()) != null) {
                        this.doSourceLine(string7);
                        ++this.line;
                        this.column = 0;
                    }
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    printWriter.close();
                    Vector<Html2ViewMapData> vector = new Vector<Html2ViewMapData>();
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return vector;
                }
            }
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        printWriter.print(this.resultSB.toString());
        printWriter.flush();
        printWriter.close();
        return this.html2viewV;
    }

    private void doSourceLine(String string) {
        this.currentTargetString = string;
        boolean bl = true;
        while (bl) {
            bl = this.doFilter(this.currentTargetString);
        }
    }

    private boolean doFilter(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("")) {
            this.resultSB.append(FileUtils.LINE_SEP);
            return false;
        }
        if (this.inSingle) {
            this.doValueSingle(string);
        } else if (this.inDouble) {
            this.doValueDouble(string);
        } else if (this.inTag) {
            this.doTag(string);
        } else if (this.inEndTag) {
            this.doEndTag(string);
        } else if (this.inComment) {
            this.doComment(string);
        } else if (this.inDoctype) {
            this.doDoctype(string);
        } else if (this.inScript) {
            if (this.inScriptComment) {
                this.doScriptComment(string);
            } else {
                this.doScript(string);
            }
        } else if (this.inXmlDef) {
            this.doXmlDef(string);
        } else {
            this.doNormal(string);
        }
        return true;
    }

    private void doValueSingle(String string) {
        this.doValue(string, "'");
    }

    private void doValueDouble(String string) {
        this.doValue(string, "\"");
    }

    private void doValue(String string, String string2) {
        int n = string.indexOf(string2);
        int n2 = string.indexOf("<");
        if (n2 > -1 && (n < 0 || n > n2)) {
            int n3 = n;
            if (n < 0) {
                n3 = Integer.MAX_VALUE;
            }
            String string3 = "";
            try {
                string3 = string.substring(n2 + 1);
            }
            catch (Exception exception) {}
            int n4 = this.line + 1;
            while (n2 > -1 && n2 < n3 && !string3.matches("\\p{Alpha}.*")) {
                if ((n2 = string.indexOf("<", n2 + 1)) <= -1) continue;
                string3 = "";
                try {
                    string3 = string.substring(n2 + 1);
                }
                catch (Exception exception) {}
            }
            if (n2 > -1 && n2 < n3) {
                System.out.print("HTMLVMM: start tag in attribute value : line: " + n4 + " : " + string + " : ");
                int n5 = string.indexOf(">");
                if (n5 > -1 && n5 < n2) {
                    string = String.valueOf(string.substring(0, n5)) + string2 + string.substring(n5);
                    n = string.indexOf(string2);
                    System.out.println("with end tag");
                } else {
                    string = String.valueOf(string.substring(0, n2)) + string2 + ">" + string.substring(n2);
                    n = string.indexOf(string2);
                    System.out.println("without end tag");
                }
            }
        }
        if (n > -1) {
            this.inSingle = false;
            this.inDouble = false;
            if (this.changeBase) {
                this.toFindHtmlSB.append(string.substring(0, n));
            }
            this.doNext(string, n);
        } else {
            if (this.changeBase) {
                this.toFindHtmlSB.append(string);
            }
            this.doNext(string, n);
        }
    }

    private boolean checkIndex(int n, int n2) {
        if (n2 > -1) {
            return n <= -1 || n >= n2;
        }
        return false;
    }

    private boolean isUnexpectedStartTag(int n, int n2, int n3, int n4) {
        if (n4 > -1) {
            return !(n3 >= 0 && n3 <= n4 || n >= 0 && n <= n4 || n2 >= 0 && n2 <= n4);
        }
        return false;
    }

    private int getAttributeIndex(String string, boolean bl, int n) {
        String string2 = "'";
        if (bl) {
            string2 = "\"";
        }
        int n2 = n;
        if (n < 0) {
            n2 = Integer.MAX_VALUE;
        }
        int n3 = string.indexOf(string2);
        while (n3 > -1 && n3 < n2) {
            String string3 = string.substring(0, n3);
            if (string3.matches(".*=\\p{Space}*")) {
                return n3;
            }
            n3 = string.indexOf(string2, n3 + 1);
        }
        return n3;
    }

    private void doTag(String string) {
        int n;
        int n2 = string.indexOf(">");
        int n3 = this.getAttributeIndex(string, false, n2);
        int n4 = this.getAttributeIndex(string, true, n2);
        boolean bl2 = this.checkIndex(n2, n3);
        boolean bl3 = this.checkIndex(n2, n4);
        if (bl2 && bl3) {
            if (n4 < n3) {
                bl2 = false;
            } else {
                bl3 = false;
            }
        }
        if (this.isUnexpectedStartTag(n3, n4, n2, n = string.indexOf("<"))) {
            int bl = this.line + 1;
            System.out.println("HTMLVMM: unexpected start tag: line:" + bl + " : " + string);
            string = String.valueOf(string.substring(0, n)) + ">" + string.substring(n);
            bl2 = false;
            bl3 = false;
            n2 = string.indexOf(">");
        }
        if (bl2) {
            this.inSingle = true;
            if (this.changeBase) {
                this.toFindHtmlSB.append(string.substring(0, n3));
            }
            this.doNext(string, n3);
        } else if (bl3) {
            this.inDouble = true;
            if (this.changeBase) {
                this.toFindHtmlSB.append(string.substring(0, n4));
            }
            this.doNext(string, n4);
        } else {
            boolean bl = false;
            if (n2 > -1) {
                Object object;
                boolean bl4;
                this.inTag = false;
                int n5 = string.indexOf("/>");
                if (n5 > -1 && n5 == n2 - 1) {
                    bl4 = true;
                }
                if (this.changeBase) {
                    object = String.valueOf(this.toFindHtmlSB.toString()) + string.substring(0, n2);
                    if (((String)(object = ((String)object).toLowerCase())).startsWith("html")) {
                        this.changeBase = false;
                        this.insertBaseNow = true;
                    }
                }
                object = new Html2ViewMapData(new int[]{this.startLine, this.startColumn}, new int[]{this.line, this.column + n2 + 1});
                this.html2viewV.add((Html2ViewMapData)object);
                this.doNext(string, n2, true, bl4);
            } else {
                if (this.changeBase) {
                    this.toFindHtmlSB.append(string);
                }
                this.doNext(string, n2);
            }
        }
    }

    private void doEndTag(String string) {
        int n = string.indexOf(">");
        if (n > -1) {
            this.inEndTag = false;
        }
        this.doNext(string, n);
    }

    private void doComment(String string) {
        int n = string.indexOf("-->");
        if (n > -1) {
            this.inComment = false;
        }
        this.doNext(string, n);
    }

    private void doScript(String string) {
        int n = string.toLowerCase().indexOf("<!--");
        int n2 = string.toLowerCase().indexOf("</script>");
        this.inScriptComment = this.checkIndex(n2, n);
        if (this.inScriptComment) {
            this.scriptSB.append(string.substring(0, n + 1));
            this.doNext(string, n);
            return;
        }
        if (n2 > -1) {
            this.scriptSB.append(string.substring(0, n2 + 8));
            String string2 = this.scriptSB.toString();
            String string3 = string2.toLowerCase();
            if (this.changeBase && string3.indexOf(".createstylesheet") > -1) {
                this.resultSB.insert(this.resultSB.indexOf("<HEAD><BASE") + 6, String.valueOf(string2) + ">");
                this.resultSB.append("<!-- acc_memo script move to top--");
            } else {
                this.resultSB.append(string2);
            }
            string = string.substring(n2 + 8);
            n2 = 0;
            this.inScript = false;
        } else {
            this.scriptSB.append(String.valueOf(string) + FileUtils.LINE_SEP);
        }
        this.doNext(string, n2);
    }

    private void doScriptComment(String string) {
        int n = string.indexOf("-->");
        if (n > -1) {
            this.scriptSB.append(string.substring(0, n + 1));
            this.inScriptComment = false;
        } else {
            this.scriptSB.append(String.valueOf(string) + FileUtils.LINE_SEP);
        }
        this.doNext(string, n);
    }

    private void doDoctype(String string) {
        int n = string.indexOf(">");
        if (n > -1) {
            this.inDoctype = false;
        }
        this.doNext(string, n);
    }

    private void doXmlDef(String string) {
        int n = string.indexOf(">");
        if (n > -1) {
            this.inXmlDef = false;
        }
        this.doNext(string, n);
    }

    private void doNormal(String string) {
        int n = string.indexOf("<");
        if (n > -1) {
            this.startLine = this.line;
            this.startColumn = this.column + n;
            String string2 = string.toLowerCase();
            int n2 = string2.indexOf("</");
            int n3 = string2.indexOf("<!--");
            int n4 = string2.indexOf("<!doctype");
            int n5 = string2.indexOf("<script");
            int n6 = string2.indexOf("<?xml");
            if (n == n2) {
                this.inEndTag = true;
            } else if (n == n3) {
                this.inComment = true;
            } else if (n == n4) {
                this.inDoctype = true;
            } else if (n == n5) {
                this.inScript = true;
                this.scriptSB = new StringBuffer("<");
                this.resultSB.append(string.substring(0, n));
            } else if (n == n6) {
                this.inXmlDef = true;
            } else {
                if (this.changeBase) {
                    this.toFindHtmlSB = new StringBuffer();
                }
                this.inTag = true;
            }
        }
        this.doNext(string, n);
    }

    private void doNext(String string, int n) {
        this.doNext(string, n, false, false);
    }

    private void doNext(String string, int n, boolean bl, boolean bl2) {
        if (n > -1) {
            int n2 = n + 1;
            this.column += n2;
            if (bl) {
                if (bl2) {
                    this.resultSB.append(String.valueOf(string.substring(0, n - 1)) + " " + "eclipse-actf-id" + "='" + this.id + "'/>");
                } else {
                    this.resultSB.append(String.valueOf(string.substring(0, n)) + " " + "eclipse-actf-id" + "='" + this.id + "'>");
                }
                ++this.id;
            } else if (!this.inScript) {
                this.resultSB.append(string.substring(0, n2));
            }
            if (this.insertBaseNow) {
                this.resultSB.append("<HEAD><BASE href=\"" + this.baseUrl + "\"></HEAD>");
                this.insertBaseNow = false;
            }
            this.currentTargetString = string.substring(n2);
        } else {
            if (!this.inScript) {
                this.resultSB.append(String.valueOf(string) + FileUtils.LINE_SEP);
            }
            this.currentTargetString = null;
        }
    }
}

