/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEdgeColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnTotalColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GrandTotalColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;
import org.eclipse.birt.report.item.crosstab.core.re.executor.IColumnWalker;
import org.eclipse.birt.report.item.crosstab.core.re.executor.MeasureColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.MeasureHeaderColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.RowEdgeColumnEvent;

class ColumnWalker
implements ICrosstabConstants,
IColumnWalker {
    private static final int STATE_INIT = 0;
    private static final int STATE_ROW_EDGE = 1;
    private static final int STATE_MEASURE_HEADER = 2;
    private static final int STATE_COLUMN_TOTAL_BEFORE = 3;
    private static final int STATE_COLUMN_TOTAL_AFTER = 4;
    private static final int STATE_COLUMN_EDGE = 5;
    private static final int STATE_GRAND_TOTAL = 6;
    private static final int STATE_MEASURE = 7;
    private static final int STATE_END = 10;
    private static final int STATE_PENDING_CHECK_COLUMN_EDGE = 20;
    private CrosstabReportItemHandle crosstabItem;
    private EdgeCursor columnEdgeCursor;
    private final List rowGroups;
    private final List columnGroups;
    private final int mCount;
    private final boolean isVerticalMeasure;
    private final boolean isHideMeasureHeader;
    private int currentState;
    private int dimensionIndex;
    private int levelIndex;
    private int measureIndex;
    private int groupIndex;
    private int tmpStartGroupIndex;
    private int tmpEndGroupIndex;
    private List columnDimensionCursors;
    private boolean hasNext;
    private boolean columnProcessed;
    private boolean inProcessingGrandTotalBefore;
    private final int lastColumnGroupIndex;

    ColumnWalker(CrosstabReportItemHandle item, EdgeCursor columnEdgeCursor) {
        this.crosstabItem = item;
        this.columnEdgeCursor = columnEdgeCursor;
        this.rowGroups = GroupUtil.getGroups(this.crosstabItem, 0);
        this.columnGroups = GroupUtil.getGroups(this.crosstabItem, 1);
        this.mCount = this.crosstabItem.getMeasureCount();
        this.isVerticalMeasure = "vertical".equals(this.crosstabItem.getMeasureDirection());
        this.isHideMeasureHeader = this.crosstabItem.isHideMeasureHeader();
        this.groupIndex = 0;
        this.measureIndex = -1;
        this.lastColumnGroupIndex = this.columnGroups.size() - 1;
        this.currentState = 0;
    }

    @Override
    public void reload() {
        this.groupIndex = 0;
        this.measureIndex = -1;
        this.currentState = 0;
    }

    @Override
    public boolean hasNext() throws OLAPException {
        if (this.currentState == 0) {
            this.safeAdvance();
        }
        return this.currentState != 10;
    }

    private void safeAdvance() throws OLAPException {
        this.advance();
        if (this.currentState == 20) {
            this.advance();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void advance() throws OLAPException {
        switch (this.currentState) {
            case 0: 
            case 1: {
                if (this.rowGroups.size() > 0 && (i = this.groupIndex++) < this.rowGroups.size()) {
                    group = (EdgeGroup)this.rowGroups.get(i);
                    this.dimensionIndex = group.dimensionIndex;
                    this.levelIndex = group.levelIndex;
                    this.currentState = 1;
                    return;
                }
                if (this.mCount <= 0 || !this.isVerticalMeasure || this.isHideMeasureHeader) ** GOTO lbl19
                i = 0;
                while (i < this.mCount) {
                    mv = this.crosstabItem.getMeasure(i);
                    if (mv.getHeader() != null) {
                        this.currentState = 2;
                        return;
                    }
                    ++i;
                }
                ** GOTO lbl35
lbl19:
                // 1 sources

                if (this.rowGroups.size() == 0 && this.groupIndex == 0 && this.crosstabItem.getHeader() != null) {
                    ++this.groupIndex;
                    hasHeaderContent = false;
                    i = 0;
                    while (i < this.crosstabItem.getHeaderCount()) {
                        cell = this.crosstabItem.getHeader(i);
                        if (cell.getContents().size() > 0) {
                            hasHeaderContent = true;
                            break;
                        }
                        ++i;
                    }
                    if (hasHeaderContent) {
                        this.dimensionIndex = -1;
                        this.levelIndex = -1;
                        this.currentState = 1;
                        return;
                    }
                }
            }
lbl35:
            // 6 sources

            case 2: {
                this.inProcessingGrandTotalBefore = this.columnGroups.size() > 0 && this.columnEdgeCursor != null && this.crosstabItem.getGrandTotal(1) != null && "before".equals(this.crosstabItem.getCrosstabView(1).getGrandTotalLocation()) != false;
            }
            case 20: {
                if (!this.inProcessingGrandTotalBefore && this.columnGroups.size() > 0 && this.columnEdgeCursor != null) {
                    this.columnDimensionCursors = this.columnEdgeCursor.getDimensionCursor();
                    this.columnEdgeCursor.beforeFirst();
                    this.hasNext = this.columnEdgeCursor.next();
                    this.columnProcessed = false;
                    this.groupIndex = 0;
                    this.measureIndex = -1;
                    this.tmpStartGroupIndex = 0;
                    this.tmpEndGroupIndex = this.lastColumnGroupIndex;
                }
            }
            case 3: 
            case 4: 
            case 5: {
                if (!this.inProcessingGrandTotalBefore && this.columnGroups.size() > 0 && this.columnEdgeCursor != null) {
                    while (this.hasNext) {
                        if (this.mCount > 0) {
                            i = this.tmpStartGroupIndex;
                            while (i < this.columnGroups.size()) {
                                group = (EdgeGroup)this.columnGroups.get(i);
                                if (!GroupUtil.isLeafOrDummyGroup(this.columnDimensionCursors, i) && (dc = (DimensionCursor)this.columnDimensionCursors.get(i)).getEdgeStart() == this.columnEdgeCursor.getPosition() && (lv = this.crosstabItem.getDimension(1, group.dimensionIndex).getLevel(group.levelIndex)).getAggregationHeader() != null && "before".equals(lv.getAggregationHeaderLocation())) {
                                    if (this.mCount > 0 && !this.isVerticalMeasure) {
                                        m = this.measureIndex + 1;
                                        while (m < this.mCount) {
                                            if (GroupUtil.hasTotalContent(this.crosstabItem, 1, group.dimensionIndex, group.levelIndex, m)) {
                                                this.tmpStartGroupIndex = i;
                                                this.dimensionIndex = group.dimensionIndex;
                                                this.levelIndex = group.levelIndex;
                                                this.measureIndex = m;
                                                this.currentState = 3;
                                                return;
                                            }
                                            ++m;
                                        }
                                        this.measureIndex = -1;
                                    } else if (GroupUtil.hasTotalContent(this.crosstabItem, 1, group.dimensionIndex, group.levelIndex, -1)) {
                                        this.tmpStartGroupIndex = i + 1;
                                        this.dimensionIndex = group.dimensionIndex;
                                        this.levelIndex = group.levelIndex;
                                        this.currentState = 3;
                                        return;
                                    }
                                }
                                ++i;
                            }
                            this.tmpStartGroupIndex = this.columnGroups.size();
                        }
                        if (this.currentState != 5 && this.currentState != 4) {
                            this.measureIndex = -1;
                        }
                        if (!this.columnProcessed) {
                            if (this.mCount > 0 && !this.isVerticalMeasure) {
                                m = this.measureIndex + 1;
                                if (m < this.mCount) {
                                    this.measureIndex = m;
                                    this.currentState = 5;
                                    return;
                                }
                            } else if (this.measureIndex == -1) {
                                --this.measureIndex;
                                this.currentState = 5;
                                return;
                            }
                            this.columnProcessed = true;
                        }
                        if (this.mCount > 0) {
                            if (this.currentState != 4) {
                                this.measureIndex = -1;
                            }
                            i = this.tmpEndGroupIndex;
                            while (i >= 0) {
                                group = (EdgeGroup)this.columnGroups.get(i);
                                if (!GroupUtil.isLeafOrDummyGroup(this.columnDimensionCursors, i) && (dc = (DimensionCursor)this.columnDimensionCursors.get(i)).getEdgeEnd() == this.columnEdgeCursor.getPosition() && (lv = this.crosstabItem.getDimension(1, group.dimensionIndex).getLevel(group.levelIndex)).getAggregationHeader() != null && "after".equals(lv.getAggregationHeaderLocation())) {
                                    if (this.mCount > 0 && !this.isVerticalMeasure) {
                                        m = this.measureIndex + 1;
                                        while (m < this.mCount) {
                                            if (GroupUtil.hasTotalContent(this.crosstabItem, 1, group.dimensionIndex, group.levelIndex, m)) {
                                                this.tmpEndGroupIndex = i;
                                                this.dimensionIndex = group.dimensionIndex;
                                                this.levelIndex = group.levelIndex;
                                                this.measureIndex = m;
                                                this.currentState = 4;
                                                return;
                                            }
                                            ++m;
                                        }
                                        this.measureIndex = -1;
                                    } else if (GroupUtil.hasTotalContent(this.crosstabItem, 1, group.dimensionIndex, group.levelIndex, -1)) {
                                        this.tmpEndGroupIndex = i - 1;
                                        this.dimensionIndex = group.dimensionIndex;
                                        this.levelIndex = group.levelIndex;
                                        this.currentState = 4;
                                        return;
                                    }
                                }
                                --i;
                            }
                        }
                        this.hasNext = this.columnEdgeCursor.next();
                        this.columnProcessed = false;
                        this.tmpStartGroupIndex = 0;
                        this.tmpEndGroupIndex = this.lastColumnGroupIndex;
                        this.measureIndex = -1;
                    }
                    if (this.crosstabItem.getGrandTotal(1) != null && "before".equals(this.crosstabItem.getCrosstabView(1).getGrandTotalLocation())) {
                        this.currentState = 10;
                        return;
                    }
                }
                this.measureIndex = -1;
            }
            case 6: {
                if (this.columnGroups.size() > 0 && this.columnEdgeCursor != null) {
                    if (this.crosstabItem.getGrandTotal(1) != null) {
                        if (this.mCount > 0) {
                            if (this.mCount > 0 && !this.isVerticalMeasure) {
                                i = this.measureIndex + 1;
                                while (i < this.mCount) {
                                    if (GroupUtil.hasTotalContent(this.crosstabItem, 1, -1, -1, i)) {
                                        this.measureIndex = i;
                                        this.currentState = 6;
                                        return;
                                    }
                                    ++i;
                                }
                            } else if (this.currentState != 6 && GroupUtil.hasTotalContent(this.crosstabItem, 1, -1, -1, -1)) {
                                this.currentState = 6;
                                return;
                            }
                        }
                        if (this.inProcessingGrandTotalBefore) {
                            this.inProcessingGrandTotalBefore = false;
                            this.currentState = 20;
                            return;
                        }
                    }
                    this.currentState = 10;
                    return;
                }
            }
            case 7: {
                if (!this.isVerticalMeasure) {
                    i = this.measureIndex + 1;
                    if (i < this.mCount) {
                        this.measureIndex = i;
                        this.currentState = 7;
                        return;
                    }
                } else if (this.measureIndex == -1 && this.mCount > 0) {
                    --this.measureIndex;
                    this.currentState = 7;
                    return;
                }
                this.currentState = 10;
                return;
            }
        }
    }

    @Override
    public ColumnEvent next() throws OLAPException {
        ColumnEvent evt = null;
        int mx = this.measureIndex < 0 ? -1 : this.measureIndex;
        switch (this.currentState) {
            case 0: {
                break;
            }
            case 1: {
                evt = new RowEdgeColumnEvent(this.dimensionIndex, this.levelIndex);
                break;
            }
            case 2: {
                evt = new MeasureHeaderColumnEvent();
                break;
            }
            case 3: {
                evt = new ColumnTotalColumnEvent(true, this.dimensionIndex, this.levelIndex, mx);
                break;
            }
            case 4: {
                evt = new ColumnTotalColumnEvent(false, this.dimensionIndex, this.levelIndex, mx);
                break;
            }
            case 5: {
                evt = new ColumnEdgeColumnEvent(mx);
                break;
            }
            case 6: {
                evt = new GrandTotalColumnEvent(mx);
                break;
            }
            case 7: {
                evt = new MeasureColumnEvent(mx);
                break;
            }
        }
        if (this.columnEdgeCursor != null) {
            evt.dataPosition = this.columnEdgeCursor.getPosition();
        }
        this.safeAdvance();
        return evt;
    }
}

