/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts.policies;

import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.policies.BPELSelectionEditPolicy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;

public class ContainerHighlightEditPolicy
extends BPELSelectionEditPolicy {
    private Color revertColor = null;
    private boolean revertOpaque;
    private Color highlightColor = null;

    public ContainerHighlightEditPolicy(boolean resizable, boolean movable) {
        super(resizable, movable);
    }

    public void eraseTargetFeedback(Request request) {
        if (this.revertColor != null) {
            this.setContainerBackground(this.revertColor);
            this.getContainerFigure().setOpaque(this.revertOpaque);
            this.revertColor = null;
        }
    }

    public void activate() {
        super.activate();
        if (this.highlightColor == null) {
            BPELUIPlugin plugin = BPELUIPlugin.INSTANCE;
            ColorRegistry colorRegistry = plugin.getColorRegistry();
            this.highlightColor = colorRegistry.get("gradientTo");
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.highlightColor != null) {
            this.highlightColor = null;
        }
        if (this.revertColor != null) {
            this.setContainerBackground(this.revertColor);
            this.getContainerFigure().setOpaque(this.revertOpaque);
            this.revertColor = null;
        }
    }

    private Color getContainerBackground() {
        return this.getContainerFigure().getBackgroundColor();
    }

    private IFigure getContainerFigure() {
        return ((GraphicalEditPart)this.getHost()).getContentPane();
    }

    public EditPart getTargetEditPart(Request request) {
        return request.getType().equals("selection hover") ? this.getHost() : null;
    }

    private void setContainerBackground(Color c) {
        this.getContainerFigure().setBackgroundColor(c);
    }

    protected void showHighlight() {
        if (this.revertColor == null) {
            this.revertOpaque = this.getContainerFigure().isOpaque();
            this.revertColor = this.getContainerBackground();
            this.setContainerBackground(this.highlightColor);
            this.getContainerFigure().setOpaque(true);
        }
    }

    public void showTargetFeedback(Request request) {
        super.showTargetFeedback(request);
        if ((request.getType().equals("move") || request.getType().equals("add children") || request.getType().equals("create child")) && ((BPELEditPart)this.getHost()).canExecuteRequest(request)) {
            this.showHighlight();
        }
    }
}

