/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.core.internal.application;

import org.eclipse.cft.server.core.internal.CFConsoleHandler;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.standalone.core.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IModule;

public class DeploymentErrorHandler {
    private CFConsoleHandler consoleHandler;
    private CloudFoundryApplicationModule appModule;
    private IModule actualModule;
    private CloudFoundryServer cloudServer;

    public DeploymentErrorHandler(IModule actualModule, CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, CFConsoleHandler consoleHandler) {
        this.actualModule = actualModule;
        this.appModule = appModule;
        this.cloudServer = cloudServer;
        this.consoleHandler = consoleHandler;
    }

    public void handleApplicationDeploymentFailure(String errorMessage) throws CoreException {
        if (errorMessage == null) {
            errorMessage = Messages.DeploymentErrorHandler_ERROR_CREATE_PACKAGED_FILE;
        }
        errorMessage = String.valueOf(errorMessage) + " - " + this.appModule.getDeployedApplicationName() + ". Unable to package application for deployment.";
        if (this.consoleHandler != null) {
            this.consoleHandler.printErrorToConsole(this.actualModule, this.cloudServer, errorMessage);
        }
        throw CloudErrorUtil.toCoreException((String)errorMessage);
    }

    public void handleApplicationDeploymentFailure() throws CoreException {
        this.handleApplicationDeploymentFailure(null);
    }
}

