/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorActionBarContributor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorHandler;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorPageDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.ILogger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;

public class EditorDescriptor
implements IEditorDescriptor {
    private IConfigurationElement _configElement;
    private ISchemaObjectEditorActionBarContributor _contributor;
    private IConfigurationElement _contributorElement;
    private Map _defaultPagesOrder;
    private String _editorId;
    private String _editorName;
    private ISchemaObjectEditorHandler _handler;
    private Image _icon;
    private boolean _isVisibilityConfigurable;
    private ILogger _logger = SOEUIPlugin.getLogger(null);
    private IEditorPageDescriptor _mandatoryFirstPage;
    private IEditorPageDescriptor _mandatoryLastPage;
    private String _objectType;
    private IEditorPageDescriptor[] _pages;
    private IPreferenceStore _store;
    private String _vendorName;
    private String _version;
    private String _objTypeName;
    private String _pluginId;

    public EditorDescriptor(String id, String name, String dbName, String dbVersion, String type, Image icon, boolean genPreference) {
        this(id, name, dbName, dbVersion, type, icon, genPreference, null, null, null, null, null);
    }

    public EditorDescriptor(String id, String name, String dbName, String dbVersion, String type, Image icon, boolean genPreference, IEditorPageDescriptor[] _pages, ISchemaObjectEditorHandler configuration, ISchemaObjectEditorActionBarContributor contributor, IConfigurationElement configElement, IConfigurationElement contributorElement) {
        this._defaultPagesOrder = new HashMap();
        this._editorId = id;
        this._editorName = name;
        this._vendorName = dbName;
        this._version = dbVersion;
        this._objectType = type;
        this._icon = icon;
        this._isVisibilityConfigurable = genPreference;
        this._pages = _pages;
        this._handler = configuration;
        this._contributor = contributor;
        this._configElement = configElement;
        this._contributorElement = contributorElement;
        this._store = SOEUIPlugin.getDefault().getPreferenceStore();
    }

    public ISchemaObjectEditorActionBarContributor getActionContributor() {
        try {
            if (this._contributor == null) {
                this._contributor = (ISchemaObjectEditorActionBarContributor)this._contributorElement.createExecutableExtension("ContributorClass");
            }
        }
        catch (Exception exception) {}
        return this._contributor;
    }

    public Map getDefaultPagesOrder() {
        return this._defaultPagesOrder;
    }

    public IEditorPageDescriptor[] getDefaultSortedPages() {
        ArrayList<IEditorPageDescriptor> sortedPages = new ArrayList<IEditorPageDescriptor>();
        HashMap orders = (HashMap)this.getDefaultPagesOrder();
        HashMap clonedOrder = (HashMap)orders.clone();
        IEditorPageDescriptor ePage = this.getNextPage(clonedOrder);
        while (ePage != null) {
            sortedPages.add(ePage);
            ePage = this.getNextPage(clonedOrder);
        }
        int i = 0;
        while (i < this._pages.length) {
            if (!this.getDefaultPagesOrder().keySet().contains(this._pages[i])) {
                sortedPages.add(this._pages[i]);
            }
            ++i;
        }
        return sortedPages.toArray(new IEditorPageDescriptor[sortedPages.size()]);
    }

    public String getEditorId() {
        return this._editorId;
    }

    public String getEditorName() {
        return this._editorName;
    }

    public ISchemaObjectEditorHandler getHandler() {
        ISchemaObjectEditorHandler config = this._handler;
        try {
            this._handler = (ISchemaObjectEditorHandler)this._configElement.createExecutableExtension("Handler");
        }
        catch (Exception e) {
            this._logger.error("ExtendedEditor_error_create_handler", (Throwable)e);
        }
        return config;
    }

    public Image getIcon() {
        return this._icon;
    }

    public IEditorPageDescriptor getMandatoryFirstPage() {
        return this._mandatoryFirstPage;
    }

    public IEditorPageDescriptor getMandatoryLastPage() {
        return this._mandatoryLastPage;
    }

    private IEditorPageDescriptor getNextPage(Map orders) {
        if (orders != null && orders.size() > 0) {
            int number;
            IEditorPageDescriptor page = null;
            IEditorPageDescriptor firstPage = null;
            int minNumber = -1;
            Iterator iter = orders.keySet().iterator();
            if (iter.hasNext() && (number = ((Integer)orders.get(firstPage = (IEditorPageDescriptor)iter.next())).intValue()) > 0) {
                minNumber = number;
                page = firstPage;
            }
            while (iter.hasNext()) {
                IEditorPageDescriptor tmp = (IEditorPageDescriptor)iter.next();
                int number2 = (Integer)orders.get(tmp);
                if (number2 <= 0 || number2 >= minNumber && minNumber != -1) continue;
                minNumber = number2;
                page = tmp;
            }
            if (page == null) {
                orders.remove(firstPage);
                return firstPage;
            }
            orders.remove(page);
            return page;
        }
        return null;
    }

    public IEditorPageDescriptor[] getPageDescriptors() {
        return this._pages;
    }

    public String getSchemaObjectType() {
        return this._objectType;
    }

    public IEditorPageDescriptor[] getSortedPages() {
        IEditorPageDescriptor[] pages = this.getPageDescriptors();
        ArrayList<IEditorPageDescriptor> sortedPages = new ArrayList<IEditorPageDescriptor>();
        HashMap<IEditorPageDescriptor, Integer> orders = new HashMap<IEditorPageDescriptor, Integer>();
        int i = 0;
        while (i < pages.length) {
            String key = "SchemaObjectEditor.pageOrder" + pages[i].getEditorId() + pages[i].getPageId();
            int orderNum = this._store.getInt(key);
            orders.put(pages[i], new Integer(orderNum));
            ++i;
        }
        IEditorPageDescriptor ePage = this.getNextPage(orders);
        while (ePage != null) {
            sortedPages.add(ePage);
            ePage = this.getNextPage(orders);
        }
        return sortedPages.toArray(new IEditorPageDescriptor[sortedPages.size()]);
    }

    public String getVendorName() {
        return this._vendorName;
    }

    public String getVersion() {
        return this._version;
    }

    public IEditorPageDescriptor[] getVisibleSortedPages() {
        return null;
    }

    public IEditorPageDescriptor[] getVisibleSortedPagesDefault() {
        return null;
    }

    public boolean isVisibilityConfigurable() {
        return this._isVisibilityConfigurable;
    }

    public void setActionContributor(ISchemaObjectEditorActionBarContributor contributor) {
        this._contributor = contributor;
    }

    public void setConfigElement(IConfigurationElement element) {
        this._configElement = element;
    }

    public void setContributorElement(IConfigurationElement element) {
        this._contributorElement = element;
    }

    public void setHandler(ISchemaObjectEditorHandler handler) {
        this._handler = handler;
    }

    public void setMandatoryFirstPage(IEditorPageDescriptor mandatoryFirstPage) {
        this._mandatoryFirstPage = mandatoryFirstPage;
    }

    public void setMandatoryLastPage(IEditorPageDescriptor mandatoryLastPage) {
        this._mandatoryLastPage = mandatoryLastPage;
    }

    public void setPageDescriptors(IEditorPageDescriptor[] pages) {
        this._pages = pages;
    }

    public String getObjectTypeName() {
        return this._objTypeName == null ? "" : this._objTypeName;
    }

    public void setObjectTypeName(String objTypeName) {
        this._objTypeName = objTypeName;
    }

    public String getPluginId() {
        return this._pluginId;
    }

    public void setPluginId(String pluginId) {
        this._pluginId = pluginId;
    }
}

