/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.TagOperation;
import org.eclipse.egit.gitflow.Activator;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.GitFlowOperation;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;

public abstract class AbstractVersionFinishOperation
extends GitFlowOperation {
    protected String versionName;

    public AbstractVersionFinishOperation(GitFlowRepository repository, String versionName) {
        super(repository);
        this.versionName = versionName;
    }

    protected void safeCreateTag(IProgressMonitor monitor, String tagName, String tagMessage) throws CoreException {
        RevCommit head;
        try {
            head = this.repository.findHead();
        }
        catch (WrongGitFlowStateException e) {
            throw new CoreException(Activator.error(e));
        }
        try {
            RevCommit commitForTag = this.repository.findCommitForTag(this.versionName);
            if (commitForTag == null) {
                this.createTag(monitor, head, tagName, tagMessage);
            } else if (!head.equals((AnyObjectId)commitForTag)) {
                throw new CoreException(Activator.error(String.format(CoreText.AbstractVersionFinishOperation_tagNameExists, this.versionName)));
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.error(e));
        }
    }

    protected void createTag(IProgressMonitor monitor, RevCommit head, String name, String message) throws CoreException {
        TagBuilder tag = new TagBuilder();
        tag.setTag(name);
        tag.setTagger(new PersonIdent(this.repository.getRepository()));
        tag.setMessage(message);
        tag.setObjectId((RevObject)head);
        new TagOperation(this.repository.getRepository(), tag, false).execute(monitor);
    }
}

