/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.internal.resources.IResourceState;
import org.eclipse.egit.ui.internal.resources.ResourceState;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;

public class ResourceStateFactory {
    @NonNull
    public static final IResourceState UNKNOWN_STATE = new ResourceState();
    @NonNull
    private static final ResourceStateFactory INSTANCE = new ResourceStateFactory();

    @NonNull
    public static ResourceStateFactory getInstance() {
        return INSTANCE;
    }

    @Nullable
    public IndexDiffData getIndexDiffDataOrNull(@Nullable IResource resource) {
        if (resource == null || resource.getType() == 8 || !ResourceUtil.isSharedWithGit((IResource)resource)) {
            return null;
        }
        Repository repository = ResourceUtil.getRepository((IResource)resource);
        return this.getIndexDiffDataOrNull(repository);
    }

    @Nullable
    public IndexDiffData getIndexDiffDataOrNull(@Nullable File file) {
        if (file == null) {
            return null;
        }
        File absoluteFile = file.getAbsoluteFile();
        Path path = new Path(absoluteFile.getPath());
        Repository repository = ResourceUtil.getRepository((IPath)path);
        return this.getIndexDiffDataOrNull(repository);
    }

    @Nullable
    private IndexDiffData getIndexDiffDataOrNull(@Nullable Repository repository) {
        if (repository == null) {
            return null;
        }
        if (repository.isBare()) {
            return new IndexDiffData();
        }
        IndexDiffCacheEntry diffCacheEntry = Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(repository);
        if (diffCacheEntry == null) {
            return null;
        }
        return diffCacheEntry.getIndexDiff();
    }

    @NonNull
    public IResourceState get(@Nullable IResource resource) {
        IndexDiffData indexDiffData = this.getIndexDiffDataOrNull(resource);
        if (indexDiffData == null || resource == null) {
            return UNKNOWN_STATE;
        }
        return this.get(indexDiffData, resource);
    }

    @NonNull
    public IResourceState get(@Nullable File file) {
        IndexDiffData indexDiffData = this.getIndexDiffDataOrNull(file);
        if (indexDiffData == null || file == null) {
            return UNKNOWN_STATE;
        }
        return this.get(indexDiffData, file);
    }

    @NonNull
    public IResourceState get(@NonNull IndexDiffData indexDiffData, @NonNull IResource resource) {
        IPath path = resource.getLocation();
        if (path != null) {
            return this.get(indexDiffData, new ResourceItem(resource));
        }
        return UNKNOWN_STATE;
    }

    @NonNull
    public IResourceState get(@NonNull IndexDiffData indexDiffData, @NonNull File file) {
        return this.get(indexDiffData, new FileItem(file));
    }

    @NonNull
    private IResourceState get(@NonNull IndexDiffData indexDiffData, @NonNull FileSystemItem file) {
        IPath path = file.getAbsolutePath();
        if (path == null) {
            return UNKNOWN_STATE;
        }
        Repository repository = file.getRepository();
        if (repository == null || repository.isBare()) {
            return UNKNOWN_STATE;
        }
        File workTree = repository.getWorkTree();
        String repoRelativePath = path.makeRelativeTo((IPath)new Path(workTree.getAbsolutePath())).toString();
        if (repoRelativePath.equals(path.toString())) {
            return UNKNOWN_STATE;
        }
        ResourceState result = new ResourceState();
        if (file.isContainer()) {
            if (!repoRelativePath.endsWith("/")) {
                repoRelativePath = String.valueOf(repoRelativePath) + '/';
            }
            if (ResourceUtil.isSymbolicLink((Repository)repository, (String)repoRelativePath)) {
                this.extractFileProperties(indexDiffData, repoRelativePath, result);
            } else {
                this.extractContainerProperties(indexDiffData, repoRelativePath, file, result);
            }
        } else {
            this.extractFileProperties(indexDiffData, repoRelativePath, result);
        }
        return result;
    }

    private void extractFileProperties(@NonNull IndexDiffData indexDiffData, @NonNull String repoRelativePath, @NonNull ResourceState state) {
        Set ignoredFiles = indexDiffData.getIgnoredNotInIndex();
        boolean ignored = ignoredFiles.contains(repoRelativePath) || this.containsPrefixPath(ignoredFiles, repoRelativePath);
        state.setIgnored(ignored);
        Set untracked = indexDiffData.getUntracked();
        state.setTracked(!ignored && !untracked.contains(repoRelativePath));
        Set added = indexDiffData.getAdded();
        Set removed = indexDiffData.getRemoved();
        Set changed = indexDiffData.getChanged();
        if (added.contains(repoRelativePath)) {
            state.setStagingState(IResourceState.StagingState.ADDED);
        } else if (removed.contains(repoRelativePath)) {
            state.setStagingState(IResourceState.StagingState.REMOVED);
        } else if (changed.contains(repoRelativePath)) {
            state.setStagingState(IResourceState.StagingState.MODIFIED);
        } else {
            state.setStagingState(IResourceState.StagingState.NOT_STAGED);
        }
        Set conflicting = indexDiffData.getConflicting();
        state.setConflicts(conflicting.contains(repoRelativePath));
        Set modified = indexDiffData.getModified();
        state.setDirty(modified.contains(repoRelativePath));
        Set missing = indexDiffData.getMissing();
        state.setMissing(missing.contains(repoRelativePath));
        Set assumeUnchanged = indexDiffData.getAssumeUnchanged();
        state.setAssumeUnchanged(assumeUnchanged.contains(repoRelativePath));
    }

    private void extractContainerProperties(@NonNull IndexDiffData indexDiffData, @NonNull String repoRelativePath, @NonNull FileSystemItem directory, @NonNull ResourceState state) {
        Set ignoredFiles = indexDiffData.getIgnoredNotInIndex();
        Set untrackedFolders = indexDiffData.getUntrackedFolders();
        boolean ignored = this.containsPrefixPath(ignoredFiles, repoRelativePath) || !directory.hasContainerAnyFiles();
        state.setIgnored(ignored);
        state.setTracked(!ignored && !this.containsPrefixPath(untrackedFolders, repoRelativePath));
        HashSet<String> changed = new HashSet<String>(indexDiffData.getChanged());
        changed.addAll(indexDiffData.getAdded());
        changed.addAll(indexDiffData.getRemoved());
        if (this.containsPrefix(changed, repoRelativePath)) {
            state.setStagingState(IResourceState.StagingState.MODIFIED);
        } else {
            state.setStagingState(IResourceState.StagingState.NOT_STAGED);
        }
        Set conflicting = indexDiffData.getConflicting();
        state.setConflicts(this.containsPrefix(conflicting, repoRelativePath));
        Set modified = indexDiffData.getModified();
        Set untracked = indexDiffData.getUntracked();
        Set missing = indexDiffData.getMissing();
        state.setDirty(this.containsPrefix(modified, repoRelativePath) || this.containsPrefix(untracked, repoRelativePath) || this.containsPrefix(missing, repoRelativePath));
    }

    private boolean containsPrefix(Set<String> collection, String prefix) {
        if (prefix.length() == 1 && !collection.isEmpty()) {
            return true;
        }
        for (String path : collection) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean containsPrefixPath(Set<String> collection, String path) {
        for (String entry : collection) {
            String entryPath = entry.endsWith("/") ? entry : String.valueOf(entry) + "/";
            if (!path.startsWith(entryPath)) continue;
            return true;
        }
        return false;
    }

    private static class FileItem
    implements FileSystemItem {
        @NonNull
        private final File file;

        public FileItem(@NonNull File file) {
            this.file = file;
        }

        @Override
        @NonNull
        public IPath getAbsolutePath() {
            return new Path(this.file.getAbsolutePath());
        }

        @Override
        public Repository getRepository() {
            return ResourceUtil.getRepository((IPath)this.getAbsolutePath());
        }

        @Override
        public boolean isContainer() {
            return this.file.isDirectory();
        }

        @Override
        public boolean hasContainerAnyFiles() {
            if (!this.isContainer()) {
                throw new IllegalArgumentException("Container expected");
            }
            try {
                final boolean[] result = new boolean[1];
                final java.nio.file.Path dotGit = Paths.get(".git", new String[0]);
                Files.walkFileTree(this.file.toPath(), (FileVisitor<? super java.nio.file.Path>)new FileVisitor<java.nio.file.Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                        if (dotGit.equals(dir.getFileName())) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(java.nio.file.Path path, BasicFileAttributes attrs) throws IOException {
                        if (!attrs.isDirectory()) {
                            result[0] = true;
                            return FileVisitResult.TERMINATE;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(java.nio.file.Path path, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
                return result[0];
            }
            catch (IOException e) {
                return true;
            }
        }
    }

    private static interface FileSystemItem {
        public boolean hasContainerAnyFiles();

        public boolean isContainer();

        @Nullable
        public IPath getAbsolutePath();

        @Nullable
        public Repository getRepository();
    }

    private static class ResourceItem
    implements FileSystemItem {
        @NonNull
        private final IResource resource;

        public ResourceItem(@NonNull IResource resource) {
            this.resource = resource;
        }

        @Override
        @Nullable
        public IPath getAbsolutePath() {
            return this.resource.getLocation();
        }

        @Override
        public Repository getRepository() {
            return ResourceUtil.getRepository((IResource)this.resource);
        }

        @Override
        public boolean isContainer() {
            return this.isContainer(this.resource);
        }

        @Override
        public boolean hasContainerAnyFiles() {
            return this.containsFiles(this.resource);
        }

        private boolean isContainer(IResource rsc) {
            int type = rsc.getType();
            return type == 2 || type == 4 || type == 8;
        }

        private boolean containsFiles(IResource rsc) {
            if (rsc instanceof IContainer) {
                IContainer container = (IContainer)rsc;
                try {
                    return this.anyFile(container.members());
                }
                catch (CoreException e) {
                    return true;
                }
            }
            throw new IllegalArgumentException("Expected a container resource.");
        }

        private boolean anyFile(IResource[] members) {
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member.getType() == 1) {
                    return true;
                }
                if (this.isContainer(member) && this.containsFiles(member)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

