/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.emf.facet.custom.ui.ISelectionPropertiesHandler;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.TableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.FacetsUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridElementManager {
    private final IFacetManager facetManager;
    private final ICustomizationManager customManager;
    private final ISelectionPropertiesHandler selectionPropH;

    public GridElementManager(IFacetManager facetManager, ICustomizationManager customManager, ISelectionPropertiesHandler selectionPropH) {
        this.facetManager = facetManager;
        this.customManager = customManager;
        this.selectionPropH = selectionPropH;
    }

    public Collection<? extends Object> resolveSelection(IGridElement gridElement) {
        Collection<Object> result = Collections.emptyList();
        EObject element = gridElement.getRow().getElement();
        if (element != null && GridElementManager.isApplicable(gridElement, this.facetManager)) {
            try {
                ETypedElement feature = ((FeatureColumn)gridElement.getColumn()).getFeature();
                FacetOperation selectionProperty = this.selectionPropH.getSelectionProperty();
                result = (Collection)this.customManager.getCustomValueOf(element, feature, selectionProperty, List.class);
            }
            catch (CustomizationException e) {
                Logger.logWarning((Throwable)e, (String)"Error in table selection customization", (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    private static List<IGridElement> getSelectedGridElements(List<Object> rawSelection) {
        ArrayList<IGridElement> gridElements = new ArrayList<IGridElement>();
        for (Object object : rawSelection) {
            if (!(object instanceof IGridElement)) continue;
            gridElements.add((IGridElement)object);
        }
        return gridElements;
    }

    public boolean isSelectedCellEditable(List<Object> rawSelection) {
        List<IGridElement> gridElements = GridElementManager.getSelectedGridElements(rawSelection);
        return gridElements.size() == 1 && this.isGridElementEditable(gridElements.get(0));
    }

    private boolean isGridElementEditable(IGridElement gridElement) {
        FeatureColumn featureColumn;
        ETypedElement feature;
        boolean editable = false;
        EObject eObject = gridElement.getRow().getElement();
        Column column = gridElement.getColumn();
        URI uri = eObject.eResource().getURI();
        if ((uri.isPlatformResource() || uri.isFile()) && column instanceof FeatureColumn && (feature = (featureColumn = (FeatureColumn)column).getFeature()) instanceof EStructuralFeature && ((EStructuralFeature)feature).isChangeable()) {
            if (feature instanceof DerivedTypedElement) {
                try {
                    DerivedTypedElement derivedTypedElt = (DerivedTypedElement)feature;
                    editable = this.facetManager.isConforming(eObject, (Facet)derivedTypedElt.eContainer());
                }
                catch (Exception e) {
                    Logger.logWarning((Throwable)e, (String)"Failed to check Facet conformance", (Plugin)Activator.getDefault());
                }
            } else {
                EList features = eObject.eClass().getEAllStructuralFeatures();
                editable = features.contains(feature);
            }
        }
        return editable;
    }

    public ISelection computeSelection(List<Object> gridSelection) {
        ArrayList<Object> result = new ArrayList<Object>();
        StringBuffer debugBuffer = null;
        if (TableWidget.DEBUG_SELECTION) {
            debugBuffer = new StringBuffer();
        }
        for (Object selectedElement : gridSelection) {
            if (!(selectedElement instanceof IGridElement)) continue;
            IGridElement gridElement = (IGridElement)selectedElement;
            Collection<? extends Object> resolvedSelection = this.resolveSelection(gridElement);
            for (Object object : resolvedSelection) {
                if (object == null) continue;
                result.add(object);
                if (!TableWidget.DEBUG_SELECTION) continue;
                debugBuffer.append(System.getProperty("line.separator")).append("    ").append(object);
            }
        }
        if (TableWidget.DEBUG_SELECTION) {
            DebugUtils.debug((String)debugBuffer.toString());
        }
        return new StructuredSelection(result);
    }

    public Set<EObject> getSelectedEObjects(List<Object> rawSelection) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (Object selectedElement : rawSelection) {
            if (!(selectedElement instanceof IGridElement)) continue;
            IGridElement gridElement = (IGridElement)selectedElement;
            try {
                Object value = this.getValueOf(gridElement);
                if (!(value instanceof EObject)) continue;
                EObject eObject = (EObject)value;
                result.add(eObject);
            }
            catch (FacetManagerException facetManagerException) {
                Logger.logError((String)"Error getting the value of a grid element to delete", (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    private Object getValueOf(IGridElement gridElement) throws FacetManagerException {
        return GridElementManager.getValueOf(gridElement, this.facetManager);
    }

    public static Object getValueOf(IGridElement gridElement, IFacetManager context) throws FacetManagerException {
        EObject element;
        Object value = null;
        if (gridElement.getColumn() instanceof FeatureColumn && (element = gridElement.getRow().getElement()) != null) {
            FeatureColumn featureColumn = (FeatureColumn)gridElement.getColumn();
            ETypedElement eTypedElement = featureColumn.getFeature();
            if (FacetsUtils.hasStructuralFeature(element, eTypedElement, context)) {
                value = context.getOrInvoke(element, eTypedElement, Object.class);
            } else {
                return "\ufffd";
            }
        }
        return value;
    }

    public static boolean isApplicable(IGridElement gridElement, IFacetManager context) {
        EObject element;
        boolean result = false;
        if (gridElement.getColumn() instanceof FeatureColumn && (element = gridElement.getRow().getElement()) != null) {
            FeatureColumn featureColumn = (FeatureColumn)gridElement.getColumn();
            ETypedElement eTypedElement = featureColumn.getFeature();
            try {
                if (FacetsUtils.hasStructuralFeature(element, eTypedElement, context)) {
                    result = true;
                }
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }
}

