/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.validation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.language.htmllabel.DotHtmlLabelHelper;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlAttr;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmllabelPackage;
import org.eclipse.gef.dot.internal.language.validation.AbstractDotHtmlLabelJavaValidator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;

public class DotHtmlLabelJavaValidator
extends AbstractDotHtmlLabelJavaValidator {
    @Check
    public void checkTagIsClosed(HtmlTag tag) {
        if (!tag.getName().toUpperCase().equals(tag.getCloseName().toUpperCase())) {
            this.reportRangeBasedError("Tag '<" + tag.getName() + ">' is not closed (expected '</" + tag.getName() + ">' but got '</" + tag.getCloseName() + ">').", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__CLOSE_NAME);
        }
    }

    @Check
    public void checkSelfClosingTagIsAllowed(HtmlTag tag) {
        String tagNameUpperCase = tag.getName().toUpperCase();
        if (tag.isSelfClosing() && DotHtmlLabelHelper.getNonSelfClosingTags().contains(tagNameUpperCase)) {
            this.reportRangeBasedError("Tag '<" + tag.getName() + "/>' cannot be self closing.", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
        }
    }

    @Check
    public void checkStringLiteralIsAllowed(HtmlTag tag) {
        Object[] stringLiteralIsNotAllowed = new String[]{"BR", "HR", "IMG", "TABLE", "TR", "VR"};
        String tagNameUpperCase = tag.getName().toUpperCase();
        if (Arrays.binarySearch(stringLiteralIsNotAllowed, tagNameUpperCase) >= 0) {
            for (HtmlContent child : tag.getChildren()) {
                String text = child.getText();
                if (text == null || text.trim().isEmpty()) continue;
                this.reportRangeBasedError("Tag '<" + tag.getName() + ">' cannot contain a string literal.", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
            }
        }
    }

    @Check
    public void checkTagNameIsValid(HtmlTag tag) {
        String tagName = tag.getName();
        if (!DotHtmlLabelHelper.getAllTags().contains(tagName.toUpperCase())) {
            this.reportRangeBasedError("Tag '<" + tagName + ">' is not supported.", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
        } else {
            EObject container = tag.eContainer().eContainer();
            HtmlTag parent = null;
            if (container instanceof HtmlTag) {
                parent = (HtmlTag)container;
            }
            String parentName = parent == null ? DotHtmlLabelHelper.getRootTagKey() : parent.getName();
            Map<String, Set<String>> validTags = DotHtmlLabelHelper.getValidTags();
            if (!validTags.containsKey(parentName.toUpperCase()) || !validTags.get(parentName.toUpperCase()).contains(tagName.toUpperCase())) {
                this.reportRangeBasedError("Tag '<" + tagName + ">' is not allowed inside '<" + parentName + ">', but only inside '<" + String.join((CharSequence)">', '<", (Iterable<? extends CharSequence>)DotHtmlLabelHelper.getAllowedParents().get(tagName.toUpperCase())) + ">'.", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
            }
        }
    }

    @Check
    public void checkAttributeNameIsValid(HtmlAttr attr) {
        String attrName = attr.getName();
        EObject container = attr.eContainer();
        if (container instanceof HtmlTag) {
            HtmlTag tag = (HtmlTag)container;
            String tagName = tag.getName();
            Map<String, Set<String>> validAttributes = DotHtmlLabelHelper.getValidAttributes();
            if (!validAttributes.containsKey(tagName.toUpperCase()) || !validAttributes.get(tagName.toUpperCase()).contains(attrName.toUpperCase())) {
                this.reportRangeBasedError("Attribute '" + attrName + "' is not allowed inside '<" + tagName + ">'.", attr, (EStructuralFeature)HtmllabelPackage.Literals.HTML_ATTR__NAME);
            }
        }
    }

    @Check
    public void checkAttributeValueIsValid(HtmlAttr attr) {
        HtmlTag tag;
        String htmlTagName;
        String message;
        String htmlAttributeName = attr.getName();
        String htmlAttributeValue = this.removeDoubleQuotes(attr.getValue());
        EObject container = attr.eContainer();
        if (container instanceof HtmlTag && (message = this.getAttributeValueErrorMessage(htmlTagName = (tag = (HtmlTag)container).getName(), htmlAttributeName, htmlAttributeValue)) != null) {
            this.reportRangeBasedError("The value '" + htmlAttributeValue + "' is not a correct " + htmlAttributeName + ": " + message, attr, (EStructuralFeature)HtmllabelPackage.Literals.HTML_ATTR__VALUE);
        }
    }

    private String removeDoubleQuotes(String value) {
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private String getAttributeValueErrorMessage(String htmlTagName, String htmlAttributeName, String htmlAttributeValue) {
        block96: {
            block94: {
                block92: {
                    block90: {
                        if (!"BR".equalsIgnoreCase(htmlTagName)) break block90;
                        switch (htmlAttributeName.toUpperCase()) {
                            case "ALIGN": {
                                return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "CENTER", "LEFT", "RIGHT");
                            }
                        }
                    }
                    if (!"IMG".equalsIgnoreCase(htmlTagName)) break block92;
                    switch (htmlAttributeName.toUpperCase()) {
                        case "SCALE": {
                            return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "FALSE", "TRUE", "WIDTH", "HEIGHT", "BOTH");
                        }
                    }
                }
                if (!"TABLE".equalsIgnoreCase(htmlTagName)) break block94;
                switch (htmlAttributeName.toUpperCase()) {
                    case "ALIGN": {
                        return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "CENTER", "LEFT", "RIGHT");
                    }
                    case "BORDER": {
                        return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 255);
                    }
                    case "CELLBORDER": {
                        return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 127);
                    }
                    case "CELLPADDING": {
                        return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 255);
                    }
                    case "CELLSPACING": {
                        return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 127);
                    }
                    case "ROWS": 
                    case "COLUMNS": {
                        return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "*");
                    }
                    case "FIXEDSIZE": {
                        return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "FALSE", "TRUE");
                    }
                    case "WIDTH": 
                    case "HEIGHT": {
                        return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 65535);
                    }
                    case "SIDES": {
                        return this.getSidesAttributeValueErrorMessage(htmlAttributeValue);
                    }
                    case "VALIGN": {
                        return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "MIDDLE", "BOTTOM", "TOP");
                    }
                }
            }
            if (!"TD".equalsIgnoreCase(htmlTagName)) break block96;
            switch (htmlAttributeName.toUpperCase()) {
                case "ALIGN": {
                    return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "CENTER", "LEFT", "RIGHT", "TEXT");
                }
                case "BALIGN": {
                    return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "CENTER", "LEFT", "RIGHT");
                }
                case "BORDER": {
                    return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 255);
                }
                case "CELLPADDING": {
                    return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 255);
                }
                case "CELLSPACING": {
                    return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 127);
                }
                case "COLSPAN": 
                case "ROWSPAN": {
                    return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 1, 65535);
                }
                case "FIXEDSIZE": {
                    return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "FALSE", "TRUE");
                }
                case "WIDTH": 
                case "HEIGHT": {
                    return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 65535);
                }
                case "SIDES": {
                    return this.getSidesAttributeValueErrorMessage(htmlAttributeValue);
                }
                case "VALIGN": {
                    return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "MIDDLE", "BOTTOM", "TOP");
                }
            }
        }
        return null;
    }

    private String getEnumAttributeValueErrorMessage(String currentValue, String ... allowedValues) {
        List<String> allowedValuesList = Arrays.asList(allowedValues);
        if (allowedValuesList.contains(currentValue.toUpperCase())) {
            return null;
        }
        String formattedAllowedValues = allowedValuesList.stream().map(e -> "'" + e + "'").collect(Collectors.joining(", "));
        return "Value has to be " + (allowedValues.length > 1 ? "one of " : "") + formattedAllowedValues + ".";
    }

    private String getNumberAttributeValueErrorMessage(String currentValue, int minimum, int maximum) {
        boolean isValid = true;
        try {
            int currentValueParsed = Integer.parseInt(currentValue);
            isValid = minimum <= currentValueParsed && currentValueParsed <= maximum;
        }
        catch (NumberFormatException numberFormatException) {
            isValid = false;
        }
        if (isValid) {
            return null;
        }
        return String.format("Value has to be between %1$d and %2$d.", minimum, maximum);
    }

    private String getSidesAttributeValueErrorMessage(String htmlAttributeValue) {
        if (htmlAttributeValue.isEmpty()) {
            return "Value has to contain only the 'L', 'T', 'R', 'B' characters.";
        }
        int i = 0;
        while (i < htmlAttributeValue.length()) {
            String subString = Character.toString(htmlAttributeValue.charAt(i)).toUpperCase();
            if (!"LTRB".contains(subString)) {
                return "Value has to contain only the 'L', 'T', 'R', 'B' characters.";
            }
            ++i;
        }
        return null;
    }

    private void reportRangeBasedError(String message, EObject object, EStructuralFeature feature) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)object, (EStructuralFeature)feature);
        if (nodes.size() != 1) {
            throw new IllegalStateException("Exact 1 node is expected for the feature, but got " + nodes.size() + " node(s).");
        }
        INode node = (INode)nodes.get(0);
        int offset = node.getTotalOffset();
        int length = node.getLength();
        String code = null;
        String[] issueData = null;
        this.getMessageAcceptor().acceptError(message, object, offset, length, code, issueData);
    }
}

