/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.utils;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenViewUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OpenViewUtils.class);

    private OpenViewUtils() {
    }

    public static void showViewPrompt(String viewId, String preferenceKey) {
        IWorkbench worbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWindow = worbench.getActiveWorkbenchWindow();
        IPreferenceStore preferenceStore = Plugin.getDefault().getPreferenceStore();
        IViewDescriptor descr = worbench.getViewRegistry().find(viewId);
        String viewName = descr != null ? descr.getLabel() : "";
        int value = preferenceStore.getInt(preferenceKey);
        IWorkbenchPage activePage = activeWindow.getActivePage();
        IViewPart part = activePage.findView(viewId);
        if (part == null || !activePage.isPartVisible((IWorkbenchPart)part)) {
            if (value != 2 && value != 1) {
                int exitCode = OpenViewUtils.createQuestionDialog(preferenceKey, activeWindow, preferenceStore, viewName);
                if (exitCode == 2) {
                    OpenViewUtils.showView(viewId, activePage);
                }
            } else if (value == 1) {
                OpenViewUtils.showView(viewId, activePage);
            }
        }
    }

    private static int createQuestionDialog(final String preferenceKey, IWorkbenchWindow activeWindow, final IPreferenceStore preferenceStore, String viewName) {
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(activeWindow.getShell(), Messages.UtilsOpenViewTitle, null, NLS.bind((String)Messages.UtilsViewQuestion, (Object)viewName), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, Messages.UtilsRemember, false){

            protected void buttonPressed(int buttonId) {
                super.buttonPressed(buttonId);
                int val = 0;
                if (this.getToggleState() && this.getReturnCode() == 3) {
                    val = 2;
                } else if (this.getToggleState() && this.getReturnCode() == 2) {
                    val = 1;
                }
                preferenceStore.setValue(preferenceKey, val);
            }
        };
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        int i = dialog.open();
        return i;
    }

    private static void showView(String viewId, IWorkbenchPage activePage) {
        try {
            activePage.showView(viewId);
        }
        catch (PartInitException e) {
            LOG.debug("Part init exception during showView", (Throwable)e);
        }
    }

    public static class TestResultNodeSelectionListener
    implements ISelectionChangedListener {
        private ISelection m_lastSelection = null;

        public void selectionChanged(SelectionChangedEvent event) {
            TestResultNode node;
            IStructuredSelection istruc;
            Object o;
            ISelection selection = event.getSelection();
            if (!selection.equals(this.m_lastSelection) && selection instanceof IStructuredSelection && (o = (istruc = (IStructuredSelection)selection).getFirstElement()) instanceof TestResultNode && StringUtils.isNotBlank((String)(node = (TestResultNode)o).getCommandLog())) {
                OpenViewUtils.showViewPrompt("org.eclipse.jubula.client.ui.views.Log", "OPEN_LOGVIEW_PREF_KEY");
            }
            this.m_lastSelection = selection;
        }
    }
}

