/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.discovery.wizards;

import java.util.Collection;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.PreselectedIUInstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.ui.AcceptLicensesWizardPage;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.internal.discovery.operation.RestartInstallOperation;

public class MavenDiscoveryInstallWizard
extends PreselectedIUInstallWizard {
    private boolean waitingForOtherJobs;
    private RestartInstallOperation originalOperation;

    public MavenDiscoveryInstallWizard(ProvisioningUI ui, RestartInstallOperation operation, Collection<IInstallableUnit> initialSelections, LoadMetadataRepositoryJob job) {
        super(ui, (InstallOperation)operation, initialSelections, job);
        this.originalOperation = operation;
    }

    protected ProfileChangeOperation getProfileChangeOperation(Object[] elements) {
        RestartInstallOperation op = this.originalOperation.copy(ElementUtils.elementsToIUs((Object[])elements));
        op.setProfileId(this.getProfileId());
        return op;
    }

    public boolean shouldRecomputePlan(ISelectableIUsPage page) {
        boolean previouslyWaiting = this.waitingForOtherJobs;
        boolean previouslyCanceled = this.getCurrentStatus().getSeverity() == 8;
        this.waitingForOtherJobs = this.ui.hasScheduledOperations();
        return this.waitingForOtherJobs || previouslyWaiting || previouslyCanceled || this.pageSelectionsHaveChanged(page);
    }

    public void setMainPage(ISelectableIUsPage page) {
        this.mainPage = page;
    }

    public void setResolutionResultsPage(ResolutionResultsWizardPage page) {
        this.resolutionPage = page;
    }

    protected void initializeResolutionModelElements(Object[] selectedElements) {
        super.initializeResolutionModelElements(selectedElements);
        this.workaroundBug348660();
    }

    private void workaroundBug348660() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof AcceptLicensesWizardPage) {
                AcceptLicensesWizardPage licensePage = (AcceptLicensesWizardPage)page;
                licensePage.update(ElementUtils.elementsToIUs((Object[])this.planSelections).toArray(new IInstallableUnit[0]), this.operation);
            }
            ++n2;
        }
    }
}

