/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mat.query.DetailResultProvider;

public final class QueryObjectLink {
    public static final String PROTOCOL = "mat://";
    private static final String ENC = "UTF-8";
    protected Type type;
    protected String target;
    private static final Pattern URL_PATTERN = Pattern.compile("mat://([^/]*)/(.*)");

    public QueryObjectLink(Type type, String target) {
        this.type = type;
        this.target = target;
    }

    public Type getType() {
        return this.type;
    }

    public String getTarget() {
        return this.target;
    }

    public String getURL() {
        return QueryObjectLink.forType(this.type, this.target);
    }

    public static final String forQuery(String query) {
        return QueryObjectLink.forType(Type.QUERY, query);
    }

    public static final String forObject(String identifier) {
        return QueryObjectLink.forType(Type.OBJECT, identifier);
    }

    public static final String forDetailResult(DetailResultProvider provider, String identifier) {
        return QueryObjectLink.forType(Type.DETAIL_RESULT, String.valueOf(provider.getLabel()) + "/" + identifier);
    }

    public static final String forType(Type type, String target) {
        try {
            return PROTOCOL + type.name().toLowerCase(Locale.ENGLISH) + "/" + URLEncoder.encode(target, ENC);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return PROTOCOL + type.name().toLowerCase(Locale.ENGLISH) + "/" + target;
        }
    }

    public static QueryObjectLink parse(String url) {
        Type type;
        Matcher matcher = URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        try {
            type = Type.valueOf(matcher.group(1).toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        String target = matcher.group(2);
        try {
            target = URLDecoder.decode(target, ENC);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return new QueryObjectLink(type, target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        OBJECT,
        QUERY,
        DETAIL_RESULT;

    }
}

