/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.discoverer.DiscoverKDMModelFromJavaProject;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverKDMModelFromProject
extends AbstractModelDiscoverer<IProject> {
    public static final String ID = "org.eclipse.modisco.java.discoverer.projectToKDM";

    public boolean isApplicableTo(IProject project) {
        try {
            return project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            return false;
        }
    }

    protected void basicDiscoverElement(IProject project, IProgressMonitor monitor) throws DiscoveryException {
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)(String.valueOf(project.getFullPath().append(project.getName()).toString()) + "_kdm.xmi"), (boolean)true));
        IJavaProject javaProject = JavaCore.create((IProject)project);
        Resource kdmModel = DiscoverKDMModelFromJavaProject.discoverKDM(javaProject, this.getDefaultTargetURI(), monitor);
        this.getResourceSet().getResources().add((Object)kdmModel);
        this.setTargetModel(kdmModel);
    }
}

