/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractSingleEncapsulatedExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;

public class ExistsExpressionStateObject
extends AbstractSingleEncapsulatedExpressionStateObject {
    private boolean not;
    public static String NOT_PROPERTY = "not";

    public ExistsExpressionStateObject(StateObject parent) {
        super(parent);
    }

    public ExistsExpressionStateObject(StateObject parent, boolean not, StateObject stateObject) {
        super(parent, stateObject);
        this.not = not;
    }

    public ExistsExpressionStateObject(StateObject parent, boolean not, String jpqlFragment) {
        super(parent, jpqlFragment);
        this.not = not;
    }

    public ExistsExpressionStateObject(StateObject parent, StateObject stateObject) {
        this(parent, false, stateObject);
    }

    public ExistsExpressionStateObject(StateObject parent, String jpqlFragment) {
        super(parent, jpqlFragment);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    public ExistsExpressionStateObject addNot() {
        if (!this.not) {
            this.setNot(true);
        }
        return this;
    }

    @Override
    public ExistsExpression getExpression() {
        return (ExistsExpression)super.getExpression();
    }

    @Override
    public String getIdentifier() {
        return "EXISTS";
    }

    @Override
    protected String getQueryBNFId() {
        return "subquery";
    }

    public boolean hasNot() {
        return this.not;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            ExistsExpressionStateObject exists = (ExistsExpressionStateObject)stateObject;
            return this.not == exists.not;
        }
        return false;
    }

    public void removeNot() {
        if (this.not) {
            this.setNot(false);
        }
    }

    public void setExpression(ExistsExpression expression) {
        super.setExpression(expression);
    }

    public void setNot(boolean not) {
        boolean oldNot = this.not;
        this.not = not;
        this.firePropertyChanged(NOT_PROPERTY, oldNot, not);
    }

    @Override
    public void setStateObject(StateObject stateObject) {
        super.setStateObject(stateObject);
    }

    public void toggleNot() {
        this.setNot(!this.not);
    }

    @Override
    protected void toTextEncapsulatedExpression(Appendable writer) throws IOException {
        writer.append(this.not ? "NOT EXISTS" : "EXISTS");
        writer.append('(');
        super.toTextEncapsulatedExpression(writer);
        writer.append(')');
    }
}

