/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.codemanipulation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ModelAccess;
import org.eclipse.dltk.core.manipulation.SourceModuleChange;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.ui.viewsupport.BasicElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.FunctionName;
import org.eclipse.php.core.ast.nodes.IBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.UseStatement;
import org.eclipse.php.core.ast.nodes.UseStatementPart;
import org.eclipse.php.core.ast.visitor.ApplyAll;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.eclipse.php.internal.core.ast.rewrite.ImportRewrite;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPProblemIdentifier;
import org.eclipse.php.internal.core.search.PHPSearchTypeNameMatch;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.php.internal.ui.corext.util.Messages;
import org.eclipse.php.internal.ui.corext.util.TypeNameMatchCollector;
import org.eclipse.php.internal.ui.text.correction.ASTResolving;
import org.eclipse.php.internal.ui.text.correction.ProblemLocation;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class OrganizeUseStatementsOperation
implements IWorkspaceRunnable {
    private static ImportRewrite.ImportRewriteContext UNRESOLVABLE_IMPORT_CONTEXT = new ImportRewrite.ImportRewriteContext(){

        public int findInContext(NamespaceDeclaration namespace, String qualifier, String name, int kind) {
            return 2;
        }
    };
    private int fNumberOfImportsAdded;
    private int fNumberOfImportsRemoved;
    private IChooseImportQuery fChooseImportQuery;
    private ISourceModule fSourceModule;
    private Program fASTRoot;

    public OrganizeUseStatementsOperation(ISourceModule sourceModule, Program astRoot, IChooseImportQuery chooseImportQuery) {
        this.fSourceModule = sourceModule;
        this.fASTRoot = astRoot;
        this.fChooseImportQuery = chooseImportQuery;
        this.fNumberOfImportsAdded = 0;
        this.fNumberOfImportsRemoved = 0;
    }

    public TextEdit createTextEdit(IProgressMonitor monitor) throws CoreException, OperationCanceledException, IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            this.fNumberOfImportsAdded = 0;
            this.fNumberOfImportsRemoved = 0;
            monitor.beginTask(Messages.format(CodeGenerationMessages.OrganizeImportsOperation_description, BasicElementLabels.getFileName((ISourceModule)this.fSourceModule)), 9);
            Program astRoot = this.fASTRoot;
            if (astRoot == null) {
                astRoot = SharedASTProvider.getAST(this.fSourceModule, SharedASTProvider.WAIT_YES, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)2));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            } else {
                monitor.worked(2);
            }
            ImportRewrite importsRewrite = ImportRewrite.create((Program)astRoot, (boolean)false);
            ArrayList<Identifier> typeReferences = new ArrayList<Identifier>();
            HashMap<NamespaceDeclaration, Set<String>> oldSingleImports = new HashMap<NamespaceDeclaration, Set<String>>();
            if (!this.collectReferences(astRoot, typeReferences, oldSingleImports)) {
                return null;
            }
            UnresolvableImportMatcher unresolvableImportMatcher = UnresolvableImportMatcher.forProgram(astRoot);
            TypeReferenceProcessor processor = new TypeReferenceProcessor(oldSingleImports, astRoot, importsRewrite, unresolvableImportMatcher);
            for (Identifier typeRef : typeReferences) {
                processor.add(typeRef);
            }
            Map<NamespaceDeclaration, Boolean> hasOpenChoices = processor.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)3));
            if (this.fChooseImportQuery != null) {
                Map<NamespaceDeclaration, TypeNameMatch[][]> choices = processor.getChoices();
                Map<NamespaceDeclaration, SourceRange[]> ranges = processor.getChoicesSourceRanges();
                for (Map.Entry<NamespaceDeclaration, Boolean> entry : hasOpenChoices.entrySet()) {
                    NamespaceDeclaration namespace = entry.getKey();
                    if (!entry.getValue().booleanValue()) continue;
                    TypeNameMatch[] chosen = this.fChooseImportQuery.chooseImports(choices.get(namespace), (ISourceRange[])ranges.get(namespace));
                    if (chosen == null) {
                        return null;
                    }
                    int i = 0;
                    while (i < chosen.length) {
                        TypeNameMatch typeInfo = chosen[i];
                        if (typeInfo != null) {
                            importsRewrite.addImport(namespace, typeInfo.getFullyQualifiedName());
                        } else {
                            String typeName = choices.get(namespace)[i][0].getSimpleTypeName();
                            Set<String> matchingUnresolvableImports = unresolvableImportMatcher.matchTypeImports(namespace, typeName);
                            if (!matchingUnresolvableImports.isEmpty()) {
                                for (String string : matchingUnresolvableImports) {
                                    importsRewrite.addImport(namespace, string, UNRESOLVABLE_IMPORT_CONTEXT);
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
            TextEdit result = importsRewrite.rewriteImports((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)3));
            this.determineImportDifferences(importsRewrite, oldSingleImports.values());
            TextEdit textEdit = result;
            return textEdit;
        }
        catch (Exception e) {
            PHPUiPlugin.log(e);
        }
        finally {
            monitor.done();
        }
        return null;
    }

    private void determineImportDifferences(ImportRewrite importsStructure, Collection<Set<String>> oldSingleImportsCollection) {
        ArrayList<String> importsAdded = new ArrayList<String>();
        importsAdded.addAll(Arrays.asList(importsStructure.getCreatedImports()));
        for (Set<String> oldSingleImports : oldSingleImportsCollection) {
            Object[] content = oldSingleImports.toArray();
            int i = 0;
            while (i < content.length) {
                String importName = (String)content[i];
                if (importsAdded.remove(importName)) {
                    oldSingleImports.remove(importName);
                }
                ++i;
            }
            this.fNumberOfImportsRemoved += oldSingleImports.size();
        }
        this.fNumberOfImportsAdded = importsAdded.size();
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                Change undoChange;
                monitor.beginTask(Messages.format(CodeGenerationMessages.OrganizeImportsOperation_description, BasicElementLabels.getFileName((ISourceModule)this.fSourceModule)), 10);
                SourceModuleChange cuChange = new SourceModuleChange("OrganizeUseStatements", this.fSourceModule);
                cuChange.setSaveMode(4);
                SourceModuleChange change = cuChange;
                TextEdit edit = this.createTextEdit((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                if (edit != null) {
                    change.setEdit(edit);
                }
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                RefactoringStatus valid = change.isValid((IProgressMonitor)new NullProgressMonitor());
                if (valid.hasFatalError()) {
                    Status status = new Status(4, "org.eclipse.php.ui", 4, valid.getMessageMatchingSeverity(4), null);
                    throw new CoreException((IStatus)status);
                }
                IUndoManager manager = RefactoringCore.getUndoManager();
                boolean successful = false;
                try {
                    manager.aboutToPerformChange((Change)change);
                    undoChange = change.perform((IProgressMonitor)new NullProgressMonitor());
                    successful = true;
                }
                finally {
                    manager.changePerformed((Change)change, successful);
                }
                if (undoChange != null) {
                    undoChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    manager.addUndo("OrganizeUseStatements", undoChange);
                }
            }
            catch (IOException | MalformedTreeException e) {
                PHPUiPlugin.log(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean collectReferences(Program astRoot, List<Identifier> typeReferences, Map<NamespaceDeclaration, Set<String>> oldSingleImports) {
        List namespaces = astRoot.getNamespaceDeclarations();
        if (namespaces.size() > 0) {
            for (NamespaceDeclaration namespace : namespaces) {
                this.collectImports(astRoot, namespace, oldSingleImports);
            }
        } else {
            this.collectImports(astRoot, null, oldSingleImports);
        }
        astRoot.accept((Visitor)new ReferencesCollector(typeReferences));
        return true;
    }

    private void collectImports(Program astRoot, NamespaceDeclaration namespace, Map<NamespaceDeclaration, Set<String>> oldSingleImports) {
        oldSingleImports.put(namespace, new HashSet());
        List imports = astRoot.getUseStatements(namespace);
        int i = 0;
        while (i < imports.size()) {
            UseStatement curr = (UseStatement)imports.get(i);
            for (UseStatementPart part : curr.parts()) {
                String importName = part.getName().getName();
                if (part.getAlias() != null) {
                    importName = String.valueOf(importName) + " as " + part.getAlias().getName();
                }
                oldSingleImports.get(namespace).add(importName);
            }
            ++i;
        }
    }

    public int getNumberOfImportsAdded() {
        return this.fNumberOfImportsAdded;
    }

    public int getNumberOfImportsRemoved() {
        return this.fNumberOfImportsRemoved;
    }

    public ISchedulingRule getScheduleRule() {
        return this.fSourceModule.getResource();
    }

    public static interface IChooseImportQuery {
        public TypeNameMatch[] chooseImports(TypeNameMatch[][] var1, ISourceRange[] var2);
    }

    static class ReferencesCollector
    extends ApplyAll {
        private static final List<String> TYPE_SKIP = new ArrayList<String>();
        List<Identifier> fTypeReferences;

        static {
            TYPE_SKIP.add("parent");
            TYPE_SKIP.add("self");
            TYPE_SKIP.add("static");
            TYPE_SKIP.add("class");
        }

        public ReferencesCollector(List<Identifier> typeReferences) {
            this.fTypeReferences = typeReferences;
        }

        protected boolean apply(ASTNode node) {
            return true;
        }

        public boolean visit(UseStatement statement) {
            return false;
        }

        public boolean visit(NamespaceName name) {
            if (!name.isGlobal() && !(name.getParent() instanceof NamespaceDeclaration)) {
                Identifier node;
                if (PHPSimpleTypes.isHintable((String)name.getName(), (PHPVersion)name.getAST().apiLevel()) || TYPE_SKIP.contains(name.getName())) {
                    return false;
                }
                List segs = name.segments();
                if (segs.size() > 0 && (PHPElementConciliator.concile((ASTNode)(node = (Identifier)segs.get(segs.size() - 1))) == 4 || PHPElementConciliator.concile((ASTNode)node) == 8)) {
                    this.fTypeReferences.add((Identifier)name);
                }
            }
            return false;
        }

        public boolean visit(FunctionName functionName) {
            return false;
        }

        public boolean visit(Scalar scalar) {
            return false;
        }
    }

    private static class TypeReferenceProcessor {
        private Map<NamespaceDeclaration, Set<String>> fOldSingleImports;
        private ImportRewrite fImpStructure;
        private final UnresolvableImportMatcher fUnresolvableImportMatcher;
        private boolean fAllowDefaultPackageImports;
        private Map<NamespaceDeclaration, Map<String, UnresolvedTypeData>> fUnresolvedTypes = new HashMap<NamespaceDeclaration, Map<String, UnresolvedTypeData>>();
        private Map<NamespaceDeclaration, Set<String>> fImportsAdded = new HashMap<NamespaceDeclaration, Set<String>>();
        private Map<NamespaceDeclaration, TypeNameMatch[][]> fOpenChoices = new HashMap<NamespaceDeclaration, TypeNameMatch[][]>();
        private Map<NamespaceDeclaration, SourceRange[]> fSourceRanges = new HashMap<NamespaceDeclaration, SourceRange[]>();
        private Program fRoot;

        public TypeReferenceProcessor(Map<NamespaceDeclaration, Set<String>> oldSingleImports, Program root, ImportRewrite impStructure, UnresolvableImportMatcher unresolvableImportMatcher) {
            this.fRoot = root;
            this.fOldSingleImports = oldSingleImports;
            this.fImpStructure = impStructure;
            this.fUnresolvableImportMatcher = unresolvableImportMatcher;
            this.fAllowDefaultPackageImports = true;
            List namespaces = root.getNamespaceDeclarations();
            if (namespaces.size() > 0) {
                for (NamespaceDeclaration namespace : namespaces) {
                    this.fImportsAdded.put(namespace, new HashSet());
                    this.fUnresolvedTypes.put(namespace, new HashMap());
                }
            } else {
                this.fImportsAdded.put(null, new HashSet());
                this.fUnresolvedTypes.put(null, new HashMap());
            }
        }

        public void add(Identifier ref) {
            String typeName;
            NamespaceDeclaration namespace = this.fRoot.getNamespaceDeclaration(ref.getStart());
            String importName = typeName = ref.getName();
            int index = typeName.indexOf("\\");
            if (index > 0) {
                importName = typeName.substring(0, index);
                typeName = typeName.substring(index + 1);
            }
            if (this.fImportsAdded.get(namespace) == null || this.fImportsAdded.get(namespace).contains(importName)) {
                return;
            }
            IBinding binding = ref.resolveBinding();
            if (binding != null) {
                if (binding.getKind() != 2) {
                    return;
                }
                ITypeBinding typeBinding = ((ITypeBinding)binding).getTypeDeclaration();
                if (typeBinding != null) {
                    String alias = null;
                    String typeBindingName = typeBinding.getName();
                    if (typeBindingName != null) {
                        int indexOfNs;
                        if (typeBindingName.startsWith("\\")) {
                            typeBindingName = typeBindingName.substring(1);
                        }
                        if ((indexOfNs = typeBindingName.lastIndexOf(typeName)) > 0 && !importName.equalsIgnoreCase(typeName) && (typeBindingName = typeBindingName.substring(0, indexOfNs)).endsWith("\\")) {
                            typeBindingName = typeBindingName.substring(0, typeBindingName.length() - 1);
                        }
                        String lastSeg = typeBindingName;
                        String[] segs = typeBindingName.split("\\\\");
                        if (segs.length > 0) {
                            lastSeg = segs[segs.length - 1];
                        }
                        if (!lastSeg.equalsIgnoreCase(importName)) {
                            alias = importName;
                        }
                    }
                    this.fImpStructure.addImport(namespace, typeBindingName, alias);
                    this.fImportsAdded.get(namespace).add(importName);
                    return;
                }
            }
            this.fImportsAdded.get(namespace).add(typeName);
            this.fUnresolvedTypes.get(namespace).put(typeName, new UnresolvedTypeData(ref));
        }

        public Map<NamespaceDeclaration, Boolean> process(IProgressMonitor monitor) throws ModelException {
            try {
                HashMap<NamespaceDeclaration, Boolean> hasOpenChoices = new HashMap<NamespaceDeclaration, Boolean>();
                IScriptProject project = this.fImpStructure.getSourceModule().getScriptProject();
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project);
                List namespaces = this.fRoot.getNamespaceDeclarations();
                if (namespaces.size() > 0) {
                    for (NamespaceDeclaration namespace : namespaces) {
                        hasOpenChoices.put(namespace, this.internalProcess(namespace, scope, monitor));
                    }
                } else {
                    hasOpenChoices.put(null, this.internalProcess(null, scope, monitor));
                }
                HashMap<NamespaceDeclaration, Boolean> hashMap = hasOpenChoices;
                return hashMap;
            }
            finally {
                monitor.done();
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean internalProcess(NamespaceDeclaration namespace, IDLTKSearchScope scope, IProgressMonitor monitor) throws ModelException {
            void var7_9;
            int nUnresolved = this.fUnresolvedTypes.get(namespace).size();
            if (nUnresolved == 0) {
                return false;
            }
            ArrayList<TypeNameMatch> typesFound = new ArrayList<TypeNameMatch>();
            TypeNameMatchCollector collector = new TypeNameMatchCollector(typesFound);
            Iterator<String> iterator = this.fUnresolvedTypes.get(namespace).keySet().iterator();
            while (iterator.hasNext()) {
                IType[] types;
                ModelAccess modelAccess = new ModelAccess();
                IType[] iTypeArray = types = modelAccess.findTypes(iterator.next(), ISearchEngine.MatchRule.EXACT, 0, 0, scope, monitor);
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    PHPSearchTypeNameMatch match = new PHPSearchTypeNameMatch(type, type.getFlags());
                    collector.acceptTypeNameMatch((TypeNameMatch)match);
                    ++n2;
                }
            }
            boolean bl = false;
            while (var7_9 < typesFound.size()) {
                TypeNameMatch curr = typesFound.get((int)var7_9);
                UnresolvedTypeData data = this.fUnresolvedTypes.get(namespace).get(curr.getSimpleTypeName());
                if (data != null && this.isOfKind(curr, data.typeKinds) && (this.fAllowDefaultPackageImports || curr.getPackageName().length() > 0)) {
                    data.addInfo(curr);
                }
                ++var7_9;
            }
            for (Map.Entry entry : this.fUnresolvedTypes.get(namespace).entrySet()) {
                Set<String> matchingUnresolvableImports;
                if (((UnresolvedTypeData)entry.getValue()).foundInfos.size() != 0 || (matchingUnresolvableImports = this.fUnresolvableImportMatcher.matchTypeImports(namespace, (String)entry.getKey())).isEmpty()) continue;
                for (String string : matchingUnresolvableImports) {
                    this.fImpStructure.addImport(namespace, string, UNRESOLVABLE_IMPORT_CONTEXT);
                }
            }
            ArrayList<TypeNameMatch[]> arrayList = new ArrayList<TypeNameMatch[]>(nUnresolved);
            ArrayList<SourceRange> sourceRanges = new ArrayList<SourceRange>(nUnresolved);
            for (UnresolvedTypeData data : this.fUnresolvedTypes.get(namespace).values()) {
                TypeNameMatch[] openChoice = this.processTypeInfo(namespace, data.foundInfos);
                if (openChoice == null) continue;
                arrayList.add(openChoice);
                sourceRanges.add(new SourceRange(data.ref.getStart(), data.ref.getLength()));
            }
            if (arrayList.isEmpty()) {
                return false;
            }
            this.fOpenChoices.put(namespace, (TypeNameMatch[][])arrayList.toArray((T[])new TypeNameMatch[arrayList.size()][]));
            this.fSourceRanges.put(namespace, sourceRanges.toArray(new SourceRange[sourceRanges.size()]));
            return true;
        }

        private TypeNameMatch[] processTypeInfo(NamespaceDeclaration namespace, List<TypeNameMatch> typeRefsFound) {
            int nFound = typeRefsFound.size();
            if (nFound == 0) {
                return null;
            }
            if (nFound == 1) {
                TypeNameMatch typeRef = typeRefsFound.get(0);
                this.fImpStructure.addImport(namespace, typeRef.getFullyQualifiedName());
                return null;
            }
            int i = 0;
            while (i < nFound) {
                TypeNameMatch typeRef = typeRefsFound.get(i);
                String fullName = typeRef.getFullyQualifiedName();
                if (this.fOldSingleImports.get(namespace).contains(fullName)) {
                    this.fImpStructure.addImport(namespace, fullName);
                    return null;
                }
                ++i;
            }
            return typeRefsFound.toArray(new TypeNameMatch[nFound]);
        }

        private boolean isOfKind(TypeNameMatch curr, int typeKinds) {
            int flags = curr.getModifiers();
            if (Flags.isInterface((int)flags)) {
                return (typeKinds & 4) != 0;
            }
            return (typeKinds & 2) != 0;
        }

        public Map<NamespaceDeclaration, TypeNameMatch[][]> getChoices() {
            return this.fOpenChoices;
        }

        public Map<NamespaceDeclaration, SourceRange[]> getChoicesSourceRanges() {
            return this.fSourceRanges;
        }

        private static class UnresolvedTypeData {
            final Identifier ref;
            final int typeKinds;
            final List<TypeNameMatch> foundInfos;

            public UnresolvedTypeData(Identifier ref) {
                this.ref = ref;
                this.typeKinds = ASTResolving.getPossibleTypeKinds((ASTNode)ref);
                this.foundInfos = new ArrayList<TypeNameMatch>(3);
            }

            public void addInfo(TypeNameMatch info) {
                int i = this.foundInfos.size() - 1;
                while (i >= 0) {
                    TypeNameMatch curr = this.foundInfos.get(i);
                    if (curr.getTypeContainerName().equals(info.getTypeContainerName())) {
                        return;
                    }
                    --i;
                }
                this.foundInfos.add(info);
            }
        }
    }

    private static class UnresolvableImportMatcher {
        private final Map<NamespaceDeclaration, Map<String, Set<String>>> fTypeImportsBySimpleName;

        static UnresolvableImportMatcher forProgram(Program cu) {
            HashMap<NamespaceDeclaration, Map<String, Set<String>>> typeImportsBySimpleName = new HashMap<NamespaceDeclaration, Map<String, Set<String>>>();
            List namespaces = cu.getNamespaceDeclarations();
            if (namespaces.size() > 0) {
                for (NamespaceDeclaration namespace : namespaces) {
                    UnresolvableImportMatcher.forProgram(cu, namespace, typeImportsBySimpleName);
                }
            } else {
                UnresolvableImportMatcher.forProgram(cu, null, typeImportsBySimpleName);
            }
            return new UnresolvableImportMatcher(typeImportsBySimpleName);
        }

        private static void forProgram(Program cu, NamespaceDeclaration namespace, Map<NamespaceDeclaration, Map<String, Set<String>>> typeImportsBySimpleName) {
            typeImportsBySimpleName.put(namespace, new HashMap());
            Collection<UseStatement> unresolvableImports = UnresolvableImportMatcher.determineUnresolvableImports(cu, namespace);
            for (UseStatement importDeclaration : unresolvableImports) {
                for (UseStatementPart part : importDeclaration.parts()) {
                    String qualifiedName = part.getName().getName();
                    String simpleName = qualifiedName.substring(qualifiedName.lastIndexOf(92) + 1);
                    Map<String, Set<String>> importsBySimpleName = typeImportsBySimpleName.get(namespace);
                    Set<String> importsWithSimpleName = importsBySimpleName.get(simpleName);
                    if (importsWithSimpleName == null) {
                        importsWithSimpleName = new HashSet<String>();
                        importsBySimpleName.put(simpleName, importsWithSimpleName);
                    }
                    importsWithSimpleName.add(qualifiedName);
                }
            }
        }

        private static Collection<UseStatement> determineUnresolvableImports(Program program, NamespaceDeclaration namespaceDeclaration) {
            IProblem[] problems;
            ArrayList<UseStatement> unresolvableImports = new ArrayList<UseStatement>(program.getUseStatements(namespaceDeclaration).size());
            IProblem[] iProblemArray = problems = program.getProblems();
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                UseStatement problematicImport;
                IProblem problem = iProblemArray[n2];
                IProblemIdentifier id = ((DefaultProblem)problem).getID();
                if (id == PHPProblemIdentifier.ImportNotFound && (problematicImport = UnresolvableImportMatcher.getProblematicImport(problem, program)) != null) {
                    unresolvableImports.add(problematicImport);
                }
                ++n2;
            }
            return unresolvableImports;
        }

        private static UseStatement getProblematicImport(IProblem problem, Program cu) {
            ASTNode coveringNode = new ProblemLocation(problem).getCoveringNode(cu);
            if (coveringNode != null && coveringNode instanceof UseStatement) {
                return (UseStatement)coveringNode;
            }
            return null;
        }

        private UnresolvableImportMatcher(Map<NamespaceDeclaration, Map<String, Set<String>>> typeImportsBySimpleName) {
            this.fTypeImportsBySimpleName = typeImportsBySimpleName;
        }

        private Set<String> matchImports(NamespaceDeclaration namespace, String simpleName) {
            Map<String, Set<String>> importsBySimpleName = this.fTypeImportsBySimpleName.get(namespace);
            Set<String> matchingSingleImports = importsBySimpleName.get(simpleName);
            if (matchingSingleImports != null) {
                return Collections.unmodifiableSet(matchingSingleImports);
            }
            Set<String> matchingOnDemandImports = importsBySimpleName.get("*");
            if (matchingOnDemandImports != null) {
                return Collections.unmodifiableSet(matchingOnDemandImports);
            }
            return Collections.emptySet();
        }

        Set<String> matchTypeImports(NamespaceDeclaration namespace, String simpleName) {
            return this.matchImports(namespace, simpleName);
        }
    }
}

