/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.wizards.NameGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LocationGroup
extends Observable
implements Observer,
IStringButtonAdapter,
IDialogFieldListener {
    protected final SelectionButtonDialogField fWorkspaceRadio;
    protected final SelectionButtonDialogField fExternalRadio;
    protected final StringButtonDialogField fLocation;
    private IEnvironment[] environments;
    private String fPreviousExternalLocation;
    private int localEnv;
    protected SelectionButtonDialogField fLocalServerRadio;
    protected ComboDialogField fSeverLocationList;
    private String[] docRootArray;
    private NameGroup fNameGroup;
    private Shell shell;
    private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.dltk.ui.last.external.project";

    public LocationGroup(Composite composite, NameGroup nameGroup, Shell shell) {
        this.fNameGroup = nameGroup;
        this.shell = shell;
        int numColumns = 3;
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_title);
        this.fWorkspaceRadio = new SelectionButtonDialogField(16);
        this.fWorkspaceRadio.setDialogFieldListener((IDialogFieldListener)this);
        this.fWorkspaceRadio.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_workspace_desc);
        this.fExternalRadio = new SelectionButtonDialogField(16);
        this.fExternalRadio.setDialogFieldListener((IDialogFieldListener)this);
        this.fExternalRadio.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_external_desc);
        this.fLocation = new StringButtonDialogField((IStringButtonAdapter)this);
        this.fLocation.setDialogFieldListener((IDialogFieldListener)this);
        this.fLocation.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_locationLabel_desc);
        this.fLocation.setButtonLabel(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_browseButton_desc);
        this.fWorkspaceRadio.setSelection(true);
        this.fExternalRadio.setSelection(false);
        this.fPreviousExternalLocation = "";
        this.fWorkspaceRadio.doFillIntoGrid((Composite)group, 3);
        this.fExternalRadio.doFillIntoGrid((Composite)group, 3);
        this.fLocation.doFillIntoGrid((Composite)group, 3);
        LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
        this.fExternalRadio.attachDialogFields(new DialogField[]{this.fLocation});
        this.environments = EnvironmentManager.getEnvironments();
        String[] items = new String[this.environments.length];
        this.localEnv = 0;
        int i = 0;
        while (i < items.length) {
            items[i] = this.environments[i].getName();
            if (this.environments[i].isLocal()) {
                this.localEnv = i;
            }
            ++i;
        }
        this.createLocalServersGroup(group, 3);
    }

    public boolean isExistingLocation() {
        return this.fExternalRadio.isSelected();
    }

    protected void createLocalServersGroup(Group group, int numColumns) {
        Server[] servers = ServersManager.getServers();
        ArrayList<String> docRoots = new ArrayList<String>();
        int i = 0;
        while (i < servers.length) {
            String docRoot = servers[i].getDocumentRoot();
            if (docRoot != null && !"".equals(docRoot.trim())) {
                docRoots.add(docRoot);
            }
            ++i;
        }
        if (docRoots.size() > 0) {
            this.fLocalServerRadio = new SelectionButtonDialogField(16);
            this.fLocalServerRadio.setDialogFieldListener((IDialogFieldListener)this);
            this.fLocalServerRadio.setLabelText(PHPUIMessages.PHPProjectWizardFirstPage_localServerLabel);
            this.fLocalServerRadio.setSelection(false);
            this.fLocalServerRadio.doFillIntoGrid((Composite)group, numColumns);
            this.fSeverLocationList = new ComboDialogField(8);
            this.fSeverLocationList.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_locationLabel_desc);
            this.fSeverLocationList.doFillIntoGrid((Composite)group, numColumns);
            this.fSeverLocationList.setEnabled(false);
            this.docRootArray = new String[docRoots.size()];
            docRoots.toArray(this.docRootArray);
            this.fSeverLocationList.setItems(this.docRootArray);
            this.fSeverLocationList.selectItem(0);
            this.fLocalServerRadio.attachDialogField((DialogField)this.fSeverLocationList);
            this.fWorkspaceRadio.setSelection(false);
            this.fLocalServerRadio.setSelection(true);
        } else {
            this.createNoLocalServersFound(group, numColumns);
        }
    }

    protected void createNoLocalServersFound(Group group, int numColumns) {
    }

    public boolean isInLocalServer() {
        return this.fLocalServerRadio != null && this.fLocalServerRadio.isSelected();
    }

    protected void fireEvent() {
        this.setChanged();
        this.notifyObservers();
    }

    protected String getDefaultPath(String name) {
        IEnvironment environment = this.getEnvironment();
        if (environment != null && environment.isLocal()) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }
        return "";
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.isInWorkspace()) {
            this.fLocation.setText(this.getDefaultPath(this.fNameGroup.getName()));
        }
        if (this.docRootArray != null && this.docRootArray.length > 0) {
            int index = this.fSeverLocationList.getSelectionIndex();
            String[] items = this.getDocItems(this.docRootArray);
            this.fSeverLocationList.setItems(items);
            this.fSeverLocationList.selectItem(index);
        }
        this.fireEvent();
    }

    private String[] getDocItems(String[] docRootArray) {
        String[] items = new String[docRootArray.length];
        int i = 0;
        while (i < docRootArray.length) {
            items[i] = String.valueOf(docRootArray[i]) + File.separator + this.fNameGroup.getName();
            ++i;
        }
        return items;
    }

    public IPath getLocation() {
        if (this.isInWorkspace()) {
            return Platform.getLocation();
        }
        if (this.isInLocalServer()) {
            return new Path(this.fSeverLocationList.getText());
        }
        return new Path(this.fLocation.getText().trim());
    }

    public boolean isInWorkspace() {
        return this.fWorkspaceRadio.isSelected();
    }

    public IEnvironment getEnvironment() {
        if (this.fWorkspaceRadio.isSelected()) {
            return EnvironmentManager.getEnvironmentById((String)"org.eclipse.dltk.core.environment.localEnvironment");
        }
        return this.environments[this.localEnv];
    }

    public void changeControlPressed(DialogField field) {
        String selectedDirectory;
        IEnvironment environment = this.getEnvironment();
        IEnvironmentUI environmentUI = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
        if (environmentUI != null && (selectedDirectory = environmentUI.selectFolder(this.shell)) != null) {
            this.fLocation.setText(selectedDirectory);
            DLTKUIPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
        }
    }

    public void dialogFieldChanged(DialogField field) {
        if (field == this.fWorkspaceRadio) {
            boolean checked = this.fWorkspaceRadio.isSelected();
            if (checked) {
                this.fPreviousExternalLocation = this.fLocation.getText();
                this.fLocation.setText(this.getDefaultPath(this.fNameGroup.getName()));
            } else {
                IEnvironment environment = this.getEnvironment();
                if (environment != null && environment.isLocal()) {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                } else {
                    this.fLocation.setText("");
                }
            }
        }
        this.fireEvent();
    }
}

