/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.coordinates.rcp;

import com.google.common.eventbus.EventBus;
import com.google.common.io.Files;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.recommenders.coordinates.IDependencyListener;
import org.eclipse.recommenders.coordinates.IProjectCoordinateAdvisorService;
import org.eclipse.recommenders.coordinates.rcp.EclipseProjectCoordinateAdvisorService;
import org.eclipse.recommenders.internal.coordinates.rcp.CoordinatesRcpPreferences;
import org.eclipse.recommenders.internal.coordinates.rcp.EclipseDependencyListener;
import org.eclipse.recommenders.internal.coordinates.rcp.ManualProjectCoordinateAdvisor;
import org.eclipse.recommenders.internal.coordinates.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.ui.IWorkbench;

public class CoordinatesRcpModule
extends AbstractModule {
    public static final String IDENTIFIED_PROJECT_COORDINATES = "IDENTIFIED_PACKAGE_FRAGMENT_ROOTS";
    public static final String MANUAL_MAPPINGS = "MANUAL_MAPPINGS";

    protected void configure() {
        this.bind(EclipseProjectCoordinateAdvisorService.class).in(Scopes.SINGLETON);
        this.bind(IProjectCoordinateAdvisorService.class).to(EclipseProjectCoordinateAdvisorService.class);
        this.bind(ManualProjectCoordinateAdvisor.class).in(Scopes.SINGLETON);
        this.createAndBindPerWorkspaceNamedFile("caches/manual-mappings.json", MANUAL_MAPPINGS);
        this.createAndBindPerWorkspaceNamedFile("caches/identified-project-coordinates.json", IDENTIFIED_PROJECT_COORDINATES);
    }

    private void createAndBindPerWorkspaceNamedFile(String fileName, String name) {
        File workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        File dotRecommenders = new File(workspaceRoot, ".recommenders");
        this.createAndBindNamedFile(fileName, name, dotRecommenders);
    }

    private void createAndBindNamedFile(String fileName, String name, File stateLocation) {
        File file = new File(stateLocation, fileName);
        try {
            Files.createParentDirs((File)file);
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_BIND_FILE_NAME, (Object[])new Object[]{fileName, e});
        }
        this.bind(File.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)file);
    }

    @Singleton
    @Provides
    public IDependencyListener provideDependencyListener(EventBus bus) {
        return new EclipseDependencyListener(bus);
    }

    @Provides
    @Singleton
    public CoordinatesRcpPreferences provide(IWorkbench wb, EventBus bus) {
        IEclipseContext context = (IEclipseContext)wb.getService(IEclipseContext.class);
        context.set(EventBus.class, (Object)bus);
        return (CoordinatesRcpPreferences)ContextInjectionFactory.make(CoordinatesRcpPreferences.class, (IEclipseContext)context);
    }
}

