/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.server.commands;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.remote.internal.proxy.server.commands.AbstractServerCommand;
import org.eclipse.remote.proxy.protocol.core.SerializableFileInfo;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class ServerChildInfosCommand
extends AbstractServerCommand {
    private IFileInfo[] infos;
    private final URI uri;
    private final OutputStream out;

    public ServerChildInfosCommand(StreamChannel chan, String path) {
        this.out = chan.getOutputStream();
        this.uri = URI.create("file:" + path);
    }

    @Override
    public void exec() throws ProxyException {
        try {
            this.infos = EFS.getStore((URI)this.uri).childInfos(0, null);
        }
        catch (CoreException e) {
            throw new ProxyException(e.getMessage());
        }
        new Thread(new CommandRunner()).start();
    }

    private class CommandRunner
    implements Runnable {
        private CommandRunner() {
        }

        @Override
        public void run() {
            try {
                DataOutputStream result = new DataOutputStream(ServerChildInfosCommand.this.out);
                result.writeInt(ServerChildInfosCommand.this.infos.length);
                int i = 0;
                while (i < ServerChildInfosCommand.this.infos.length) {
                    SerializableFileInfo sInfo = new SerializableFileInfo(ServerChildInfosCommand.this.infos[i]);
                    sInfo.writeObject(result);
                    ++i;
                }
                result.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

