/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.DocumentationService;

public abstract class StandardDocumentationService
extends DocumentationService {
    protected static final String LINE_BREAK = "[br/]";
    protected static final String PARAGRAPH_BREAK = "[pbr/]";
    private String content;
    private List<DocumentationService.Topic> topics;

    @Override
    protected void init() {
        super.init();
        StringBuilder content = new StringBuilder();
        ArrayList<DocumentationService.Topic> topics = new ArrayList<DocumentationService.Topic>();
        this.initStandardDocumentationService(content, topics);
        this.content = content.toString();
        this.topics = Collections.unmodifiableList(topics);
    }

    protected abstract void initStandardDocumentationService(StringBuilder var1, List<DocumentationService.Topic> var2);

    @Override
    public final String content() {
        return this.content;
    }

    @Override
    public final List<DocumentationService.Topic> topics() {
        return this.topics;
    }

    protected static final List<DocumentationService.Topic> convert(Documentation.Topic[] topics, LocalizationService localization) {
        if (topics.length == 0) {
            return Collections.emptyList();
        }
        if (topics.length == 1) {
            return Collections.singletonList(StandardDocumentationService.convert(topics[0], localization));
        }
        ArrayList<DocumentationService.Topic> resources = new ArrayList<DocumentationService.Topic>(topics.length);
        Documentation.Topic[] topicArray = topics;
        int n = topics.length;
        int n2 = 0;
        while (n2 < n) {
            Documentation.Topic topic = topicArray[n2];
            resources.add(StandardDocumentationService.convert(topic, localization));
            ++n2;
        }
        return resources;
    }

    protected static final DocumentationService.Topic convert(Documentation.Topic topic, LocalizationService localization) {
        String label = localization.text(topic.label().trim(), CapitalizationType.NO_CAPS, false);
        return new DocumentationService.Topic(label, topic.url());
    }
}

