/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.scope;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.sphinx.emf.compare.scope.IModelComparisonScope;

public class ModelComparisonScope
extends DefaultComparisonScope
implements IModelComparisonScope {
    private IFile leftFile;
    private IFile rightFile;
    private IComparisonScope delegate;

    public ModelComparisonScope(Notifier left, Notifier right, Notifier origin) {
        super(left, right, origin);
    }

    public ModelComparisonScope(IFile leftFile, IFile rightFile) {
        this(leftFile, rightFile, null);
    }

    public ModelComparisonScope(IFile leftFile, IFile rightFile, IComparisonScope delegate) {
        super(null, null, null);
        this.leftFile = leftFile;
        this.rightFile = rightFile;
        this.delegate = delegate;
    }

    @Override
    public IComparisonScope getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(IComparisonScope delegate) {
        this.delegate = delegate;
    }

    @Override
    public IFile getLeftFile() {
        return this.leftFile;
    }

    public void setLeftFile(IFile leftFile) {
        this.leftFile = leftFile;
    }

    @Override
    public IFile getRightFile() {
        return this.rightFile;
    }

    public void setRightFile(IFile rightFile) {
        this.rightFile = rightFile;
    }

    @Override
    public boolean isFileBasedComparison() {
        return this.leftFile != null && this.rightFile != null;
    }

    public Notifier getLeft() {
        if (this.delegate != null) {
            return this.delegate.getLeft();
        }
        return super.getLeft();
    }

    public Notifier getRight() {
        if (this.delegate != null) {
            return this.delegate.getRight();
        }
        return super.getRight();
    }

    public Notifier getOrigin() {
        if (this.delegate != null) {
            return this.delegate.getOrigin();
        }
        return super.getOrigin();
    }
}

