/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.commands;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandHandler;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.tcf.internal.cdt.ui.commands.StepIntoSelectionLocation;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IBreakpoints;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;

public class TCFStepIntoSelectionHandler
implements IDebugCommandHandler {
    public void canExecute(final IEnabledStateRequest request) {
        final StepIntoSelectionLocation l = new StepIntoSelectionLocation();
        l.getTextLocation((IDebugCommandRequest)request);
        if (!l.isValid()) {
            request.setEnabled(false);
            request.done();
            return;
        }
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (l.node.isDisposed()) {
                    this.done(null, false);
                    return;
                }
                TCFDataCache cache = l.node.getState();
                if (!cache.validate((Runnable)this)) {
                    return;
                }
                if (cache.getError() != null) {
                    this.done(cache.getError(), false);
                    return;
                }
                TCFContextState state = (TCFContextState)cache.getData();
                this.done(null, state != null && state.is_suspended);
            }

            private void done(Throwable e, boolean enabled) {
                if (e != null) {
                    request.setStatus((IStatus)new Status(4, "org.eclipse.tcf.cdt.ui", 4, TCFModel.getErrorMessage((Throwable)e, (boolean)true), e));
                }
                request.setEnabled(enabled);
                request.done();
            }
        });
    }

    public boolean execute(final IDebugCommandRequest request) {
        final StepIntoSelectionLocation l = new StepIntoSelectionLocation();
        l.getTargetFunction(request);
        if (!l.isValid()) {
            request.done();
            return true;
        }
        Protocol.invokeLater((Runnable)new Runnable(){
            boolean run_to_line_done;
            boolean req_done;
            String bp_id;

            @Override
            public void run() {
                if (l.node.isDisposed()) {
                    this.done(null);
                    return;
                }
                IChannel channel = l.node.getChannel();
                if (this.bp_id == null) {
                    IBreakpoints breakpoints = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
                    if (breakpoints == null) {
                        this.done(new Exception("Cannot set breakpoint."));
                        return;
                    }
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put("File", l.text_file);
                    properties.put("Line", l.text_line);
                    if (this.run_to_line_done) {
                        if (!$assertionsDisabled && l.target_function == null) {
                            throw new AssertionError();
                        }
                        properties.put("Location", l.target_function.getElementName());
                        properties.put("SkipPrologue", true);
                    }
                    properties.put("ContextIds", new String[]{l.node.getID()});
                    properties.put("Enabled", Boolean.TRUE);
                    properties.put("Service", "RunControl");
                    this.bp_id = "Step." + l.node.getID();
                    properties.put("ID", this.bp_id);
                    breakpoints.add(properties, new IBreakpoints.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error != null) {
                                bp_id = null;
                                this.done(error);
                            } else {
                                this.run();
                            }
                        }
                    });
                    return;
                }
                final IRunControl run_ctrl = (IRunControl)channel.getRemoteService(IRunControl.class);
                if (run_ctrl == null) {
                    this.done(new Exception("Cannot resume."));
                    return;
                }
                TCFDataCache state_cache = l.node.getState();
                if (!state_cache.validate((Runnable)this)) {
                    return;
                }
                if (state_cache.getError() != null) {
                    this.done(state_cache.getError());
                    return;
                }
                TCFContextState state = (TCFContextState)state_cache.getData();
                if (state == null || !state.is_suspended) {
                    this.done(null);
                    return;
                }
                TCFDataCache ctx_cache = l.node.getRunContext();
                if (!ctx_cache.validate((Runnable)this)) {
                    return;
                }
                if (ctx_cache.getError() != null) {
                    this.done(ctx_cache.getError());
                    return;
                }
                final String node_id = l.node.getID();
                run_ctrl.addListener(new IRunControl.RunControlListener(){

                    private void suspended() {
                        run_ctrl.removeListener((IRunControl.RunControlListener)this);
                        if (!run_to_line_done) {
                            run_to_line_done = true;
                            if (l.target_function != null) {
                                if (!$assertionsDisabled && bp_id == null) {
                                    throw new AssertionError();
                                }
                                IChannel channel = l.node.getChannel();
                                IBreakpoints breakpoints = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
                                breakpoints.remove(new String[]{bp_id}, new IBreakpoints.DoneCommand(){

                                    public void doneCommand(IToken token, Exception error) {
                                        if (error != null) {
                                            this.done(error);
                                        } else {
                                            this.run();
                                        }
                                    }
                                });
                                bp_id = null;
                                return;
                            }
                        }
                        this.done(null);
                    }

                    public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
                        if (node_id.equals(context)) {
                            this.suspended();
                        }
                    }

                    public void contextResumed(String context) {
                    }

                    public void contextRemoved(String[] context_ids) {
                        String[] stringArray = context_ids;
                        int n = context_ids.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String context = stringArray[n2];
                            if (node_id.equals(context)) {
                                this.suspended();
                                return;
                            }
                            ++n2;
                        }
                    }

                    public void contextException(String context, String msg) {
                    }

                    public void contextChanged(IRunControl.RunControlContext[] contexts) {
                    }

                    public void contextAdded(IRunControl.RunControlContext[] contexts) {
                    }

                    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
                        String[] stringArray = suspended_ids;
                        int n = suspended_ids.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String context2 = stringArray[n2];
                            if (node_id.equals(context2)) {
                                this.suspended();
                                return;
                            }
                            ++n2;
                        }
                    }

                    public void containerResumed(String[] context_ids) {
                    }
                });
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)ctx_cache.getData();
                ctx.resume(0, 1, new IRunControl.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            this.done(error);
                        } else if (!req_done) {
                            req_done = true;
                            request.done();
                        }
                    }
                });
            }

            private void done(Throwable e) {
                if (this.bp_id != null) {
                    IChannel channel = l.node.getChannel();
                    IBreakpoints breakpoints = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
                    breakpoints.remove(new String[]{this.bp_id}, new IBreakpoints.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            this.done(error);
                        }
                    });
                    this.bp_id = null;
                    return;
                }
                if (!this.req_done) {
                    if (e != null) {
                        request.setStatus((IStatus)new Status(4, "org.eclipse.tcf.cdt.ui", 4, TCFModel.getErrorMessage((Throwable)e, (boolean)true), e));
                    }
                    this.req_done = true;
                    request.done();
                }
            }
        });
        return true;
    }
}

