/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;

public class RemoteFolderTree
extends RemoteFolder {
    public static RemoteFolderTree fromBytes(RemoteFolderTree parent, IResource local, byte[] bytes) throws CVSException {
        Assert.isNotNull((Object)bytes);
        Assert.isTrue((local.getType() != 1 ? 1 : 0) != 0);
        FolderSyncInfo syncInfo = FolderSyncInfo.getFolderSyncInfo(bytes);
        return new RemoteFolderTree(parent, local.getName(), KnownRepositories.getInstance().getRepository(syncInfo.getRoot()), syncInfo.getRepository(), syncInfo.getTag(), syncInfo.getIsStatic());
    }

    public RemoteFolderTree(RemoteFolder parent, ICVSRepositoryLocation repository, String repositoryRelativePath, CVSTag tag) {
        super(parent, repository, repositoryRelativePath, tag);
    }

    public RemoteFolderTree(RemoteFolder parent, String name, ICVSRepositoryLocation repository, String repositoryRelativePath, CVSTag tag) {
        this(parent, name, repository, repositoryRelativePath, tag, false);
    }

    public RemoteFolderTree(RemoteFolder parent, String name, ICVSRepositoryLocation repository, String repositoryRelativePath, CVSTag tag, boolean isStatic) {
        super(parent, name, repository, repositoryRelativePath, tag, isStatic);
    }

    @Override
    public ICVSRemoteResource[] getMembers(CVSTag tagName, IProgressMonitor monitor) throws CVSException {
        if (this.getChildren() == null) {
            this.setChildren(super.getMembers(tagName, monitor));
        }
        return this.getChildren();
    }

    @Override
    public void setChildren(ICVSRemoteResource[] children) {
        super.setChildren(children);
    }

    @Override
    public void acceptChildren(ICVSResourceVisitor visitor) throws CVSException {
        ICVSRemoteResource[] children = this.getChildren();
        if (children == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            children[i].accept(visitor);
            ++i;
        }
    }
}

